/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jmx.http.rpc;

import com.facebook.airlift.jmx.http.rpc.HttpMBeanServerCredentials;
import com.facebook.airlift.jmx.http.rpc.HttpMBeanServerRpc;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXServerErrorException;

public class MBeanServerServlet
extends HttpServlet {
    private static final String BASE_PATH = "/v1/jmx/mbeanServer/";
    private final MBeanServer mbeanServer;
    private final HttpMBeanServerCredentials credentials;

    @Inject
    public MBeanServerServlet(MBeanServer mbeanServer, HttpMBeanServerCredentials credentials) {
        this.mbeanServer = mbeanServer;
        this.credentials = credentials;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object[] args;
        if (this.credentials != null && !this.credentials.authenticate(HttpMBeanServerCredentials.fromBasicAuthHeader(request.getHeader("Authorization")))) {
            this.sendErrorResponse(response, 401, new SecurityException("Invalid credentials"));
            return;
        }
        String method = this.extractJmxMethodFromPath(request);
        if (method == null) {
            this.sendErrorResponse(response, 400, new NullPointerException("method is null"));
            return;
        }
        try {
            args = (Object[])new ObjectInputStream((InputStream)request.getInputStream()).readObject();
        }
        catch (Exception e) {
            this.sendErrorResponse(response, 400, new IllegalArgumentException("Request does not contain a serialized Object[]"));
            return;
        }
        try {
            Object result = null;
            if ("getMBeanInfo".equals(method)) {
                result = this.mbeanServer.getMBeanInfo((ObjectName)args[0]);
            } else if ("queryMBeans".equals(method)) {
                result = this.mbeanServer.queryMBeans((ObjectName)args[0], (QueryExp)args[1]);
            } else if ("queryNames".equals(method)) {
                result = this.mbeanServer.queryNames((ObjectName)args[0], (QueryExp)args[1]);
            } else if ("getAttribute".equals(method)) {
                result = this.mbeanServer.getAttribute((ObjectName)args[0], (String)args[1]);
            } else if ("getAttributes".equals(method)) {
                result = this.mbeanServer.getAttributes((ObjectName)args[0], (String[])args[1]);
            } else if ("setAttribute".equals(method)) {
                this.mbeanServer.setAttribute((ObjectName)args[0], (Attribute)args[1]);
            } else if ("setAttributes".equals(method)) {
                result = this.mbeanServer.setAttributes((ObjectName)args[0], (AttributeList)args[1]);
            } else if ("invoke".equals(method)) {
                result = this.mbeanServer.invoke((ObjectName)args[0], (String)args[1], (Object[])args[2], (String[])args[3]);
            } else if ("getMBeanCount".equals(method)) {
                result = this.mbeanServer.getMBeanCount();
            } else if ("isRegistered".equals(method)) {
                result = this.mbeanServer.isRegistered((ObjectName)args[0]);
            } else if ("getObjectInstance".equals(method)) {
                result = this.mbeanServer.getObjectInstance((ObjectName)args[0]);
            } else if ("getDefaultDomain".equals(method)) {
                result = this.mbeanServer.getDefaultDomain();
            } else if ("getDomains".equals(method)) {
                result = this.mbeanServer.getDomains();
            } else if ("isInstanceOf".equals(method)) {
                result = this.mbeanServer.isInstanceOf((ObjectName)args[0], (String)args[1]);
            } else {
                this.sendErrorResponse(response, 400, new IllegalArgumentException("Unknown method " + method));
                return;
            }
            response.getOutputStream().write(HttpMBeanServerRpc.createSuccessResponse(result));
        }
        catch (Exception e) {
            this.sendErrorResponse(response, 500, e);
        }
        catch (Error e) {
            this.sendErrorResponse(response, 500, new JMXServerErrorException("Internal error", e));
        }
    }

    private String extractJmxMethodFromPath(HttpServletRequest request) {
        String path = request.getRequestURI();
        if (!path.startsWith(BASE_PATH)) {
            return null;
        }
        if ((path = path.substring(BASE_PATH.length())).contains("/")) {
            return null;
        }
        return path;
    }

    private void sendErrorResponse(HttpServletResponse response, int status, Exception exception) throws IOException {
        response.setStatus(status);
        response.getOutputStream().write(HttpMBeanServerRpc.createExceptionResponse(exception));
    }
}

