/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jmx.http.rpc;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.discovery.client.DiscoveryBinder;
import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.http.server.HttpServerInfo;
import com.facebook.airlift.http.server.TheAdminServlet;
import com.facebook.airlift.jmx.http.rpc.HttpMBeanServerCredentials;
import com.facebook.airlift.jmx.http.rpc.JmxHttpRpcConfig;
import com.facebook.airlift.jmx.http.rpc.MBeanServerServlet;
import com.facebook.airlift.node.NodeInfo;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import jakarta.inject.Inject;
import jakarta.servlet.Servlet;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Map;
import javax.inject.Provider;

@Beta
public class JmxHttpRpcModule
implements Module {
    private final Class<? extends Annotation> bindingAnnotation;

    public JmxHttpRpcModule() {
        this(TheAdminServlet.class);
    }

    public JmxHttpRpcModule(Class<? extends Annotation> bindingAnnotation) {
        this.bindingAnnotation = bindingAnnotation;
    }

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(Servlet.class).annotatedWith(this.bindingAnnotation).to(MBeanServerServlet.class).in(Scopes.SINGLETON);
        binder.bind((TypeLiteral)new TypeLiteral<Map<String, String>>(){}).annotatedWith(this.bindingAnnotation).toInstance((Object)ImmutableMap.of());
        ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder = ServiceAnnouncement.serviceAnnouncement((String)"jmx-http-rpc");
        DiscoveryBinder.discoveryBinder((Binder)binder).bindServiceAnnouncement((Provider)new JmxHttpRpcAnnouncementProvider(serviceAnnouncementBuilder));
        ConfigBinder.configBinder((Binder)binder).bindConfig(JmxHttpRpcConfig.class);
    }

    @Provides
    public HttpMBeanServerCredentials createCredentials(JmxHttpRpcConfig config) {
        return new HttpMBeanServerCredentials(config.getUsername(), config.getPassword());
    }

    static class JmxHttpRpcAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private final ServiceAnnouncement.ServiceAnnouncementBuilder builder;
        private HttpServerInfo httpServerInfo;
        private NodeInfo nodeInfo;

        public JmxHttpRpcAnnouncementProvider(ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder) {
            this.builder = serviceAnnouncementBuilder;
        }

        @Inject
        public synchronized void setHttpServerInfo(HttpServerInfo httpServerInfo) {
            this.httpServerInfo = httpServerInfo;
        }

        @Inject
        public synchronized void setNodeInfo(NodeInfo nodeInfo) {
            this.nodeInfo = nodeInfo;
        }

        public synchronized ServiceAnnouncement get() {
            if (this.httpServerInfo.getAdminUri() != null) {
                URI adminUri = this.httpServerInfo.getAdminUri();
                if (adminUri.getScheme().equals("http")) {
                    this.builder.addProperty("http", adminUri.toString());
                    this.builder.addProperty("http-external", this.httpServerInfo.getAdminExternalUri().toString());
                } else if (adminUri.getScheme().equals("https")) {
                    this.builder.addProperty("https", adminUri.toString());
                    this.builder.addProperty("https-external", this.httpServerInfo.getAdminExternalUri().toString());
                }
            }
            if (this.nodeInfo.getBinarySpec() != null) {
                this.builder.addProperty("binary", this.nodeInfo.getBinarySpec());
            }
            if (this.nodeInfo.getConfigSpec() != null) {
                this.builder.addProperty("config", this.nodeInfo.getConfigSpec());
            }
            return this.builder.build();
        }
    }
}

