/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jmx.http.rpc;

import com.facebook.airlift.jmx.http.rpc.HttpMBeanServerRpc;

public class HttpMBeanServerCredentials {
    private final String username;
    private final String password;

    public HttpMBeanServerCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public boolean authenticate(HttpMBeanServerCredentials userCredentials) {
        if (this.username == null && this.password == null) {
            return true;
        }
        return HttpMBeanServerCredentials.equals(this.username, userCredentials.username) && HttpMBeanServerCredentials.equals(this.password, userCredentials.password);
    }

    public static HttpMBeanServerCredentials fromBasicAuthHeader(String authHeader) {
        if (authHeader == null || !authHeader.startsWith("Basic ")) {
            return new HttpMBeanServerCredentials(null, null);
        }
        String credentials = new String(HttpMBeanServerRpc.base64Decode(authHeader.substring("Basic ".length())));
        int index = credentials.indexOf(58);
        if (index >= 0) {
            return new HttpMBeanServerCredentials(credentials.substring(0, index), credentials.substring(index + 1));
        }
        return new HttpMBeanServerCredentials(credentials, null);
    }

    public String toBasicAuthHeader() {
        return "Basic " + HttpMBeanServerRpc.base64Encode(String.format("%s:%s", this.username == null ? "" : this.username, this.password == null ? "" : this.password));
    }

    private static boolean equals(Object left, Object right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }
}

