/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jmx;

import com.facebook.airlift.jmx.JmxAgent;
import com.facebook.airlift.jmx.JmxConfig;
import com.facebook.airlift.jmx.NetUtils;
import com.facebook.airlift.log.Logger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.rmi.server.RemoteObject;
import javax.inject.Inject;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import sun.management.jmxremote.ConnectorBootstrap;
import sun.rmi.server.UnicastRef;

class JmxAgent8
implements JmxAgent {
    private static final Logger log = Logger.get(JmxAgent.class);
    private static final Class<?> AGENT_CLASS = JmxAgent8.getAgentClass();
    private final JMXServiceURL url;

    @Inject
    public JmxAgent8(JmxConfig config) throws IOException {
        HostAndPort address = JmxAgent8.getRunningAgentAddress(config.getRmiRegistryPort(), config.getRmiServerPort());
        if (address != null) {
            log.info("JMX agent already running and listening on %s", new Object[]{address});
        } else {
            int registryPort = config.getRmiRegistryPort() == null ? NetUtils.findUnusedPort() : config.getRmiRegistryPort();
            int serverPort = 0;
            if (config.getRmiServerPort() != null) {
                serverPort = config.getRmiServerPort();
            }
            System.setProperty("com.sun.management.jmxremote", "true");
            System.setProperty("com.sun.management.jmxremote.port", Integer.toString(registryPort));
            System.setProperty("com.sun.management.jmxremote.rmi.port", Integer.toString(serverPort));
            System.setProperty("com.sun.management.jmxremote.authenticate", "false");
            System.setProperty("com.sun.management.jmxremote.ssl", "false");
            try {
                AGENT_CLASS.getMethod("startAgent", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                JMXServiceURL url = new JMXServiceURL("rmi", null, registryPort);
                address = HostAndPort.fromParts((String)url.getHost(), (int)url.getPort());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            log.info("JMX agent started and listening on %s", new Object[]{address});
        }
        this.url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", address.getHost(), address.getPort()));
    }

    @Override
    public JMXServiceURL getUrl() {
        return this.url;
    }

    @VisibleForTesting
    static HostAndPort getRunningAgentAddress(Integer registryPort, Integer serverPort) {
        int actualRegistryPort;
        JMXConnectorServer jmxServer;
        try {
            jmxServer = JmxAgent8.getField(AGENT_CLASS, JMXConnectorServer.class, "jmxServer");
            RemoteObject registry = JmxAgent8.getField(ConnectorBootstrap.class, RemoteObject.class, "registry");
            if (jmxServer == null || registry == null) {
                log.warn("Cannot determine if JMX agent is already running (not an Oracle JVM?). Will try to start it manually.");
                return null;
            }
            actualRegistryPort = ((UnicastRef)registry.getRef()).getLiveRef().getPort();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Cannot determine if JMX agent is already running. Will try to start it manually.");
            return null;
        }
        Preconditions.checkState((actualRegistryPort > 0 ? 1 : 0) != 0, (String)"Expected actual RMI registry port to be > 0, actual: %s", (int)actualRegistryPort);
        if (registryPort != null && registryPort != 0) {
            Preconditions.checkArgument((actualRegistryPort == registryPort ? 1 : 0) != 0, (String)"JMX agent is already running, but actual RMI registry port (%s) doesn't match configured port (%s)", (int)actualRegistryPort, (Object)registryPort);
        }
        if (serverPort != null && serverPort != 0) {
            int actualServerPort = jmxServer.getAddress().getPort();
            Preconditions.checkArgument((actualServerPort == serverPort ? 1 : 0) != 0, (String)"JMX agent is already running, but actual RMI server port (%s) doesn't match configured port (%s)", (int)actualServerPort, (Object)serverPort);
        }
        return HostAndPort.fromParts((String)jmxServer.getAddress().getHost(), (int)actualRegistryPort);
    }

    private static <T> T getField(Class<?> clazz, Class<T> returnType, String name) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        try {
            return returnType.cast(field.get(clazz));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Field %s in class %s is not of type %s, actual: %s", name, clazz.getName(), returnType.getName(), field.getType().getName()), e);
        }
    }

    private static Class<?> getAgentClass() {
        try {
            return Class.forName("sun.management.Agent");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

