/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jmx;

import com.facebook.airlift.jmx.JmxAgent;
import com.facebook.airlift.jmx.JmxConfig;
import com.facebook.airlift.jmx.NetUtils;
import com.facebook.airlift.log.Logger;
import com.google.common.net.HostAndPort;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.Properties;
import javax.management.remote.JMXServiceURL;

class JmxAgent9
implements JmxAgent {
    private static final Logger log = Logger.get(JmxAgent.class);
    private static final String JMX_REGISTRY_PORT = "com.sun.management.jmxremote.port";
    private static final String JMX_SERVER_PORT = "com.sun.management.jmxremote.rmi.port";
    private static final String ALLOW_SELF_ATTACH = "jdk.attach.allowAttachSelf";
    private final JMXServiceURL url;

    @Inject
    public JmxAgent9(JmxConfig config) throws IOException {
        int registryPort;
        Integer existingRegistryPort = Integer.getInteger(JMX_REGISTRY_PORT);
        Integer configuredRegistryPort = config.getRmiRegistryPort();
        if (existingRegistryPort != null) {
            if (configuredRegistryPort != null && !existingRegistryPort.equals(configuredRegistryPort)) {
                throw new RuntimeException(String.format("System property '%s=%s' does match configured RMI registry port %s", JMX_REGISTRY_PORT, existingRegistryPort, configuredRegistryPort));
            }
            if (existingRegistryPort.equals(0)) {
                throw new RuntimeException(String.format("JMX agent already running on an unknown port (system property '%s' is 0)", JMX_REGISTRY_PORT));
            }
            registryPort = existingRegistryPort;
        } else {
            registryPort = configuredRegistryPort != null ? configuredRegistryPort : NetUtils.findUnusedPort();
        }
        int serverPort = 0;
        Integer existingServerPort = Integer.getInteger(JMX_SERVER_PORT);
        Integer configuredServerPort = config.getRmiServerPort();
        if (!Objects.equals(existingServerPort, configuredServerPort)) {
            throw new RuntimeException(String.format("System property '%s=%s' does match configured RMI server port %s", JMX_SERVER_PORT, existingServerPort, configuredServerPort));
        }
        if (configuredServerPort != null && !configuredServerPort.equals(0)) {
            serverPort = configuredServerPort;
        }
        JMXServiceURL jmxUrl = new JMXServiceURL("rmi", null, registryPort);
        HostAndPort address = HostAndPort.fromParts((String)jmxUrl.getHost(), (int)jmxUrl.getPort());
        if (existingRegistryPort == null) {
            JmxAgent9.startJmxAgent(registryPort, serverPort);
            log.info("JMX agent started and listening on %s", new Object[]{address});
        } else {
            log.info("JMX agent already running and listening on %s", new Object[]{address});
        }
        this.url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", address.getHost(), address.getPort()));
    }

    @Override
    public JMXServiceURL getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startJmxAgent(int registryPort, int serverPort) throws IOException {
        try {
            VirtualMachine virtualMachine = VirtualMachine.attach(Long.toString(JmxAgent9.getProcessId()));
            try {
                virtualMachine.startLocalManagementAgent();
                Properties properties = new Properties();
                properties.setProperty(JMX_REGISTRY_PORT, Integer.toString(registryPort));
                properties.setProperty(JMX_SERVER_PORT, Integer.toString(serverPort));
                properties.setProperty("com.sun.management.jmxremote.authenticate", "false");
                properties.setProperty("com.sun.management.jmxremote.ssl", "false");
                virtualMachine.startManagementAgent(properties);
            }
            finally {
                virtualMachine.detach();
            }
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            if (!Boolean.getBoolean(ALLOW_SELF_ATTACH)) {
                throw new IOException(String.format("%s (try adding '-D%s=true' to the JVM config)", e, ALLOW_SELF_ATTACH));
            }
            throw e;
        }
    }

    private static long getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int index = name.indexOf(64);
        if (index < 1) {
            throw new AssertionError((Object)"Cannot get process PID");
        }
        try {
            return Long.parseLong(name.substring(0, index));
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)"Cannot get process PID");
        }
    }

    public static void main(String[] args) throws IOException {
        new JmxAgent9(new JmxConfig());
        new JmxAgent9(new JmxConfig());
    }
}

