/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.json;

import com.facebook.airlift.json.Car;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.Truck;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Car.class, name="car"), @JsonSubTypes.Type(value=Truck.class, name="truck")})
public interface Vehicle {
    public static void validateVehicleJsonCodec(JsonCodec<Vehicle> jsonCodec) {
        Vehicle expected = new Car("bmw");
        String json = jsonCodec.toJson((Object)expected);
        Assert.assertEquals((Object)jsonCodec.fromJson(json), (Object)expected);
        Assert.assertTrue((boolean)json.contains("\"@type\" : \"car\""));
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Object)jsonCodec.fromJson(bytes), (Object)expected);
        expected = new Truck("volvo");
        json = jsonCodec.toJson((Object)expected);
        Assert.assertEquals((Object)jsonCodec.fromJson(json), (Object)expected);
        Assert.assertTrue((boolean)json.contains("\"@type\" : \"truck\""));
        bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Object)jsonCodec.fromJson(bytes), (Object)expected);
    }

    public static void validateVehicleListJsonCodec(JsonCodec<List<Vehicle>> jsonCodec) {
        ImmutableList expected = ImmutableList.of((Object)new Car("bmw"), (Object)new Truck("volvo"));
        String json = jsonCodec.toJson((Object)expected);
        Assert.assertEquals((Collection)((Collection)jsonCodec.fromJson(json)), (Collection)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Collection)((Collection)jsonCodec.fromJson(bytes)), (Collection)expected);
    }

    public static void validateVehicleMapJsonCodec(JsonCodec<Map<String, Vehicle>> jsonCodec) {
        ImmutableMap expected = ImmutableMap.builder().put((Object)"bmw", (Object)new Car("bmw")).put((Object)"volvo", (Object)new Truck("volvo")).build();
        String json = jsonCodec.toJson((Object)expected);
        Assert.assertEquals((Map)((Map)jsonCodec.fromJson(json)), (Map)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Map)((Map)jsonCodec.fromJson(bytes)), (Map)expected);
    }
}

