/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.json.smile;

import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.Person;
import com.facebook.airlift.json.TestJsonModule;
import com.facebook.airlift.json.smile.ForSmile;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.airlift.json.smile.SmileCodecFactory;
import com.facebook.airlift.json.smile.SmileModule;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSmileSupport {
    private ObjectMapper objectMapper;

    @BeforeClass
    public void setUp() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SmileModule(), binder -> {
            JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(TestJsonModule.SuperDuperNameList.class).toInstance((Object)ToStringSerializer.instance);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(TestJsonModule.SuperDuperNameList.class).to(TestJsonModule.SuperDuperNameListDeserializer.class);
        }});
        this.objectMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, ForSmile.class));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.objectMapper = null;
    }

    @Test
    public void testSmileCodecFactoryBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SmileModule()});
        SmileCodecFactory codecFactory = (SmileCodecFactory)injector.getInstance(SmileCodecFactory.class);
        SmileCodec personJsonCodec = codecFactory.smileCodec(Person.class);
        Person person = new Person();
        person.setName("name");
        person.setLastName(Optional.of("lastname"));
        Person actual = (Person)personJsonCodec.fromSmile(personJsonCodec.toSmile((Object)person));
        Assert.assertEquals((Object)actual, (Object)person);
    }

    @Test
    public void testObjectMapper() throws IOException {
        byte[] bytes = this.objectMapper.writeValueAsBytes((Object)TestJsonModule.CAR);
        TestJsonModule.Car car = (TestJsonModule.Car)this.objectMapper.readValue(bytes, TestJsonModule.CAR.getClass());
        Assert.assertEquals((Object)car, (Object)TestJsonModule.CAR);
    }

    @Test
    public void testFieldDetection() throws Exception {
        Map<String, Object> actual = this.createCarMap();
        Assert.assertEquals(actual.keySet(), (Set)ImmutableSet.of((Object)"make", (Object)"model", (Object)"year", (Object)"purchased", (Object)"nameList"));
    }

    @Test
    public void testDateTimeRendered() throws Exception {
        Map<String, Object> actual = this.createCarMap();
        Assert.assertEquals((Object)actual.get("purchased"), (Object)ISODateTimeFormat.dateTime().print((ReadableInstant)TestJsonModule.CAR.getPurchased()));
    }

    @Test
    public void testGuavaRoundTrip() throws Exception {
        ImmutableList list = ImmutableList.of((Object)3, (Object)5, (Object)8);
        byte[] json = this.objectMapper.writeValueAsBytes((Object)list);
        List actual = (List)this.objectMapper.readValue(json, (TypeReference)new TypeReference<ImmutableList<Integer>>(){});
        Assert.assertEquals((Collection)actual, (Collection)list);
    }

    @Test
    public void testIgnoreUnknownFields() throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>(this.createCarMap());
        data.put("unknown", "bogus");
        Assert.assertEquals((Object)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes(data), TestJsonModule.Car.class), (Object)TestJsonModule.CAR);
    }

    @Test
    public void testPropertyNamesFromParameterNames() throws Exception {
        TestJsonModule.NoJsonPropertiesInJsonCreator value = new TestJsonModule.NoJsonPropertiesInJsonCreator("first value", "second value");
        TestJsonModule.NoJsonPropertiesInJsonCreator mapped = (TestJsonModule.NoJsonPropertiesInJsonCreator)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)value), TestJsonModule.NoJsonPropertiesInJsonCreator.class);
        Assert.assertEquals((String)mapped.getFirst(), (String)"first value");
        Assert.assertEquals((String)mapped.getSecond(), (String)"second value");
    }

    @Test
    public void testJsonValueAndStaticFactoryMethod() throws Exception {
        TestJsonModule.JsonValueAndStaticFactoryMethod value = TestJsonModule.JsonValueAndStaticFactoryMethod.valueOf("some value");
        TestJsonModule.JsonValueAndStaticFactoryMethod mapped = (TestJsonModule.JsonValueAndStaticFactoryMethod)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)value), TestJsonModule.JsonValueAndStaticFactoryMethod.class);
        Assert.assertEquals((String)mapped.getValue(), (String)"some value");
    }

    private Map<String, Object> createCarMap() throws IOException {
        return (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)TestJsonModule.CAR), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

