/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.json.smile;

import com.facebook.airlift.json.ImmutablePerson;
import com.facebook.airlift.json.Person;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.airlift.json.smile.SmileCodecFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSmileCodecFactory {
    private SmileCodecFactory codecFactory;

    @BeforeClass
    public void setUp() {
        this.codecFactory = new SmileCodecFactory();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.codecFactory = null;
    }

    @Test
    public void testSmileCodec() {
        SmileCodec smileCodec = this.codecFactory.smileCodec(Person.class);
        Person expected = new Person().setName("person-1").setRocks(true);
        byte[] smile = smileCodec.toSmile((Object)expected);
        Assert.assertEquals((Object)smileCodec.fromSmile(smile), (Object)expected);
    }

    @Test
    public void testListSmileCodec() {
        SmileCodec smileCodec = this.codecFactory.listSmileCodec(Person.class);
        this.validatePersonListSmileCodec((SmileCodec<List<Person>>)smileCodec);
    }

    @Test
    public void testTypeTokenList() {
        SmileCodec smileCodec = this.codecFactory.smileCodec(new TypeToken<List<Person>>(){}.getType());
        this.validatePersonListSmileCodec((SmileCodec<List<Person>>)smileCodec);
    }

    @Test
    public void testListNullValues() {
        SmileCodec smileCodec = this.codecFactory.listSmileCodec(String.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add(null);
        list.add("abc");
        Assert.assertEquals((Collection)((Collection)smileCodec.fromSmile(smileCodec.toSmile(list))), list);
    }

    @Test
    public void testMapSmileCodec() {
        SmileCodec smileCodec = this.codecFactory.mapSmileCodec(String.class, Person.class);
        this.validatePersonMapSmileCodec((SmileCodec<Map<String, Person>>)smileCodec);
    }

    @Test
    public void testMapSmileCodecFromSmileCodec() {
        SmileCodec smileCodec = this.codecFactory.mapSmileCodec(String.class, this.codecFactory.smileCodec(Person.class));
        this.validatePersonMapSmileCodec((SmileCodec<Map<String, Person>>)smileCodec);
    }

    @Test
    public void testTypeLiteralMap() {
        SmileCodec smileCodec = this.codecFactory.smileCodec(new TypeToken<Map<String, Person>>(){}.getType());
        this.validatePersonMapSmileCodec((SmileCodec<Map<String, Person>>)smileCodec);
    }

    @Test
    public void testMapNullValues() {
        SmileCodec smileCodec = this.codecFactory.mapSmileCodec(String.class, String.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x", null);
        map.put("y", "abc");
        Assert.assertEquals((Map)((Map)smileCodec.fromSmile(smileCodec.toSmile(map))), map);
    }

    @Test
    public void testImmutableSmileCodec() {
        SmileCodec smileCodec = this.codecFactory.smileCodec(ImmutablePerson.class);
        ImmutablePerson expected = new ImmutablePerson("person-1", true);
        Assert.assertEquals((Object)smileCodec.fromSmile(smileCodec.toSmile((Object)expected)), (Object)expected);
    }

    @Test
    public void testImmutableListSmileCodec() {
        SmileCodec smileCodec = this.codecFactory.listSmileCodec(ImmutablePerson.class);
        this.validateImmutablePersonListSmileCodec((SmileCodec<List<ImmutablePerson>>)smileCodec);
    }

    @Test
    public void testImmutableListSmileCodecFromSmileCodec() {
        SmileCodec smileCodec = this.codecFactory.listSmileCodec(this.codecFactory.smileCodec(ImmutablePerson.class));
        this.validateImmutablePersonListSmileCodec((SmileCodec<List<ImmutablePerson>>)smileCodec);
    }

    @Test
    public void testImmutableTypeTokenList() {
        SmileCodec smileCodec = this.codecFactory.smileCodec(new TypeToken<List<ImmutablePerson>>(){}.getType());
        this.validateImmutablePersonListSmileCodec((SmileCodec<List<ImmutablePerson>>)smileCodec);
    }

    @Test
    public void testImmutableMapSmileCodec() {
        SmileCodec smileCodec = this.codecFactory.mapSmileCodec(String.class, ImmutablePerson.class);
        this.validateImmutablePersonMapSmileCodec((SmileCodec<Map<String, ImmutablePerson>>)smileCodec);
    }

    @Test
    public void testImmutableMapSmileCodecFromSmileCodec() {
        SmileCodec smileCodec = this.codecFactory.mapSmileCodec(String.class, this.codecFactory.smileCodec(ImmutablePerson.class));
        this.validateImmutablePersonMapSmileCodec((SmileCodec<Map<String, ImmutablePerson>>)smileCodec);
    }

    @Test
    public void testImmutableTypeTokenMap() {
        SmileCodec smileCodec = this.codecFactory.smileCodec(new TypeToken<Map<String, ImmutablePerson>>(){}.getType());
        this.validateImmutablePersonMapSmileCodec((SmileCodec<Map<String, ImmutablePerson>>)smileCodec);
    }

    @Test
    public void testWriteBytes() {
        SmileCodec personCodec = this.codecFactory.smileCodec(ImmutablePerson.class);
        ImmutablePerson person = new ImmutablePerson("person-1", true);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        personCodec.writeBytes((OutputStream)output, (Object)person);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        Assert.assertEquals((Object)personCodec.readBytes((InputStream)input), (Object)person);
    }

    private void validatePersonListSmileCodec(SmileCodec<List<Person>> smileCodec) {
        ImmutableList expected = ImmutableList.of((Object)new Person().setName("person-1").setRocks(true), (Object)new Person().setName("person-2").setRocks(true), (Object)new Person().setName("person-3").setRocks(true));
        byte[] smileBytes = smileCodec.toSmile((Object)expected);
        List actual = (List)smileCodec.fromSmile(smileBytes);
        Assert.assertEquals((Collection)actual, (Collection)expected);
    }

    private void validatePersonMapSmileCodec(SmileCodec<Map<String, Person>> smileCodec) {
        ImmutableMap expected = ImmutableMap.builder().put((Object)"person-1", (Object)new Person().setName("person-1").setRocks(true)).put((Object)"person-2", (Object)new Person().setName("person-2").setRocks(true)).put((Object)"person-3", (Object)new Person().setName("person-3").setRocks(true)).build();
        byte[] smileBytes = smileCodec.toSmile((Object)expected);
        Map actual = (Map)smileCodec.fromSmile(smileBytes);
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    private void validateImmutablePersonMapSmileCodec(SmileCodec<Map<String, ImmutablePerson>> smileCodec) {
        ImmutableMap expected = ImmutableMap.builder().put((Object)"person-1", (Object)new ImmutablePerson("person-1", true)).put((Object)"person-2", (Object)new ImmutablePerson("person-2", true)).put((Object)"person-3", (Object)new ImmutablePerson("person-3", true)).build();
        byte[] smileBytes = smileCodec.toSmile((Object)expected);
        Map actual = (Map)smileCodec.fromSmile(smileBytes);
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    private void validateImmutablePersonListSmileCodec(SmileCodec<List<ImmutablePerson>> smileCodec) {
        ImmutableList expected = ImmutableList.of((Object)new ImmutablePerson("person-1", true), (Object)new ImmutablePerson("person-2", true), (Object)new ImmutablePerson("person-3", true));
        byte[] smileBytes = smileCodec.toSmile((Object)expected);
        List actual = (List)smileCodec.fromSmile(smileBytes);
        Assert.assertEquals((Collection)actual, (Collection)expected);
    }
}

