/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.json.smile;

import com.facebook.airlift.json.smile.ForSmile;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.airlift.json.smile.SmileObjectMapperProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.Beta;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Beta
public class SmileCodecFactory {
    private final Provider<ObjectMapper> objectMapperProvider;

    public SmileCodecFactory() {
        this(new SmileObjectMapperProvider());
    }

    @Inject
    public SmileCodecFactory(@ForSmile Provider<ObjectMapper> smileObjectMapperProvider) {
        this.objectMapperProvider = Objects.requireNonNull(smileObjectMapperProvider, "smileObjectMapperProvider is null");
    }

    public <T> SmileCodec<T> smileCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new SmileCodec(this.createObjectMapper(), type);
    }

    public <T> SmileCodec<T> smileCodec(Type type) {
        Objects.requireNonNull(type, "type is null");
        return new SmileCodec(this.createObjectMapper(), type);
    }

    public <T> SmileCodec<T> smileCodec(TypeToken<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new SmileCodec(this.createObjectMapper(), type.getType());
    }

    public <T> SmileCodec<List<T>> listSmileCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type).getType();
        return new SmileCodec<List<T>>(this.createObjectMapper(), listType);
    }

    public <T> SmileCodec<List<T>> listSmileCodec(SmileCodec<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type.getTypeToken()).getType();
        return new SmileCodec<List<T>>(this.createObjectMapper(), listType);
    }

    public <K, V> SmileCodec<Map<K, V>> mapSmileCodec(Class<K> keyType, Class<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
        return new SmileCodec<Map<K, V>>(this.createObjectMapper(), mapType);
    }

    public <K, V> SmileCodec<Map<K, V>> mapSmileCodec(Class<K> keyType, SmileCodec<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType.getTypeToken()).getType();
        return new SmileCodec<Map<K, V>>(this.createObjectMapper(), mapType);
    }

    private ObjectMapper createObjectMapper() {
        return (ObjectMapper)this.objectMapperProvider.get();
    }
}

