/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.json;

import com.facebook.airlift.json.Codec;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.airlift.json.LengthLimitedWriter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JsonCodec<T>
implements Codec<T> {
    private static final java.util.function.Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = () -> ((Supplier)Suppliers.memoize(() -> new JsonObjectMapperProvider().get().enable(SerializationFeature.INDENT_OUTPUT))).get();
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    public static <T> JsonCodec<T> jsonCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    public static <T> JsonCodec<T> jsonCodec(TypeToken<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type.getType());
    }

    public static <T> JsonCodec<List<T>> listJsonCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type).getType();
        return new JsonCodec<List<T>>(OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <T> JsonCodec<List<T>> listJsonCodec(JsonCodec<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type.getTypeToken()).getType();
        return new JsonCodec<List<T>>(OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, Class<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
        return new JsonCodec<Map<K, V>>(OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    public static <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, JsonCodec<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType.getTypeToken()).getType();
        return new JsonCodec<Map<K, V>>(OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    JsonCodec(ObjectMapper mapper, Type type) {
        this.mapper = mapper;
        this.type = type;
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public Type getType() {
        return this.type;
    }

    public T fromJson(String json) throws IllegalArgumentException {
        try {
            return (T)this.mapper.readerFor(this.javaType).readValue(json);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON string for %s", this.javaType), e);
        }
    }

    public String toJson(T instance) throws IllegalArgumentException {
        try {
            return this.mapper.writerFor(this.javaType).writeValueAsString(instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<String> toJsonWithLengthLimit(T instance, int lengthLimit) {
        try (StringWriter stringWriter = new StringWriter();){
            Optional<String> optional;
            try (LengthLimitedWriter lengthLimitedWriter = new LengthLimitedWriter(stringWriter, lengthLimit);){
                this.mapper.writeValue((Writer)lengthLimitedWriter, instance);
                optional = Optional.of(stringWriter.getBuffer().toString());
            }
            return optional;
        }
        catch (LengthLimitedWriter.LengthLimitExceededException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), e);
        }
    }

    public T fromJson(byte[] json) throws IllegalArgumentException {
        try {
            return (T)this.mapper.readerFor(this.javaType).readValue(json);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON bytes for %s", this.javaType), e);
        }
    }

    public byte[] toJsonBytes(T instance) throws IllegalArgumentException {
        try {
            return this.mapper.writerFor(this.javaType).writeValueAsBytes(instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), e);
        }
    }

    @Override
    public byte[] toBytes(T instance) {
        return this.toJsonBytes(instance);
    }

    @Override
    public T fromBytes(byte[] bytes) {
        return this.fromJson(bytes);
    }

    @Override
    public void writeBytes(OutputStream output, T instance) {
        try {
            this.mapper.writeValue(output, instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), e);
        }
    }

    @Override
    public T readBytes(InputStream input) {
        try {
            return (T)this.mapper.readValue(input, this.javaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON bytes for %s", this.javaType), e);
        }
    }

    TypeToken<T> getTypeToken() {
        return TypeToken.of((Type)this.type);
    }
}

