/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.log;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.airlift.log.LoggingConfiguration;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestLoggingConfiguration {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((LoggingConfiguration)ConfigAssertions.recordDefaults(LoggingConfiguration.class)).setConsoleEnabled(true).setLogPath(null).setMaxSize(new DataSize(100.0, DataSize.Unit.MEGABYTE)).setMaxSizeInBytes(new DataSize(100.0, DataSize.Unit.MEGABYTE).toBytes()).setMaxHistory(30).setLevelsFile(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"log.enable-console", (Object)"false").put((Object)"log.path", (Object)"/tmp/log.log").put((Object)"log.max-size", (Object)"1kB").put((Object)"log.max-size-in-bytes", (Object)"1024").put((Object)"log.max-history", (Object)"3").put((Object)"log.levels-file", (Object)"/tmp/levels.txt").build();
        LoggingConfiguration expected = new LoggingConfiguration().setConsoleEnabled(false).setLogPath("/tmp/log.log").setMaxSize(new DataSize(1.0, DataSize.Unit.KILOBYTE)).setMaxSizeInBytes(1024L).setMaxHistory(3).setLevelsFile("/tmp/levels.txt");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

