/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.log;

import com.facebook.airlift.log.Level;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.log.Logging;
import com.facebook.airlift.log.LoggingConfiguration;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestLogging {
    private File tempDir;

    @BeforeMethod
    public void setup() throws IOException {
        this.tempDir = Files.createTempDir();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testRecoverTempFiles() throws IOException {
        LoggingConfiguration configuration = new LoggingConfiguration();
        configuration.setLogPath(new File(this.tempDir, "launcher.log").getPath());
        File logFile1 = new File(this.tempDir, "test1.log");
        Files.touch((File)logFile1);
        File logFile2 = new File(this.tempDir, "test2.log");
        Files.touch((File)logFile2);
        File tempLogFile1 = new File(this.tempDir, "temp1.tmp");
        Files.touch((File)tempLogFile1);
        File tempLogFile2 = new File(this.tempDir, "temp2.tmp");
        Files.touch((File)tempLogFile2);
        Logging logging = Logging.initialize();
        logging.configure(configuration);
        Assert.assertTrue((boolean)logFile1.exists());
        Assert.assertTrue((boolean)logFile2.exists());
        Assert.assertFalse((boolean)tempLogFile1.exists());
        Assert.assertFalse((boolean)tempLogFile2.exists());
        Assert.assertTrue((boolean)new File(this.tempDir, "temp1.log").exists());
        Assert.assertTrue((boolean)new File(this.tempDir, "temp2.log").exists());
    }

    @Test
    public void testPropagatesLevels() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testPropagatesLevels");
        logging.setLevel("testPropagatesLevels", Level.ERROR);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevels", Level.WARN);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevels", Level.INFO);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevels", Level.DEBUG);
        Assert.assertTrue((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
    }

    @Test
    public void testPropagatesLevelsHierarchical() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testPropagatesLevelsHierarchical.child");
        logging.setLevel("testPropagatesLevelsHierarchical", Level.ERROR);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevelsHierarchical", Level.WARN);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevelsHierarchical", Level.INFO);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
        logging.setLevel("testPropagatesLevelsHierarchical", Level.DEBUG);
        Assert.assertTrue((boolean)logger.isDebugEnabled());
        Assert.assertTrue((boolean)logger.isInfoEnabled());
    }

    @Test
    public void testChildLevelOverridesParent() throws Exception {
        Logging logging = Logging.initialize();
        Logger logger = Logger.get((String)"testChildLevelOverridesParent.child");
        logging.setLevel("testChildLevelOverridesParent", Level.DEBUG);
        logging.setLevel("testChildLevelOverridesParent.child", Level.ERROR);
        Assert.assertFalse((boolean)logger.isDebugEnabled());
        Assert.assertFalse((boolean)logger.isInfoEnabled());
    }
}

