/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.log;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.LegacyConfig;
import com.facebook.airlift.units.DataSize;

public class LoggingConfiguration {
    private boolean consoleEnabled = true;
    private String logPath;
    private DataSize maxSize = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private int maxHistory = 30;
    private String levelsFile;

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    @Config(value="log.enable-console")
    public LoggingConfiguration setConsoleEnabled(boolean consoleEnabled) {
        this.consoleEnabled = consoleEnabled;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    @LegacyConfig(value={"log.output-file"})
    @Config(value="log.path")
    public LoggingConfiguration setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    @Deprecated
    public long getMaxSizeInBytes() {
        return this.maxSize.toBytes();
    }

    @Deprecated
    @Config(value="log.max-size-in-bytes")
    public LoggingConfiguration setMaxSizeInBytes(long maxSize) {
        this.maxSize = new DataSize((double)maxSize, DataSize.Unit.BYTE);
        return this;
    }

    public DataSize getMaxSize() {
        return this.maxSize;
    }

    @Config(value="log.max-size")
    public LoggingConfiguration setMaxSize(DataSize maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    @Config(value="log.max-history")
    public LoggingConfiguration setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
        return this;
    }

    public String getLevelsFile() {
        return this.levelsFile;
    }

    @Config(value="log.levels-file")
    public LoggingConfiguration setLevelsFile(String levelsFile) {
        this.levelsFile = levelsFile;
        return this;
    }
}

