/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.log;

import com.facebook.airlift.log.Logger;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestLogger {
    private MockHandler handler;
    private Logger logger;
    private java.util.logging.Logger inner;

    @BeforeMethod
    public void setUp() throws Exception {
        this.handler = new MockHandler();
        this.inner = java.util.logging.Logger.getAnonymousLogger();
        this.inner.setUseParentHandlers(false);
        this.inner.setLevel(Level.ALL);
        this.inner.addHandler(this.handler);
        this.logger = new Logger(this.inner);
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() {
        Assert.assertTrue((boolean)this.handler.isEmpty(), (String)"Some log messages were not verified by test");
    }

    @Test
    public void testIsDebugEnabled() {
        this.inner.setLevel(Level.FINE);
        Assert.assertTrue((boolean)this.logger.isDebugEnabled());
        this.inner.setLevel(Level.INFO);
        Assert.assertFalse((boolean)this.logger.isDebugEnabled());
        this.inner.setLevel(Level.WARNING);
        Assert.assertFalse((boolean)this.logger.isDebugEnabled());
        this.inner.setLevel(Level.SEVERE);
        Assert.assertFalse((boolean)this.logger.isDebugEnabled());
    }

    @Test
    public void testDebugFormat() {
        this.inner.setLevel(Level.FINE);
        this.logger.debug("hello, %s", new Object[]{"you"});
        this.assertLog(Level.FINE, "hello, you");
    }

    @Test
    public void testInfoFormat() {
        this.inner.setLevel(Level.INFO);
        this.logger.info("hello, %s", new Object[]{"you"});
        this.assertLog(Level.INFO, "hello, you");
    }

    @Test
    public void testWarnFormat() {
        this.inner.setLevel(Level.WARNING);
        this.logger.warn("hello, %s", new Object[]{"you"});
        this.assertLog(Level.WARNING, "hello, you");
        Throwable exception = new Throwable();
        this.logger.warn(exception, "got exception: %s", new Object[]{"foo"});
        this.assertLog(Level.WARNING, "got exception: foo", exception);
    }

    @Test
    public void testErrorFormat() {
        this.logger.error("hello, %s", new Object[]{"you"});
        this.assertLog(Level.SEVERE, "hello, you");
        Throwable exception = new Throwable();
        this.logger.error(exception, "got exception: %s", new Object[]{"foo"});
        this.assertLog(Level.SEVERE, "got exception: foo", exception);
        Throwable exception2 = new Throwable("the message");
        this.logger.error(exception2);
        this.assertLog(Level.SEVERE, exception2.getMessage(), exception2);
    }

    @Test
    public void testDebugShortCircuit() {
        this.inner.setLevel(Level.OFF);
        this.logger.debug("hello");
        Assert.assertTrue((boolean)this.handler.isEmpty());
    }

    @Test
    public void testInfoShortCircuit() {
        this.inner.setLevel(Level.OFF);
        this.logger.info("hello");
        Assert.assertTrue((boolean)this.handler.isEmpty());
    }

    @Test
    public void testWarnShortCircuit() {
        this.inner.setLevel(Level.OFF);
        this.logger.warn("hello");
        Assert.assertTrue((boolean)this.handler.isEmpty());
    }

    @Test
    public void testWarnWithThrowableShortCircuit() {
        this.inner.setLevel(Level.OFF);
        Throwable e = new Throwable();
        this.logger.warn(e, "hello");
        Assert.assertTrue((boolean)this.handler.isEmpty());
    }

    @Test
    public void testErrorShortCircuit() {
        this.inner.setLevel(Level.OFF);
        this.logger.error("hello");
        Assert.assertTrue((boolean)this.handler.isEmpty());
    }

    @Test
    public void testErrorWithThrowableShortCircuit() {
        this.inner.setLevel(Level.OFF);
        Throwable e = new Throwable();
        this.logger.error(e, "hello");
        Assert.assertTrue((boolean)this.handler.isEmpty());
    }

    @Test
    public void testErrorWithThrowableNoMessageShortCircuit() {
        this.inner.setLevel(Level.OFF);
        Throwable e = new Throwable();
        this.logger.error(e);
        Assert.assertTrue((boolean)this.handler.isEmpty());
    }

    @Test
    public void testInsufficientArgsLogsErrorForDebug() {
        String format = "some message: %s, %d";
        String param = "blah";
        this.logger.debug(format, new Object[]{param});
        this.assertLogLike(Level.SEVERE, (List<String>)ImmutableList.of((Object)"Invalid format", (Object)"DEBUG", (Object)format, (Object)param), IllegalArgumentException.class);
        this.assertLog(Level.FINE, String.format("'%s' [%s]", format, param));
    }

    @Test
    public void testInsufficientArgsLogsErrorForInfo() {
        String format = "some message: %s, %d";
        String param = "blah";
        this.logger.info(format, new Object[]{param});
        this.assertLogLike(Level.SEVERE, (List<String>)ImmutableList.of((Object)"Invalid format", (Object)"INFO", (Object)format, (Object)param), IllegalArgumentException.class);
        this.assertLog(Level.INFO, String.format("'%s' [%s]", format, param));
    }

    @Test
    public void testInsufficientArgsLogsErrorForWarn() {
        String format = "some message: %s, %d";
        String param = "blah";
        this.logger.warn(format, new Object[]{param});
        this.assertLogLike(Level.SEVERE, (List<String>)ImmutableList.of((Object)"Invalid format", (Object)"WARN", (Object)format, (Object)param), IllegalArgumentException.class);
        this.assertLog(Level.WARNING, String.format("'%s' [%s]", format, param));
    }

    @Test
    public void testInsufficientArgsLogsErrorForError() {
        String format = "some message: %s, %d";
        String param = "blah";
        this.logger.error(format, new Object[]{param});
        this.assertLogLike(Level.SEVERE, (List<String>)ImmutableList.of((Object)"Invalid format", (Object)"ERROR", (Object)format, (Object)param), IllegalArgumentException.class);
        this.assertLog(Level.SEVERE, String.format("'%s' [%s]", format, param));
    }

    @Test
    public void testInsufficientArgsLogsOriginalExceptionForWarn() {
        Throwable exception = new Throwable("foo");
        String format = "some message: %s, %d";
        String param = "blah";
        this.logger.warn(exception, format, new Object[]{param});
        this.assertLogLike(Level.SEVERE, (List<String>)ImmutableList.of((Object)"Invalid format", (Object)"WARN", (Object)format, (Object)param), IllegalArgumentException.class);
        this.assertLog(Level.WARNING, String.format("'%s' [%s]", format, param), exception);
    }

    @Test
    public void testInsufficientArgsLogsOriginalExceptionForError() {
        Throwable exception = new Throwable("foo");
        String format = "some message: %s, %d";
        String param = "blah";
        this.logger.error(exception, format, new Object[]{param});
        this.assertLogLike(Level.SEVERE, (List<String>)ImmutableList.of((Object)"Invalid format", (Object)"ERROR", (Object)format, (Object)param), IllegalArgumentException.class);
        this.assertLog(Level.SEVERE, String.format("'%s' [%s]", format, param), exception);
    }

    private void assertLog(Level level, String message, Throwable exception) {
        LogRecord record = this.handler.takeRecord();
        Assert.assertEquals((Object)record.getLevel(), (Object)level);
        Assert.assertEquals((String)record.getMessage(), (String)message);
        Assert.assertEquals((Object)record.getThrown(), (Object)exception);
    }

    private void assertLog(Level level, String message) {
        LogRecord record = this.handler.takeRecord();
        Assert.assertEquals((Object)record.getLevel(), (Object)level);
        Assert.assertEquals((String)record.getMessage(), (String)message);
        Assert.assertNull((Object)record.getThrown());
    }

    private void assertLogLike(Level level, List<String> substrings, Class<? extends Throwable> exceptionClass) {
        LogRecord record = this.handler.takeRecord();
        Assert.assertEquals((Object)record.getLevel(), (Object)level);
        Assert.assertTrue((boolean)this.stringContains(record.getMessage(), substrings));
        Assert.assertTrue((boolean)exceptionClass.isAssignableFrom(record.getThrown().getClass()));
    }

    private boolean stringContains(String value, List<String> substrings) {
        for (String str : substrings) {
            if (value.contains(str)) continue;
            return false;
        }
        return true;
    }

    private static class MockHandler
    extends Handler {
        private final List<LogRecord> records = new ArrayList<LogRecord>();

        private MockHandler() {
            this.setLevel(Level.ALL);
        }

        @Override
        public void publish(LogRecord record) {
            this.records.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        public LogRecord takeRecord() {
            Assert.assertTrue((!this.records.isEmpty() ? 1 : 0) != 0, (String)"No messages logged");
            return this.records.remove(0);
        }

        public boolean isEmpty() {
            return this.records.isEmpty();
        }
    }
}

