/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.node;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.airlift.node.NodeConfig;
import com.facebook.airlift.testing.ValidationAssertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.InetAddresses;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.testng.annotations.Test;

public class TestNodeConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeConfig)ConfigAssertions.recordDefaults(NodeConfig.class)).setEnvironment(null).setPool("general").setNodeId(null).setNodeInternalAddress(null).setNodeBindIp((String)null).setNodeExternalAddress(null).setLocation(null).setBinarySpec(null).setConfigSpec(null).setInternalAddressSource(NodeConfig.AddressSource.IP));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node.environment", (Object)"environment").put((Object)"node.pool", (Object)"pool").put((Object)"node.id", (Object)"nodeId").put((Object)"node.internal-address", (Object)"internal").put((Object)"node.bind-ip", (Object)"10.11.12.13").put((Object)"node.external-address", (Object)"external").put((Object)"node.location", (Object)"location").put((Object)"node.binary-spec", (Object)"binary").put((Object)"node.config-spec", (Object)"config").put((Object)"node.internal-address-source", (Object)"HOSTNAME").build();
        NodeConfig expected = new NodeConfig().setEnvironment("environment").setPool("pool").setNodeId("nodeId").setNodeInternalAddress("internal").setNodeBindIp(InetAddresses.forString((String)"10.11.12.13")).setNodeExternalAddress("external").setLocation("location").setBinarySpec("binary").setConfigSpec("config").setInternalAddressSource(NodeConfig.AddressSource.HOSTNAME);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidations() {
        ValidationAssertions.assertValidates((Object)new NodeConfig().setEnvironment("test").setNodeId(UUID.randomUUID().toString()));
        ValidationAssertions.assertFailsValidation((Object)new NodeConfig().setNodeId("abc/123"), (String)"nodeId", (String)"is malformed", Pattern.class);
        ValidationAssertions.assertFailsValidation((Object)new NodeConfig(), (String)"environment", (String)"may not be null", NotNull.class);
        ValidationAssertions.assertFailsValidation((Object)new NodeConfig().setEnvironment("FOO"), (String)"environment", (String)"is malformed", Pattern.class);
        ValidationAssertions.assertFailsValidation((Object)new NodeConfig().setPool("FOO"), (String)"pool", (String)"is malformed", Pattern.class);
    }
}

