/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.security.csr;

import com.facebook.airlift.security.csr.SignatureAlgorithmIdentifier;
import com.google.common.io.BaseEncoding;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSignatureAlgorithmIdentifier {
    @Test
    public void test() throws Exception {
        int verifiedCount = 0;
        for (Map.Entry entry : SignatureAlgorithmIdentifier.getAllSignatureAlgorithmIdentifiers().entrySet()) {
            AlgorithmIdentifier algorithmIdentifier;
            SignatureAlgorithmIdentifier signatureAlgorithmIdentifier = (SignatureAlgorithmIdentifier)entry.getValue();
            Assert.assertEquals((String)signatureAlgorithmIdentifier.getName(), (String)((String)entry.getKey()));
            try {
                algorithmIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find((String)entry.getKey());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            Assert.assertEquals((String)signatureAlgorithmIdentifier.getOid(), (String)algorithmIdentifier.getAlgorithm().getId());
            Assert.assertEquals((String)BaseEncoding.base16().encode(signatureAlgorithmIdentifier.getEncoded()), (String)BaseEncoding.base16().encode(algorithmIdentifier.getAlgorithm().getEncoded("DER")));
            Assert.assertEquals((Object)algorithmIdentifier, (Object)algorithmIdentifier);
            Assert.assertEquals((int)algorithmIdentifier.hashCode(), (int)algorithmIdentifier.hashCode());
            ++verifiedCount;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)verifiedCount).as("Algorithm identifiers verified", new Object[0])).isGreaterThanOrEqualTo(10);
    }
}

