/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.security.csr;

import com.facebook.airlift.security.csr.CertificationRequestInfo;
import com.facebook.airlift.security.csr.SignatureAlgorithmIdentifier;
import com.google.common.io.BaseEncoding;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCertificationRequestInfo {
    @Test
    public void test() throws Exception {
        String name = "C=country";
        KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
        generator.initialize(new ECGenParameterSpec("secp256r1"));
        KeyPair keyPair = generator.generateKeyPair();
        CertificationRequestInfo actualInfo = new CertificationRequestInfo(new X500Principal(name), keyPair.getPublic());
        Assert.assertEquals((Object)actualInfo.getPublicKey(), (Object)keyPair.getPublic());
        Assert.assertEquals((String)actualInfo.getSubject().getName(), (String)name);
        Assert.assertEquals((Object)actualInfo, (Object)actualInfo);
        Assert.assertEquals((int)actualInfo.hashCode(), (int)actualInfo.hashCode());
        org.bouncycastle.asn1.pkcs.CertificationRequestInfo expectedInfo = new org.bouncycastle.asn1.pkcs.CertificationRequestInfo(new X500Name(name), SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()), (ASN1Set)new DERSet());
        Assert.assertEquals((String)BaseEncoding.base16().encode(actualInfo.getEncoded()), (String)BaseEncoding.base16().encode(expectedInfo.getEncoded("DER")));
        SignatureAlgorithmIdentifier signatureAlgorithmIdentifier = SignatureAlgorithmIdentifier.findSignatureAlgorithmIdentifier((String)"SHA256withECDSA");
        byte[] actualSignature = actualInfo.sign(signatureAlgorithmIdentifier, keyPair.getPrivate());
        Signature signature = Signature.getInstance(signatureAlgorithmIdentifier.getName());
        signature.initVerify(keyPair.getPublic());
        signature.update(actualInfo.getEncoded());
        Assert.assertTrue((boolean)signature.verify(actualSignature));
    }
}

