/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.security;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.security.pem.PemReader;
import com.facebook.airlift.units.Duration;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public final class ReloadableSslContext
implements Supplier<SSLContext> {
    private static final Logger log = Logger.get(ReloadableSslContext.class);
    private final FileWatch trustCertificatesFileWatch;
    private final FileWatch clientCertificatesFileWatch;
    private final AtomicReference<SSLContext> sslContext;
    private final Duration sslContextRefreshTime;
    @GuardedBy(value="this")
    private Thread sslContextRefreshThread;
    @GuardedBy(value="this")
    private volatile boolean started;

    public ReloadableSslContext(File trustCertificatesFile, File clientCertificatesFile, Duration sslContextRefreshTime) throws IOException, GeneralSecurityException {
        this.trustCertificatesFileWatch = new FileWatch(Objects.requireNonNull(trustCertificatesFile, "trustCertificatesFile is null"));
        this.clientCertificatesFileWatch = new FileWatch(Objects.requireNonNull(clientCertificatesFile, "clientCertificatesFile is null"));
        this.sslContextRefreshTime = Objects.requireNonNull(sslContextRefreshTime, "sslContextRefreshTime is null");
        this.sslContext = new AtomicReference<SSLContext>(this.loadSslContext());
    }

    @Override
    public SSLContext get() {
        Preconditions.checkState((boolean)this.started, (Object)"ReloadableSslContext must be in the started state");
        return this.sslContext.get();
    }

    public synchronized void start() {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.refresh();
        this.sslContextRefreshThread = new Thread(this::run, "SSLContext Refresh Thread");
        this.sslContextRefreshThread.setDaemon(true);
        this.sslContextRefreshThread.start();
        this.started = true;
    }

    public synchronized void stop() {
        Preconditions.checkState((boolean)this.started, (Object)"must be started");
        this.sslContextRefreshThread.interrupt();
        this.sslContextRefreshThread = null;
        this.started = false;
    }

    private synchronized void refresh() {
        try {
            if (this.trustCertificatesFileWatch.updateState() || this.clientCertificatesFileWatch.updateState()) {
                this.sslContext.set(this.loadSslContext());
            }
        }
        catch (IOException | RuntimeException | GeneralSecurityException e) {
            log.error((Throwable)e, "Unable to reload SSL context");
        }
    }

    private void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.refresh();
                Thread.sleep(this.sslContextRefreshTime.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private SSLContext loadSslContext() throws IOException, GeneralSecurityException {
        KeyStore trustStore = PemReader.loadTrustStore(this.trustCertificatesFileWatch.getFile());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        KeyStore keyStore = PemReader.loadKeyStore(this.clientCertificatesFileWatch.getFile(), this.clientCertificatesFileWatch.getFile(), Optional.empty());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, new char[0]);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }

    private static final class FileWatch {
        private final File file;
        private long lastModified = -1L;
        private long length = -1L;
        private HashCode hashCode = Hashing.sha256().hashBytes(new byte[0]);

        public FileWatch(File file) throws IOException {
            this.file = Objects.requireNonNull(file, "file is null");
            this.updateState();
        }

        public File getFile() {
            return this.file;
        }

        public boolean updateState() throws IOException {
            long newLastModified = this.file.lastModified();
            long newLength = this.file.length();
            if (this.lastModified == newLastModified && this.length == newLength) {
                return false;
            }
            this.lastModified = newLastModified;
            this.length = newLength;
            HashCode newHashCode = Files.asByteSource((File)this.file).hash(Hashing.sha256());
            if (Objects.equals(this.hashCode, newHashCode)) {
                return false;
            }
            this.hashCode = newHashCode;
            return true;
        }
    }
}

