/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats;

import com.facebook.airlift.stats.TimeDistribution;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.airlift.testing.TestingTicker;
import com.google.common.base.Ticker;
import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTimeStat {
    private static final int VALUES = 1000;
    private TestingTicker ticker;

    @BeforeMethod
    public void setup() {
        this.ticker = new TestingTicker();
    }

    @Test
    public void testBasic() {
        TimeStat stat = new TimeStat();
        ArrayList<Long> values = new ArrayList<Long>(1000);
        for (long i = 0L; i < 1000L; ++i) {
            values.add(i);
        }
        Collections.shuffle(values);
        for (Long value : values) {
            stat.add((double)value.longValue(), TimeUnit.MILLISECONDS);
        }
        Collections.sort(values);
        TimeDistribution allTime = stat.getAllTime();
        Assert.assertEquals((Object)allTime.getCount(), (Object)values.size());
        Assert.assertTrue((boolean)DoubleMath.fuzzyEquals((double)allTime.getMax(), (double)((double)((Long)values.get(values.size() - 1)).longValue() * 0.001), (double)1.0E-10));
        Assert.assertEquals((Object)allTime.getMin(), (Object)((double)((Long)values.get(0)).longValue() * 0.001));
        Assert.assertEquals((double)allTime.getAvg(), (double)(values.stream().mapToDouble(x -> x.longValue()).average().getAsDouble() * 0.001), (double)0.001);
        Assert.assertEquals((Object)((Object)allTime.getUnit()), (Object)((Object)TimeUnit.SECONDS));
        TestTimeStat.assertPercentile("tp50", allTime.getP50(), values, 0.5);
        TestTimeStat.assertPercentile("tp75", allTime.getP75(), values, 0.75);
        TestTimeStat.assertPercentile("tp90", allTime.getP90(), values, 0.9);
        TestTimeStat.assertPercentile("tp99", allTime.getP99(), values, 0.99);
    }

    @Test
    public void testEmpty() {
        TimeStat stat = new TimeStat();
        TimeDistribution allTime = stat.getAllTime();
        Assert.assertEquals((Object)allTime.getMin(), (Object)Double.NaN);
        Assert.assertEquals((Object)allTime.getMax(), (Object)Double.NaN);
        Assert.assertEquals((Object)allTime.getP50(), (Object)Double.NaN);
        Assert.assertEquals((Object)allTime.getP75(), (Object)Double.NaN);
        Assert.assertEquals((Object)allTime.getP90(), (Object)Double.NaN);
        Assert.assertEquals((Object)allTime.getP99(), (Object)Double.NaN);
        Assert.assertEquals((Object)allTime.getAvg(), (Object)Double.NaN);
    }

    @Test
    public void time() throws Exception {
        TimeStat stat = new TimeStat((Ticker)this.ticker);
        stat.time(() -> {
            this.ticker.increment(10L, TimeUnit.MILLISECONDS);
            return null;
        });
        TimeDistribution allTime = stat.getAllTime();
        Assert.assertEquals((Object)allTime.getCount(), (Object)1.0);
        Assert.assertEquals((Object)allTime.getMin(), (Object)0.01);
        Assert.assertEquals((Object)allTime.getMax(), (Object)0.01);
    }

    @Test
    public void timeTry() throws Exception {
        TimeStat stat = new TimeStat((Ticker)this.ticker);
        try (TimeStat.BlockTimer ignored = stat.time();){
            this.ticker.increment(10L, TimeUnit.MILLISECONDS);
        }
        TimeDistribution allTime = stat.getAllTime();
        Assert.assertEquals((Object)allTime.getCount(), (Object)1.0);
        Assert.assertEquals((Object)allTime.getMin(), (Object)0.01);
        Assert.assertEquals((Object)allTime.getMax(), (Object)0.01);
    }

    @Test
    public void testUnit() {
        TimeStat stat = new TimeStat((Ticker)this.ticker, TimeUnit.MILLISECONDS);
        stat.add(1.0, TimeUnit.SECONDS);
        TimeDistribution allTime = stat.getAllTime();
        Assert.assertEquals((Object)allTime.getMin(), (Object)1000.0);
        Assert.assertEquals((Object)allTime.getMax(), (Object)1000.0);
    }

    private static void assertPercentile(String name, double value, List<Long> values, double percentile) {
        int index = (int)((double)values.size() * percentile);
        TestTimeStat.assertBounded(name, value, (double)values.get(index - 1).longValue() * 0.001, (double)values.get(Math.min(index + 1, values.size() - 1)).longValue() * 0.001);
    }

    private static void assertBounded(String name, double value, double minValue, double maxValue) {
        if (value >= minValue && value <= maxValue) {
            return;
        }
        Assert.fail((String)String.format("%s expected:<%s> to be between <%s> and <%s>", name, value, minValue, maxValue));
    }
}

