/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats;

import com.facebook.airlift.stats.TimedStat;
import com.facebook.airlift.testing.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TimedStatTest {
    private static final int VALUES = 1000;

    @Test
    public void testBasic() {
        TimedStat stat = new TimedStat();
        ArrayList<Double> values = new ArrayList<Double>(1000);
        for (int i = 0; i < 1000; ++i) {
            values.add(Double.valueOf(i));
        }
        Collections.shuffle(values);
        for (Double value : values) {
            stat.addValue(value.doubleValue(), TimeUnit.MILLISECONDS);
        }
        Collections.sort(values);
        Assert.assertEquals((long)stat.getCount(), (long)values.size());
        Assert.assertEquals((Object)stat.getMax(), values.get(values.size() - 1));
        Assert.assertEquals((Object)stat.getMin(), values.get(0));
        Assert.assertEquals((Object)stat.getMean(), (Object)(((Double)values.get(0) + (Double)values.get(values.size() - 1)) / 2.0));
        this.assertPercentile("tp50", stat.getTP50(), values, 0.5);
        this.assertPercentile("tp90", stat.getTP90(), values, 0.9);
        this.assertPercentile("tp99", stat.getTP99(), values, 0.99);
        this.assertPercentile("tp999", stat.getTP999(), values, 0.999);
        this.assertPercentile("tp80", stat.getPercentile(0.8), values, 0.8);
        this.assertPercentile("tp20", stat.getPercentile(0.2), values, 0.2);
    }

    @Test
    public void testEmpty() {
        TimedStat stat = new TimedStat();
        Assert.assertTrue((boolean)Double.isNaN(stat.getMin()));
        Assert.assertTrue((boolean)Double.isNaN(stat.getMax()));
        Assert.assertTrue((boolean)Double.isNaN(stat.getTP50()));
        Assert.assertTrue((boolean)Double.isNaN(stat.getTP90()));
        Assert.assertTrue((boolean)Double.isNaN(stat.getTP99()));
        Assert.assertTrue((boolean)Double.isNaN(stat.getTP999()));
        Assert.assertTrue((boolean)Double.isNaN(stat.getPercentile(0.8)));
        Assert.assertTrue((boolean)Double.isNaN(stat.getPercentile(0.2)));
    }

    @Test
    public void time() throws Exception {
        TimedStat stat = new TimedStat();
        stat.time(() -> {
            LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(10L));
            return null;
        });
        Assert.assertEquals((long)stat.getCount(), (long)1L);
        Assert.assertEquals((Object)stat.getMin(), (Object)stat.getMax());
        Assertions.assertGreaterThanOrEqual((Comparable)Double.valueOf(stat.getMax()), (Comparable)Double.valueOf(10.0));
    }

    @Test
    public void illegalParameters() {
        TimedStat stat = new TimedStat();
        try {
            stat.getPercentile(-1.0);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            stat.getPercentile(1.0001);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertPercentile(String name, double value, List<Double> values, double percentile) {
        int index = (int)((double)values.size() * percentile);
        this.assertBounded(name, value, values.get(index - 1), values.get(Math.min(index + 1, values.size() - 1)));
    }

    private void assertBounded(String name, double value, double minValue, double maxValue) {
        if (value >= minValue && value <= maxValue) {
            return;
        }
        Assert.fail((String)String.format("%s expected:<%s> to be between <%s> and <%s>", name, value, minValue, maxValue));
    }
}

