/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

public class Stats {
    private int count;
    private double mean;
    private double accumulator;

    public void add(double value) {
        ++this.count;
        double delta = value - this.mean;
        this.mean += delta / (double)this.count;
        this.accumulator += delta * (value - this.mean);
    }

    public int count() {
        return this.count;
    }

    public double mean() {
        return this.mean;
    }

    public double stdev() {
        return Math.sqrt(this.accumulator / (double)this.count);
    }

    public static Stats[] array(int size) {
        Stats[] result = new Stats[size];
        for (int i = 0; i < size; ++i) {
            result[i] = new Stats();
        }
        return result;
    }
}

