/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.SparseHll;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Murmur3Hash128;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.testing.SliceAssertions;
import org.testng.annotations.Test;

public class TestSparseSerialization {
    @Test
    public void testEmpty() throws Exception {
        Slice expected = new DynamicSliceOutput(1).appendByte(2).appendByte(12).appendByte(0).appendByte(0).slice();
        SparseHll hll = new SparseHll(12);
        SliceAssertions.assertSlicesEqual((Slice)hll.serialize(), (Slice)expected);
    }

    @Test
    public void testSingle() throws Exception {
        Slice expected = new DynamicSliceOutput(1).appendByte(2).appendByte(12).appendByte(1).appendByte(0).appendByte(66).appendByte(52).appendByte(32).appendByte(33).slice();
        SparseHll hll = new SparseHll(12);
        hll.insertHash(Murmur3Hash128.hash64((Slice)Slices.wrappedBuffer((byte[])new byte[]{64})));
        SliceAssertions.assertSlicesEqual((Slice)hll.serialize(), (Slice)expected);
    }

    @Test
    public void testRoundtrip() throws Exception {
        SparseHll hll = new SparseHll(4);
        for (int i = 0; i < 1000; ++i) {
            hll.insertHash(Murmur3Hash128.hash64((long)i));
            Slice serialized = hll.serialize();
            SparseHll deserialized = new SparseHll(serialized);
            Slice reserialized = deserialized.serialize();
            SliceAssertions.assertSlicesEqual((Slice)serialized, (Slice)reserialized);
        }
    }
}

