/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats;

import com.facebook.airlift.stats.QuantileDigest;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkQuantileDigest {
    private static final int NUMBER_OF_ENTRIES = 10000;

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public QuantileDigest benchmarkInserts(Data data) {
        QuantileDigest digest = new QuantileDigest(0.01);
        for (long value : data.values1) {
            digest.add(value);
        }
        return digest;
    }

    @Benchmark
    public QuantileDigest benchmarkCopy(Digest data) {
        return new QuantileDigest(data.digest1);
    }

    @Benchmark
    public QuantileDigest benchmarkMerge(Digest data) {
        QuantileDigest merged = new QuantileDigest(data.digest1);
        merged.merge(data.digest2);
        return merged;
    }

    @Benchmark
    public QuantileDigest benchmarkDeserialize(Digest data) {
        return new QuantileDigest(data.serializedDigest);
    }

    @Benchmark
    public Slice benchmarkSerialize(Digest data) {
        return data.digest1.serialize();
    }

    @Benchmark
    public List<QuantileDigest.Bucket> benchmarkHistogram(Digest data) {
        return data.digest1.getHistogram((List)ImmutableList.of((Object)0L, (Object)100000000L, (Object)200000000L, (Object)300000000L, (Object)400000000L, (Object)500000000L, (Object)600000000L, (Object)700000000L, (Object)800000000L, (Object)900000000L, (Object)1000000000L));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkQuantileDigest.class.getSimpleName() + ".*").addProfiler(GCProfiler.class).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Digest {
        private QuantileDigest digest1;
        private QuantileDigest digest2;
        private Slice serializedDigest;

        @Setup
        public void setup(Data data) {
            this.digest1 = this.makeDigest(data.values1);
            this.digest2 = this.makeDigest(data.values2);
            this.serializedDigest = this.digest1.serialize();
        }

        private QuantileDigest makeDigest(long[] values) {
            QuantileDigest result = new QuantileDigest(0.01);
            for (long value : values) {
                result.add(value);
            }
            return result;
        }
    }

    @State(value=Scope.Thread)
    public static class Data {
        private long[] values1;
        private long[] values2;

        @Setup
        public void setup() {
            this.values1 = this.makeValues(10000);
            this.values2 = this.makeValues(10000);
        }

        private long[] makeValues(int size) {
            long[] values = new long[size];
            for (int i = 0; i < size; ++i) {
                long value = Math.abs((long)(ThreadLocalRandom.current().nextGaussian() * 1.0E9));
                values[i] = value / 1000000L * 1000000L;
            }
            return values;
        }
    }
}

