/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats;

import com.facebook.airlift.stats.DecayCounter;
import com.facebook.airlift.stats.ExponentialDecay;
import com.facebook.airlift.testing.TestingTicker;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDecayCounter {
    @Test
    public void testCountDecays() {
        TestingTicker ticker = new TestingTicker();
        DecayCounter counter = new DecayCounter(ExponentialDecay.oneMinute(), (Ticker)ticker);
        counter.add(1L);
        ticker.increment(1L, TimeUnit.MINUTES);
        Assert.assertTrue((Math.abs(counter.getCount() - 0.36787944117144233) < 1.0E-9 ? 1 : 0) != 0);
    }

    @Test
    public void testAddAfterRescale() {
        TestingTicker ticker = new TestingTicker();
        DecayCounter counter = new DecayCounter(ExponentialDecay.oneMinute(), (Ticker)ticker);
        counter.add(1L);
        ticker.increment(1L, TimeUnit.MINUTES);
        counter.add(2L);
        double expected = 2.3678794411714423;
        Assert.assertTrue((Math.abs(counter.getCount() - expected) < 1.0E-9 ? 1 : 0) != 0);
    }
}

