/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats;

import com.facebook.airlift.stats.ExponentialDecay;
import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.airlift.testing.TestingTicker;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQuantileDigest {
    @Test
    public void testSingleAdd() {
        QuantileDigest digest = new QuantileDigest(1.0);
        digest.add(0L);
        digest.validate();
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        Assert.assertEquals((Object)digest.getCount(), (Object)1.0);
        Assert.assertEquals((int)digest.getNodeCount(), (int)1);
    }

    @Test
    public void testNegativeValues() {
        QuantileDigest digest = new QuantileDigest(1.0);
        this.addAll(digest, Arrays.asList(-1, -2, -3, -4, -5, 0, 1, 2, 3, 4, 5));
        Assert.assertEquals((Object)digest.getCount(), (Object)11.0);
    }

    @Test
    public void testRepeatedValue() {
        QuantileDigest digest = new QuantileDigest(1.0);
        digest.add(0L);
        digest.add(0L);
        digest.validate();
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        Assert.assertEquals((Object)digest.getCount(), (Object)2.0);
        Assert.assertEquals((int)digest.getNodeCount(), (int)1);
    }

    @Test
    public void testTwoDistinctValues() {
        QuantileDigest digest = new QuantileDigest(1.0);
        digest.add(0L);
        digest.add(Long.MAX_VALUE);
        digest.validate();
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        Assert.assertEquals((Object)digest.getCount(), (Object)2.0);
        Assert.assertEquals((int)digest.getNodeCount(), (int)3);
    }

    @Test
    public void testTreeBuilding() {
        QuantileDigest digest = new QuantileDigest(1.0);
        List<Integer> values = Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7);
        this.addAll(digest, values);
        Assert.assertEquals((Object)digest.getCount(), (Object)values.size());
    }

    @Test
    public void testTreeBuildingReverse() {
        QuantileDigest digest = new QuantileDigest(1.0);
        List<Integer> values = Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7);
        this.addAll(digest, Lists.reverse(values));
        Assert.assertEquals((Object)digest.getCount(), (Object)values.size());
    }

    @Test
    public void testBasicCompression() {
        QuantileDigest digest = new QuantileDigest(0.8, 0.0, (Ticker)new TestingTicker());
        List<Integer> values = Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7);
        this.addAll(digest, values);
        digest.compress();
        digest.validate();
        Assert.assertEquals((Object)digest.getCount(), (Object)values.size());
        Assert.assertEquals((int)digest.getNodeCount(), (int)7);
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.2);
    }

    @Test
    public void testCompression() throws Exception {
        QuantileDigest digest = new QuantileDigest(1.0, 0.0, (Ticker)new TestingTicker());
        for (int loop = 0; loop < 2; ++loop) {
            this.addRange(digest, 0, 15);
            digest.compress();
            digest.validate();
        }
    }

    @Test
    public void testQuantile() {
        QuantileDigest digest = new QuantileDigest(1.0);
        this.addAll(digest, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        Assert.assertEquals((long)digest.getQuantile(0.0), (long)0L);
        Assert.assertEquals((long)digest.getQuantile(0.1), (long)1L);
        Assert.assertEquals((long)digest.getQuantile(0.2), (long)2L);
        Assert.assertEquals((long)digest.getQuantile(0.3), (long)3L);
        Assert.assertEquals((long)digest.getQuantile(0.4), (long)4L);
        Assert.assertEquals((long)digest.getQuantile(0.5), (long)5L);
        Assert.assertEquals((long)digest.getQuantile(0.6), (long)6L);
        Assert.assertEquals((long)digest.getQuantile(0.7), (long)7L);
        Assert.assertEquals((long)digest.getQuantile(0.8), (long)8L);
        Assert.assertEquals((long)digest.getQuantile(0.9), (long)9L);
        Assert.assertEquals((long)digest.getQuantile(1.0), (long)9L);
    }

    @Test
    public void testQuantileLowerBound() {
        QuantileDigest digest = new QuantileDigest(0.5);
        this.addRange(digest, 1, 100);
        Assert.assertEquals((long)digest.getQuantileLowerBound(0.0), (long)1L);
        for (int i = 1; i <= 10; ++i) {
            Assert.assertTrue((digest.getQuantileLowerBound((double)i / 10.0) <= (long)(i * 10) ? 1 : 0) != 0);
            if (i <= 5) continue;
            Assert.assertTrue((digest.getQuantileLowerBound((double)i / 10.0) >= (long)((i - 5) * 10) ? 1 : 0) != 0);
        }
        Assert.assertEquals((Collection)digest.getQuantilesLowerBound((List)ImmutableList.of((Object)0.0, (Object)0.1, (Object)0.2)), (Collection)ImmutableList.of((Object)digest.getQuantileLowerBound(0.0), (Object)digest.getQuantileLowerBound(0.1), (Object)digest.getQuantileLowerBound(0.2)));
    }

    @Test
    public void testQuantileUpperBound() {
        QuantileDigest digest = new QuantileDigest(0.5);
        this.addRange(digest, 1, 100);
        Assert.assertEquals((long)digest.getQuantileUpperBound(1.0), (long)99L);
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((digest.getQuantileUpperBound((double)i / 10.0) >= (long)(i * 10) ? 1 : 0) != 0);
            if (i >= 5) continue;
            Assert.assertTrue((digest.getQuantileUpperBound((double)i / 10.0) <= (long)((i + 5) * 10) ? 1 : 0) != 0);
        }
        Assert.assertEquals((Collection)digest.getQuantilesUpperBound((List)ImmutableList.of((Object)0.8, (Object)0.9, (Object)1.0)), (Collection)ImmutableList.of((Object)digest.getQuantileUpperBound(0.8), (Object)digest.getQuantileUpperBound(0.9), (Object)digest.getQuantileUpperBound(1.0)));
    }

    @Test
    public void testWeightedValues() {
        QuantileDigest digest = new QuantileDigest(1.0);
        digest.add(0L, 3L);
        digest.add(2L, 1L);
        digest.add(4L, 5L);
        digest.add(5L, 1L);
        digest.validate();
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        Assert.assertEquals((long)digest.getQuantile(0.0), (long)0L);
        Assert.assertEquals((long)digest.getQuantile(0.1), (long)0L);
        Assert.assertEquals((long)digest.getQuantile(0.2), (long)0L);
        Assert.assertEquals((long)digest.getQuantile(0.3), (long)2L);
        Assert.assertEquals((long)digest.getQuantile(0.4), (long)4L);
        Assert.assertEquals((long)digest.getQuantile(0.5), (long)4L);
        Assert.assertEquals((long)digest.getQuantile(0.6), (long)4L);
        Assert.assertEquals((long)digest.getQuantile(0.7), (long)4L);
        Assert.assertEquals((long)digest.getQuantile(0.8), (long)4L);
        Assert.assertEquals((long)digest.getQuantile(0.9), (long)5L);
        Assert.assertEquals((long)digest.getQuantile(1.0), (long)5L);
    }

    @Test
    public void testBatchQuantileQuery() throws Exception {
        QuantileDigest digest = new QuantileDigest(1.0);
        this.addAll(digest, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        Assert.assertEquals((Collection)digest.getQuantiles(Arrays.asList(0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0)), Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 9L));
    }

    @Test
    public void testHistogramQuery() throws Exception {
        QuantileDigest digest = new QuantileDigest(1.0);
        this.addAll(digest, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(1.0, 0.0), new QuantileDigest.Bucket(1.0, 1.0), new QuantileDigest.Bucket(1.0, 2.0), new QuantileDigest.Bucket(1.0, 3.0), new QuantileDigest.Bucket(1.0, 4.0), new QuantileDigest.Bucket(1.0, 5.0), new QuantileDigest.Bucket(1.0, 6.0), new QuantileDigest.Bucket(1.0, 7.0), new QuantileDigest.Bucket(1.0, 8.0), new QuantileDigest.Bucket(1.0, 9.0)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(7L, 10L)), Arrays.asList(new QuantileDigest.Bucket(7.0, 3.0), new QuantileDigest.Bucket(3.0, 8.0)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(0L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(9L)), Arrays.asList(new QuantileDigest.Bucket(9.0, 4.0)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(10L)), Arrays.asList(new QuantileDigest.Bucket(10.0, 4.5)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(Long.MAX_VALUE)), Arrays.asList(new QuantileDigest.Bucket(10.0, 4.5)));
    }

    @Test
    public void testHistogramOfDoublesQuery() {
        QuantileDigest digest = new QuantileDigest(1.0);
        LongStream.range(-10L, 10L).map(TestQuantileDigest::doubleToSortableLong).boxed().forEach(arg_0 -> ((QuantileDigest)digest).add(arg_0));
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        List bucketUpperBounds = (List)LongStream.range(-10L, 10L).map(TestQuantileDigest::doubleToSortableLong).boxed().collect(ImmutableList.toImmutableList());
        QuantileDigest.MiddleFunction middleFunction = (lowerBound, upperBound) -> {
            double left = lowerBound > Long.MIN_VALUE ? TestQuantileDigest.sortableLongToDouble(lowerBound) : -1.7976931348623157E308;
            double right = upperBound < Long.MAX_VALUE ? TestQuantileDigest.sortableLongToDouble(upperBound) : Double.MAX_VALUE;
            return left + (right - left) / 2.0;
        };
        List expected = LongStream.range(-9L, 10L).boxed().map(i -> new QuantileDigest.Bucket(1.0, (double)(i - 1L))).collect(Collectors.toList());
        expected.add(0, new QuantileDigest.Bucket(0.0, Double.NaN));
        Assert.assertEquals((Collection)digest.getHistogram(bucketUpperBounds, middleFunction), expected);
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(TestQuantileDigest.doubleToSortableLong(7.0), TestQuantileDigest.doubleToSortableLong(10.0)), middleFunction), Arrays.asList(new QuantileDigest.Bucket(17.0, -2.0), new QuantileDigest.Bucket(3.0, 8.0)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(TestQuantileDigest.doubleToSortableLong(-1.7976931348623157E308)), middleFunction), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(TestQuantileDigest.doubleToSortableLong(-1.7976931348623157E308), TestQuantileDigest.doubleToSortableLong(-1.7976931348623157E308)), middleFunction), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(0.0, Double.NaN)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(TestQuantileDigest.doubleToSortableLong(0.0)), middleFunction), Arrays.asList(new QuantileDigest.Bucket(10.0, -5.5)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(TestQuantileDigest.doubleToSortableLong(9.0)), middleFunction), Arrays.asList(new QuantileDigest.Bucket(19.0, -1.0)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(TestQuantileDigest.doubleToSortableLong(10.0)), middleFunction), Arrays.asList(new QuantileDigest.Bucket(20.0, -0.5)));
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(TestQuantileDigest.doubleToSortableLong(Double.MAX_VALUE)), middleFunction), Arrays.asList(new QuantileDigest.Bucket(20.0, -0.5)));
    }

    @Test
    public void testHistogramQueryAfterCompression() throws Exception {
        QuantileDigest digest = new QuantileDigest(0.1);
        int total = 10000;
        this.addRange(digest, 0, total);
        Assert.assertTrue((digest.getConfidenceFactor() > 0.0 ? 1 : 0) != 0);
        double actualMaxError = digest.getConfidenceFactor();
        for (long value = 0L; value < (long)total; ++value) {
            QuantileDigest.Bucket bucket = (QuantileDigest.Bucket)digest.getHistogram(Arrays.asList(value)).get(0);
            Assert.assertTrue((Math.abs(bucket.getCount() - (double)value) < 2.0 * actualMaxError * (double)total ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQuantileQueryError() {
        double maxError = 0.1;
        QuantileDigest digest = new QuantileDigest(maxError);
        int count = 10000;
        this.addRange(digest, 0, count);
        Assert.assertTrue((digest.getConfidenceFactor() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((digest.getConfidenceFactor() < maxError ? 1 : 0) != 0);
        for (int value = 0; value < count; ++value) {
            double quantile = (double)value * 1.0 / (double)count;
            long estimatedValue = digest.getQuantile(quantile);
            double error = Math.abs((double)estimatedValue - quantile * (double)count) * 1.0 / (double)count;
            Assert.assertTrue((error < maxError ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDecayedQuantiles() throws Exception {
        TestingTicker ticker = new TestingTicker();
        QuantileDigest digest = new QuantileDigest(1.0, ExponentialDecay.computeAlpha((double)0.5, (long)60L), (Ticker)ticker);
        this.addAll(digest, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        ticker.increment(60L, TimeUnit.SECONDS);
        this.addAll(digest, Arrays.asList(10, 11, 12, 13, 14, 15, 16, 17, 18, 19));
        Assert.assertEquals((long)digest.getQuantile(0.5), (long)12L);
    }

    @Test
    public void testDecayedCounts() throws Exception {
        TestingTicker ticker = new TestingTicker();
        QuantileDigest digest = new QuantileDigest(1.0, ExponentialDecay.computeAlpha((double)0.5, (long)60L), (Ticker)ticker);
        this.addAll(digest, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        ticker.increment(60L, TimeUnit.SECONDS);
        this.addAll(digest, Arrays.asList(10, 11, 12, 13, 14, 15, 16, 17, 18, 19));
        Assert.assertEquals((Object)digest.getCount(), (Object)15.0);
    }

    @Test
    public void testDecayedCountsWithClockIncrementSmallerThanRescaleThreshold() throws Exception {
        int targetAgeInSeconds = 49;
        TestingTicker ticker = new TestingTicker();
        QuantileDigest digest = new QuantileDigest(1.0, ExponentialDecay.computeAlpha((double)0.5, (long)targetAgeInSeconds), (Ticker)ticker);
        this.addAll(digest, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        ticker.increment((long)targetAgeInSeconds, TimeUnit.SECONDS);
        this.addAll(digest, Arrays.asList(10, 11, 12, 13, 14, 15, 16, 17, 18, 19));
        Assert.assertEquals((Object)digest.getCount(), (Object)15.0);
    }

    @Test
    public void testMinMax() throws Exception {
        QuantileDigest digest = new QuantileDigest(0.01, 0.0, (Ticker)new TestingTicker());
        int from = 500;
        int to = 700;
        this.addRange(digest, from, to + 1);
        Assert.assertEquals((long)digest.getMin(), (long)from);
        Assert.assertEquals((long)digest.getMax(), (long)to);
    }

    @Test
    public void testMinMaxWithDecay() throws Exception {
        TestingTicker ticker = new TestingTicker();
        QuantileDigest digest = new QuantileDigest(0.01, ExponentialDecay.computeAlpha((double)1.0E-5, (long)60L), (Ticker)ticker);
        this.addRange(digest, 1, 10);
        ticker.increment(1000L, TimeUnit.SECONDS);
        int from = 4;
        int to = 7;
        this.addRange(digest, from, to + 1);
        digest.validate();
        Assert.assertEquals((long)digest.getMin(), (long)from);
        Assert.assertEquals((long)digest.getMax(), (long)to);
    }

    @Test
    public void testRescaleWithDecayKeepsCompactTree() throws Exception {
        TestingTicker ticker = new TestingTicker();
        int targetAgeInSeconds = 50;
        QuantileDigest digest = new QuantileDigest(0.01, ExponentialDecay.computeAlpha((double)5.0E-6, (long)targetAgeInSeconds), (Ticker)ticker);
        for (int i = 0; i < 10; ++i) {
            digest.add((long)i);
            digest.validate();
            ticker.increment((long)targetAgeInSeconds, TimeUnit.SECONDS);
        }
        Assert.assertEquals((int)digest.getNodeCount(), (int)1);
    }

    @Test
    public void testEquivalenceEmpty() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        Assert.assertTrue((boolean)a.equivalent(b));
    }

    @Test
    public void testEquivalenceSingle() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        a.add(1L);
        b.add(1L);
        Assert.assertTrue((boolean)a.equivalent(b));
    }

    @Test
    public void testEquivalenceSingleDifferent() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        a.add(1L);
        b.add(2L);
        Assert.assertFalse((boolean)a.equivalent(b));
    }

    @Test
    public void testEquivalenceComplex() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        this.addAll(a, Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7));
        this.addAll(b, Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7));
        Assert.assertTrue((boolean)a.equivalent(b));
    }

    @Test
    public void testEquivalenceComplexDifferent() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        this.addAll(a, Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7));
        this.addAll(b, Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7, 8));
        Assert.assertFalse((boolean)a.equivalent(b));
    }

    @Test
    public void testMergeEmpty() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        QuantileDigest pristineB = new QuantileDigest(0.01);
        a.merge(b);
        a.validate();
        b.validate();
        Assert.assertTrue((boolean)b.equivalent(pristineB));
        Assert.assertEquals((Object)a.getCount(), (Object)0.0);
        Assert.assertEquals((int)a.getNodeCount(), (int)0);
        Assert.assertEquals((Object)b.getCount(), (Object)0.0);
        Assert.assertEquals((int)b.getNodeCount(), (int)0);
    }

    @Test
    public void testMergeIntoEmpty() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        QuantileDigest pristineB = new QuantileDigest(0.01);
        b.add(1L);
        pristineB.add(1L);
        a.merge(b);
        a.validate();
        b.validate();
        Assert.assertTrue((boolean)b.equivalent(pristineB));
        Assert.assertEquals((Object)a.getCount(), (Object)1.0);
        Assert.assertEquals((int)a.getNodeCount(), (int)1);
        Assert.assertEquals((Object)b.getCount(), (Object)1.0);
        Assert.assertEquals((int)b.getNodeCount(), (int)1);
    }

    @Test
    public void testMergeWithEmpty() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        QuantileDigest pristineB = new QuantileDigest(0.01);
        a.add(1L);
        a.merge(b);
        a.validate();
        b.validate();
        Assert.assertTrue((boolean)b.equivalent(pristineB));
        Assert.assertEquals((Object)a.getCount(), (Object)1.0);
        Assert.assertEquals((int)a.getNodeCount(), (int)1);
        Assert.assertEquals((Object)b.getCount(), (Object)0.0);
        Assert.assertEquals((int)b.getNodeCount(), (int)0);
    }

    @Test
    public void testMergeSample() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        a.add(1L);
        this.addAll(b, Arrays.asList(2, 3));
        a.merge(b);
        a.validate();
        Assert.assertEquals((Object)a.getCount(), (Object)3.0);
        Assert.assertEquals((int)a.getNodeCount(), (int)5);
    }

    @Test
    public void testMergeSeparateBranches() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        QuantileDigest pristineB = new QuantileDigest(0.01);
        a.add(1L);
        b.add(2L);
        pristineB.add(2L);
        a.merge(b);
        Assert.assertTrue((boolean)b.equivalent(pristineB));
        Assert.assertEquals((Object)a.getCount(), (Object)2.0);
        Assert.assertEquals((int)a.getNodeCount(), (int)3);
        Assert.assertEquals((Object)b.getCount(), (Object)1.0);
        Assert.assertEquals((int)b.getNodeCount(), (int)1);
    }

    @Test
    public void testMergeWithLowerLevel() throws Exception {
        QuantileDigest a = new QuantileDigest(1.0, 0.0, Ticker.systemTicker());
        QuantileDigest b = new QuantileDigest(1.0, 0.0, Ticker.systemTicker());
        QuantileDigest pristineB = new QuantileDigest(1.0, 0.0, Ticker.systemTicker());
        a.add(6L);
        a.compress();
        List<Integer> values = Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5);
        this.addAll(b, values);
        b.compress();
        this.addAll(pristineB, values);
        pristineB.compress();
        a.merge(b);
        Assert.assertTrue((boolean)b.equivalent(pristineB));
        Assert.assertEquals((Object)a.getCount(), (Object)14.0);
        Assert.assertEquals((Object)b.getCount(), (Object)13.0);
    }

    @Test
    public void testMergeWithHigherLevel() throws Exception {
        QuantileDigest a = new QuantileDigest(1.0, 0.0, Ticker.systemTicker());
        QuantileDigest b = new QuantileDigest(1.0, 0.0, Ticker.systemTicker());
        QuantileDigest pristineB = new QuantileDigest(1.0, 0.0, Ticker.systemTicker());
        this.addAll(a, Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5));
        a.compress();
        this.addAll(b, Arrays.asList(6, 7));
        this.addAll(pristineB, Arrays.asList(6, 7));
        a.merge(b);
        Assert.assertTrue((boolean)b.equivalent(pristineB));
        Assert.assertEquals((Object)a.getCount(), (Object)15.0);
        Assert.assertEquals((int)a.getNodeCount(), (int)7);
        Assert.assertEquals((Object)b.getCount(), (Object)2.0);
        Assert.assertEquals((int)b.getNodeCount(), (int)3);
    }

    @Test
    public void testMergeMaxLevel() throws Exception {
        QuantileDigest a = new QuantileDigest(0.01);
        QuantileDigest b = new QuantileDigest(0.01);
        QuantileDigest pristineB = new QuantileDigest(0.01);
        this.addAll(a, Arrays.asList(-1, 1));
        this.addAll(b, Arrays.asList(-2, 2));
        this.addAll(pristineB, Arrays.asList(-2, 2));
        a.merge(b);
        a.validate();
        b.validate();
        Assert.assertTrue((boolean)b.equivalent(pristineB));
        Assert.assertEquals((Object)a.getCount(), (Object)4.0);
        Assert.assertEquals((int)a.getNodeCount(), (int)7);
    }

    @Test
    public void testMergeSameLevel() throws Exception {
        QuantileDigest a = new QuantileDigest(1.0, 0.0, Ticker.systemTicker());
        QuantileDigest b = new QuantileDigest(1.0, 0.0, Ticker.systemTicker());
        QuantileDigest pristineB = new QuantileDigest(1.0, 0.0, Ticker.systemTicker());
        a.add(0L);
        b.add(0L);
        pristineB.add(0L);
        a.merge(b);
        Assert.assertTrue((boolean)b.equivalent(pristineB));
        Assert.assertEquals((Object)a.getCount(), (Object)2.0);
        Assert.assertEquals((int)a.getNodeCount(), (int)1);
        Assert.assertEquals((Object)b.getCount(), (Object)1.0);
        Assert.assertEquals((int)b.getNodeCount(), (int)1);
    }

    @Test
    public void testScale() throws Exception {
        QuantileDigest digest = new QuantileDigest(1.0);
        this.addAll(digest, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(1.0, 0.0), new QuantileDigest.Bucket(1.0, 1.0), new QuantileDigest.Bucket(1.0, 2.0), new QuantileDigest.Bucket(1.0, 3.0), new QuantileDigest.Bucket(1.0, 4.0), new QuantileDigest.Bucket(1.0, 5.0), new QuantileDigest.Bucket(1.0, 6.0), new QuantileDigest.Bucket(1.0, 7.0), new QuantileDigest.Bucket(1.0, 8.0), new QuantileDigest.Bucket(1.0, 9.0)));
        digest.scale(4.0);
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(4.0, 0.0), new QuantileDigest.Bucket(4.0, 1.0), new QuantileDigest.Bucket(4.0, 2.0), new QuantileDigest.Bucket(4.0, 3.0), new QuantileDigest.Bucket(4.0, 4.0), new QuantileDigest.Bucket(4.0, 5.0), new QuantileDigest.Bucket(4.0, 6.0), new QuantileDigest.Bucket(4.0, 7.0), new QuantileDigest.Bucket(4.0, 8.0), new QuantileDigest.Bucket(4.0, 9.0)));
        digest.scale(0.5);
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(2.0, 0.0), new QuantileDigest.Bucket(2.0, 1.0), new QuantileDigest.Bucket(2.0, 2.0), new QuantileDigest.Bucket(2.0, 3.0), new QuantileDigest.Bucket(2.0, 4.0), new QuantileDigest.Bucket(2.0, 5.0), new QuantileDigest.Bucket(2.0, 6.0), new QuantileDigest.Bucket(2.0, 7.0), new QuantileDigest.Bucket(2.0, 8.0), new QuantileDigest.Bucket(2.0, 9.0)));
    }

    @Test
    public void testScaleRemoveSmallCount() throws Exception {
        QuantileDigest digest = new QuantileDigest(1.0);
        digest.add(0L);
        digest.add(1L, 1000000.0);
        Assert.assertEquals((Object)digest.getConfidenceFactor(), (Object)0.0);
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(0L, 1L, 2L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(1.0, 0.0), new QuantileDigest.Bucket(1000000.0, 1.0)));
        digest.scale(1.0E-6);
        Assert.assertEquals((Collection)digest.getHistogram(Arrays.asList(0L, 1L, 2L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(1.0, 1.0)));
    }

    @Test
    public void testSerializationEmpty() throws Exception {
        QuantileDigest digest = new QuantileDigest(0.01);
        QuantileDigest deserialized = this.deserialize(digest.serialize());
        Assert.assertTrue((boolean)digest.equivalent(deserialized));
    }

    @Test
    public void testSerializationSingle() throws Exception {
        QuantileDigest digest = new QuantileDigest(0.01);
        digest.add(1L);
        Assert.assertTrue((boolean)digest.equivalent(this.deserialize(digest.serialize())));
    }

    @Test
    public void testSerializationComplex() throws Exception {
        QuantileDigest digest = new QuantileDigest(1.0);
        this.addAll(digest, Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7));
        Assert.assertTrue((boolean)digest.equivalent(this.deserialize(digest.serialize())));
        digest.compress();
        Assert.assertTrue((boolean)digest.equivalent(this.deserialize(digest.serialize())));
    }

    @Test
    public void testSerializationWithExtremeEndsOfLong() throws Exception {
        QuantileDigest digest = new QuantileDigest(1.0);
        digest.add(Long.MIN_VALUE);
        digest.add(Long.MAX_VALUE);
        Assert.assertTrue((boolean)digest.equivalent(this.deserialize(digest.serialize())));
        digest.compress();
        Assert.assertTrue((boolean)digest.equivalent(this.deserialize(digest.serialize())));
    }

    @Test(invocationCount=1000)
    public void testSerializationRandomPositiveIntegers() throws Exception {
        QuantileDigest digest = new QuantileDigest(1.0);
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            values.add(ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE));
        }
        this.addAll(digest, values);
        Assert.assertTrue((boolean)digest.equivalent(this.deserialize(digest.serialize())), (String)String.format("Serialization roundtrip failed for input: %s", values));
    }

    @Test(invocationCount=1000)
    public void testSerializationRandom() throws Exception {
        QuantileDigest digest = new QuantileDigest(1.0);
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            values.add(ThreadLocalRandom.current().nextInt());
        }
        this.addAll(digest, values);
        Assert.assertTrue((boolean)digest.equivalent(this.deserialize(digest.serialize())), (String)String.format("Serialization roundtrip failed for input: %s", values));
    }

    @Test
    public void testIterator() {
        QuantileDigest digest = new QuantileDigest(0.001);
        this.addAll(digest, Arrays.asList(0, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7));
        QuantileDigest.QuantileDigestIterator iterator = digest.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.066666667, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)0L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)0L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.066666667, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.333333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)4.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)5.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)2L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)2L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.333333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.733333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)6.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)11.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)3L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)3L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.733333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.8, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)12.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)4L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)4L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.8, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.866666667, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)13.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)5L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)5L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.866666667, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.933333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)14.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)6L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)6L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.933333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)15.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)7L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)7L);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = digest.reverseIterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.933333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)7L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)7L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.866666667, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.933333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)2.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)6L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)6L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.8, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.866666667, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)3.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)5L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)5L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.733333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.8, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)4.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)4L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)4L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.333333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.733333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)6.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)10.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)3L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)3L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.066666667, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.333333333, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)4.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)14.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)2L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)2L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((double)iterator.lowerBoundQuantile(), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.upperBoundQuantile(), (double)0.066666667, (double)1.0E-4);
        Assert.assertEquals((double)iterator.count(), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)iterator.cumulativeCount(), (double)15.0, (double)1.0E-4);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)0L);
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)0L);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorSingleElement() {
        QuantileDigest digest = new QuantileDigest(0.1);
        this.addAll(digest, Arrays.asList(10));
        QuantileDigest.QuantileDigestIterator iterator = digest.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertEquals((long)iterator.upperBoundValue(), (long)10L);
        Assert.assertEquals((long)iterator.lowerBoundValue(), (long)10L);
        Assert.assertEquals((Object)iterator.count(), (Object)1.0);
        Assert.assertEquals((Object)iterator.cumulativeCount(), (Object)1.0);
        Assert.assertEquals((Object)iterator.lowerBoundQuantile(), (Object)0.0);
        Assert.assertEquals((Object)iterator.upperBoundQuantile(), (Object)1.0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNoElement() {
        QuantileDigest digest = new QuantileDigest(0.1);
        QuantileDigest.QuantileDigestIterator iterator = digest.iterator();
        Assert.assertFalse((boolean)iterator.hasNext(), (String)"Expected no calls to next() to return true");
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testErrorIteratorConsumed() {
        QuantileDigest digest = new QuantileDigest(0.01);
        digest.add(1L);
        digest.add(2L);
        QuantileDigest.QuantileDigestIterator iterator = digest.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.advance();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.upperBoundQuantile();
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testErrorIteratorNextNotCalled() {
        QuantileDigest digest = new QuantileDigest(0.01);
        digest.add(1L);
        digest.add(2L);
        QuantileDigest.QuantileDigestIterator iterator = digest.iterator();
        iterator.upperBoundQuantile();
    }

    private QuantileDigest deserialize(Slice serialized) throws IOException {
        QuantileDigest result = new QuantileDigest(serialized);
        result.validate();
        return result;
    }

    private void addAll(QuantileDigest digest, List<Integer> values) {
        for (int value : values) {
            digest.add((long)value);
        }
        digest.validate();
    }

    private void addRange(QuantileDigest digest, int from, int to) {
        for (int i = from; i < to; ++i) {
            digest.add((long)i);
        }
        digest.validate();
    }

    private static long doubleToSortableLong(double value) {
        long bits = Double.doubleToLongBits(value);
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    private static double sortableLongToDouble(long value) {
        value ^= value >> 63 & Long.MAX_VALUE;
        return Double.longBitsToDouble(value);
    }
}

