/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.DenseHll;
import com.facebook.airlift.stats.cardinality.SparseHll;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=5)
@Warmup(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkDenseHll {
    private static final int LARGE_CARDINALITY = 1000000;
    private static final int SMALL_CARDINALITY = 100;

    @Benchmark
    public DenseHll benchmarkInsert(InsertData data) {
        for (long hash : data.hashes) {
            data.instance.insertHash(hash);
        }
        return data.instance;
    }

    @Benchmark
    public DenseHll benchmarkMergeWithDense(MergeWithDenseData data) {
        return data.base.mergeWith(data.toMerge);
    }

    @Benchmark
    public DenseHll benchmarkMergeWithSparse(MergeWithSparseData data) {
        return data.base.mergeWith(data.toMerge);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkDenseHll.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class MergeWithSparseData {
        public DenseHll base;
        public SparseHll toMerge;

        @Setup(value=Level.Iteration)
        public void initialize() {
            int i;
            this.base = new DenseHll(12);
            for (i = 0; i < 1000000; ++i) {
                this.base.insertHash(ThreadLocalRandom.current().nextLong());
            }
            this.toMerge = new SparseHll(12);
            for (i = 0; i < 100; ++i) {
                this.toMerge.insertHash(ThreadLocalRandom.current().nextLong());
            }
        }
    }

    @State(value=Scope.Thread)
    public static class MergeWithDenseData {
        public DenseHll base;
        public DenseHll toMerge;

        @Setup(value=Level.Iteration)
        public void initialize() {
            int i;
            this.base = new DenseHll(12);
            for (i = 0; i < 1000000; ++i) {
                this.base.insertHash(ThreadLocalRandom.current().nextLong());
            }
            this.toMerge = new DenseHll(12);
            for (i = 0; i < 100; ++i) {
                this.toMerge.insertHash(ThreadLocalRandom.current().nextLong());
            }
        }
    }

    @State(value=Scope.Thread)
    public static class InsertData {
        public final DenseHll instance = new DenseHll(12);
        public final long[] hashes = new long[500];

        @Setup(value=Level.Iteration)
        public void initialize() {
            for (int i = 0; i < this.hashes.length; ++i) {
                this.hashes[i] = ThreadLocalRandom.current().nextLong();
            }
        }
    }
}

