/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.DenseHll;
import com.facebook.airlift.stats.cardinality.TestUtils;
import com.facebook.airlift.stats.cardinality.TestingHll;
import com.facebook.airlift.stats.cardinality.Utils;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;
import io.airlift.slice.testing.SliceAssertions;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDenseHll {
    @Test(dataProvider="bits")
    public void testCorrectNumberOfZeros(int indexBitLength) {
        DenseHll denseHll = new DenseHll(indexBitLength);
        int limit = Math.min(64 - indexBitLength, Utils.numberOfBuckets((int)indexBitLength));
        for (int i2 = 0; i2 < limit; ++i2) {
            denseHll.insertHash(TestUtils.createHashForBucket(indexBitLength, i2, i2));
        }
        denseHll.eachBucket((i, value) -> {
            if (i < limit) {
                Assert.assertEquals((int)value, (int)(i + 1));
            } else {
                Assert.assertEquals((int)value, (int)0);
            }
        });
    }

    @Test(dataProvider="bits")
    public void testMultipleMerges(int prefixBitLength) throws Exception {
        int i;
        DenseHll single = new DenseHll(prefixBitLength);
        DenseHll merged = new DenseHll(prefixBitLength);
        DenseHll current = new DenseHll(prefixBitLength);
        for (i = 0; i < 10000000; ++i) {
            if (i % 10000 == 0) {
                merged.mergeWith(current);
                current = new DenseHll(prefixBitLength);
            }
            long hash = XxHash64.hash((long)i);
            current.insertHash(hash);
            single.insertHash(hash);
        }
        merged.mergeWith(current);
        for (i = 0; i < Utils.numberOfBuckets((int)prefixBitLength); ++i) {
            Assert.assertEquals((int)single.getValue(i), (int)merged.getValue(i));
        }
        Assert.assertEquals((long)single.cardinality(), (long)merged.cardinality());
    }

    @Test(dataProvider="bits")
    public void testHighCardinality(int prefixBitLength) throws Exception {
        TestingHll testingHll = new TestingHll(prefixBitLength);
        DenseHll hll = new DenseHll(prefixBitLength);
        for (int i = 0; i < 10000000; ++i) {
            long hash = XxHash64.hash((long)i);
            testingHll.insertHash(hash);
            hll.insertHash(hash);
        }
        TestDenseHll.assertSameBuckets(testingHll, hll);
    }

    @Test(dataProvider="bits")
    public void testInsert(int prefixBitLength) throws Exception {
        TestingHll testingHll = new TestingHll(prefixBitLength);
        DenseHll hll = new DenseHll(prefixBitLength);
        for (int i = 0; i < 20000; ++i) {
            long hash = XxHash64.hash((long)i);
            testingHll.insertHash(hash);
            hll.insertHash(hash);
            hll.verify();
        }
        TestDenseHll.assertSameBuckets(testingHll, hll);
    }

    @Test
    public void testMergeWithOverflows() throws Exception {
        TestingHll testingHll = new TestingHll(12);
        DenseHll hll1 = new DenseHll(12);
        DenseHll hll2 = new DenseHll(12);
        long hash1 = XxHash64.hash((long)25130L);
        long hash2 = XxHash64.hash((long)227291L);
        hll1.insertHash(hash1);
        testingHll.insertHash(hash1);
        hll2.insertHash(hash2);
        testingHll.insertHash(hash2);
        hll1.mergeWith(hll2);
        hll1.verify();
        TestDenseHll.assertSameBuckets(testingHll, hll1);
    }

    @Test(dataProvider="bits")
    public void testMerge(int prefixBitLength) throws Exception {
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(0, 100), TestUtils.sequence(100, 200));
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(100, 200), TestUtils.sequence(0, 100));
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(0, 100), TestUtils.sequence(50, 150));
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(50, 150), TestUtils.sequence(0, 100));
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(0, 100), TestUtils.sequence(0, 100));
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(0, 20000), TestUtils.sequence(20000, 40000));
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(20000, 40000), TestUtils.sequence(0, 20000));
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(0, 2000000), TestUtils.sequence(1000000, 3000000));
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(1000000, 3000000), TestUtils.sequence(0, 2000000));
        TestDenseHll.verifyMerge(prefixBitLength, TestUtils.sequence(0, 2000000), TestUtils.sequence(0, 2000000));
    }

    private static void verifyMerge(int prefixBitLength, List<Long> one, List<Long> two) {
        long hash;
        DenseHll hll1 = new DenseHll(prefixBitLength);
        DenseHll hll2 = new DenseHll(prefixBitLength);
        DenseHll expected = new DenseHll(prefixBitLength);
        for (long value : one) {
            hash = XxHash64.hash((long)value);
            hll1.insertHash(hash);
            expected.insertHash(hash);
        }
        for (long value : two) {
            hash = XxHash64.hash((long)value);
            hll2.insertHash(hash);
            expected.insertHash(hash);
        }
        hll1.verify();
        hll2.verify();
        hll1.mergeWith(hll2);
        hll1.verify();
        Assert.assertEquals((long)hll1.cardinality(), (long)expected.cardinality());
        SliceAssertions.assertSlicesEqual((Slice)hll1.serialize(), (Slice)expected.serialize());
    }

    private static void assertSameBuckets(TestingHll testingHll, DenseHll hll) {
        for (int i = 0; i < testingHll.getBuckets().length; ++i) {
            Assert.assertEquals((int)hll.getValue(i), (int)testingHll.getBuckets()[i]);
        }
    }

    @DataProvider(name="bits")
    private Object[][] prefixLengths() {
        return new Object[][]{{4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {14}, {15}, {16}};
    }
}

