/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.DenseHll;
import com.facebook.airlift.stats.cardinality.Format;
import com.facebook.airlift.stats.cardinality.Utils;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Murmur3Hash128;
import io.airlift.slice.Slice;
import io.airlift.slice.testing.SliceAssertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDenseSerialization {
    @Test
    public void testEmpty() throws Exception {
        DynamicSliceOutput expected = new DynamicSliceOutput(1).appendByte(3).appendByte(12).appendByte(0);
        for (int i = 0; i < 2048; ++i) {
            expected.appendByte(0);
        }
        expected.appendByte(0).appendByte(0);
        SliceAssertions.assertSlicesEqual((Slice)TestDenseSerialization.makeHll(12, new long[0]).serialize(), (Slice)expected.slice());
    }

    @Test
    public void testSingleNoOverflow() throws Exception {
        byte[] buckets = new byte[2048];
        buckets[326] = 1;
        Slice expected = new DynamicSliceOutput(1).appendByte(3).appendByte(12).appendByte(0).appendBytes(buckets).appendByte(0).appendByte(0).slice();
        SliceAssertions.assertSlicesEqual((Slice)TestDenseSerialization.makeHll(12, 0L).serialize(), (Slice)expected);
    }

    @Test
    public void testSingleWithOverflow() throws Exception {
        byte[] buckets = new byte[2048];
        buckets[1353] = -16;
        Slice expected = new DynamicSliceOutput(1).appendByte(3).appendByte(12).appendByte(0).appendBytes(buckets).appendByte(1).appendByte(0).appendByte(146).appendByte(10).appendByte(2).slice();
        SliceAssertions.assertSlicesEqual((Slice)TestDenseSerialization.makeHll(12, 61697L).serialize(), (Slice)expected);
    }

    @Test
    public void testMultipleOverflow() throws Exception {
        byte[] buckets = new byte[2048];
        buckets[1353] = -16;
        buckets[2024] = -16;
        Slice expected = new DynamicSliceOutput(1).appendByte(3).appendByte(12).appendByte(0).appendBytes(buckets).appendByte(2).appendByte(0).appendByte(146).appendByte(10).appendByte(208).appendByte(15).appendByte(2).appendByte(4).slice();
        SliceAssertions.assertSlicesEqual((Slice)TestDenseSerialization.makeHll(12, 61697L, 394873L).serialize(), (Slice)expected);
        SliceAssertions.assertSlicesEqual((Slice)TestDenseSerialization.makeHll(12, 394873L, 61697L).serialize(), (Slice)expected);
    }

    @Test
    public void testMergeWithOverflows() throws Exception {
        DenseHll expected = TestDenseSerialization.makeHll(4, 37227L, 93351L);
        SliceAssertions.assertSlicesEqual((Slice)TestDenseSerialization.makeHll(4, 37227L).mergeWith(TestDenseSerialization.makeHll(4, 93351L)).serialize(), (Slice)expected.serialize());
        SliceAssertions.assertSlicesEqual((Slice)TestDenseSerialization.makeHll(4, 93351L).mergeWith(TestDenseSerialization.makeHll(4, 37227L)).serialize(), (Slice)expected.serialize());
    }

    @Test
    public void testBaselineAdjusment() throws Exception {
        byte[] buckets = new byte[]{69, 35, 1, 49, 34, 5, 4, 1};
        Slice expected = new DynamicSliceOutput(1).appendByte(3).appendByte(4).appendByte(2).appendBytes(buckets).appendByte(0).appendByte(0).slice();
        DenseHll hll = new DenseHll(4);
        for (int i = 0; i < 100; ++i) {
            hll.insertHash(Murmur3Hash128.hash64((long)i));
        }
        SliceAssertions.assertSlicesEqual((Slice)hll.serialize(), (Slice)expected);
    }

    @Test
    public void testOverflowAfterBaselineIncrement() throws Exception {
        byte[] buckets = new byte[]{69, 35, 1, 49, 34, 5, 4, -15};
        Slice expected = new DynamicSliceOutput(1).appendByte(3).appendByte(4).appendByte(2).appendBytes(buckets).appendByte(1).appendByte(0).appendByte(14).appendByte(0).appendByte(5).slice();
        DenseHll hll = new DenseHll(4);
        for (int i = 0; i < 100; ++i) {
            hll.insertHash(Murmur3Hash128.hash64((long)i));
        }
        hll.insertHash(Murmur3Hash128.hash64((long)37227L));
        SliceAssertions.assertSlicesEqual((Slice)hll.serialize(), (Slice)expected);
    }

    @Test
    public void testBaselineAdjustmentAfterOverflow() throws Exception {
        byte[] buckets = new byte[]{69, 35, 1, 49, 34, 5, 4, -15};
        Slice expected = new DynamicSliceOutput(1).appendByte(3).appendByte(4).appendByte(2).appendBytes(buckets).appendByte(1).appendByte(0).appendByte(14).appendByte(0).appendByte(5).slice();
        DenseHll hll = new DenseHll(4);
        hll.insertHash(Murmur3Hash128.hash64((long)37227L));
        for (int i = 0; i < 100; ++i) {
            hll.insertHash(Murmur3Hash128.hash64((long)i));
        }
        SliceAssertions.assertSlicesEqual((Slice)hll.serialize(), (Slice)expected);
    }

    @Test
    public void testRoundtrip() throws Exception {
        DenseHll hll = new DenseHll(4);
        for (int i = 0; i < 1000; ++i) {
            hll.insertHash(Murmur3Hash128.hash64((long)i));
            Slice serialized = hll.serialize();
            Slice reserialized = new DenseHll(serialized).serialize();
            SliceAssertions.assertSlicesEqual((Slice)serialized, (Slice)reserialized);
        }
    }

    @Test
    public void testDeserializeDenseV1NoOverflows() throws Exception {
        int indexBitLength = 4;
        int numberOfBuckets = Utils.numberOfBuckets((int)indexBitLength);
        Slice serialized = new DynamicSliceOutput(1).appendByte((int)Format.DENSE_V1.getTag()).appendByte(indexBitLength).appendByte(10).appendBytes(new byte[numberOfBuckets / 2]).appendByte(255).appendByte(255).appendByte(0).slice();
        DenseHll deserialized = new DenseHll(serialized);
        for (int i = 0; i < numberOfBuckets; ++i) {
            Assert.assertEquals((int)deserialized.getValue(i), (int)10);
        }
        deserialized.verify();
    }

    @Test
    public void testDeserializeDenseV1EmptyOverflow() throws Exception {
        int indexBitLength = 4;
        int numberOfBuckets = Utils.numberOfBuckets((int)indexBitLength);
        Slice serialized = new DynamicSliceOutput(1).appendByte((int)Format.DENSE_V1.getTag()).appendByte(indexBitLength).appendByte(2).appendBytes(new byte[]{15, 0, 0, 0, 0, 0, 0, 0}).appendByte(1).appendByte(0).appendByte(0).slice();
        DenseHll deserialized = new DenseHll(serialized);
        for (int i = 0; i < numberOfBuckets; ++i) {
            if (i == 1) {
                Assert.assertEquals((int)deserialized.getValue(i), (int)17);
                continue;
            }
            Assert.assertEquals((int)deserialized.getValue(i), (int)2);
        }
        deserialized.verify();
    }

    @Test
    public void testDeserializeDenseV1Overflow() throws Exception {
        int indexBitLength = 4;
        int numberOfBuckets = Utils.numberOfBuckets((int)indexBitLength);
        Slice serialized = new DynamicSliceOutput(1).appendByte((int)Format.DENSE_V1.getTag()).appendByte(indexBitLength).appendByte(2).appendBytes(new byte[]{15, 0, 0, 0, 0, 0, 0, 0}).appendByte(1).appendByte(0).appendByte(3).slice();
        DenseHll deserialized = new DenseHll(serialized);
        for (int i = 0; i < numberOfBuckets; ++i) {
            if (i == 1) {
                Assert.assertEquals((int)deserialized.getValue(i), (int)20);
                continue;
            }
            Assert.assertEquals((int)deserialized.getValue(i), (int)2);
        }
        deserialized.verify();
    }

    private static DenseHll makeHll(int indexBits, long ... values) {
        DenseHll result = new DenseHll(indexBits);
        for (long value : values) {
            result.insertHash(Murmur3Hash128.hash64((long)value));
        }
        return result;
    }
}

