/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.airlift.stats.cardinality.SparseHll;
import com.facebook.airlift.stats.cardinality.Stats;
import com.facebook.airlift.stats.cardinality.TestUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.testing.SliceAssertions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHyperLogLog {
    @Test
    public void testEstimates() {
        int trials = 1000;
        for (int indexBits = 4; indexBits <= 13; ++indexBits) {
            HashMap<Integer, Stats> errors = new HashMap<Integer, Stats>();
            int numberOfBuckets = 1 << indexBits;
            int maxCardinality = numberOfBuckets * 2;
            for (int trial = 0; trial < trials; ++trial) {
                HyperLogLog hll = HyperLogLog.newInstance((int)numberOfBuckets);
                for (int cardinality = 1; cardinality <= maxCardinality; ++cardinality) {
                    hll.add(ThreadLocalRandom.current().nextLong());
                    if (cardinality % (numberOfBuckets / 10) != 0) continue;
                    double error = (double)(hll.cardinality() - (long)cardinality) * 1.0 / (double)cardinality;
                    Stats stats = (Stats)errors.get(cardinality);
                    if (stats == null) {
                        stats = new Stats();
                        errors.put(cardinality, stats);
                    }
                    stats.add(error);
                }
            }
            double expectedStandardError = 1.04 / Math.sqrt(1 << indexBits);
            for (Map.Entry entry : errors.entrySet()) {
                Assert.assertTrue((((Stats)entry.getValue()).stdev() <= expectedStandardError * 1.1 ? 1 : 0) != 0, (String)String.format("Failed at p = %s, cardinality = %s. Expected std error = %s, actual = %s", indexBits, entry.getKey(), expectedStandardError, ((Stats)entry.getValue()).stdev()));
            }
        }
    }

    @Test
    public void testRetainedSize() throws Exception {
        Assert.assertEquals((int)HyperLogLog.newInstance((int)8).estimatedInMemorySize(), (int)Math.toIntExact(ClassLayout.parseClass(HyperLogLog.class).instanceSize() + new SparseHll(10).estimatedInMemorySize()));
    }

    @Test
    public void testMerge() throws Exception {
        this.verifyMerge(TestUtils.sequence(0, 100), TestUtils.sequence(50, 150));
        this.verifyMerge(TestUtils.sequence(0, 100), TestUtils.sequence(50, 5000));
        this.verifyMerge(TestUtils.sequence(50, 5000), TestUtils.sequence(0, 100));
        this.verifyMerge(TestUtils.sequence(0, 5000), TestUtils.sequence(3000, 8000));
    }

    private void verifyMerge(List<Long> one, List<Long> two) {
        HyperLogLog hll1 = HyperLogLog.newInstance((int)2048);
        HyperLogLog hll2 = HyperLogLog.newInstance((int)2048);
        HyperLogLog expected = HyperLogLog.newInstance((int)2048);
        for (long value : one) {
            hll1.add(value);
            expected.add(value);
        }
        for (long value : two) {
            hll2.add(value);
            expected.add(value);
        }
        hll1.verify();
        hll2.verify();
        hll1.mergeWith(hll2);
        hll1.verify();
        Assert.assertEquals((long)hll1.cardinality(), (long)expected.cardinality());
        Assert.assertEquals((Object)hll1.serialize(), (Object)expected.serialize());
    }

    @Test
    public void testRoundtrip() throws Exception {
        this.verifyRoundtrip(TestUtils.sequence(0, 100));
        this.verifyRoundtrip(TestUtils.sequence(0, 20000));
    }

    private void verifyRoundtrip(List<Long> sequence) {
        HyperLogLog hll = HyperLogLog.newInstance((int)2048);
        for (Long value : sequence) {
            hll.add(value.longValue());
        }
        hll.verify();
        Slice serialized = hll.serialize();
        HyperLogLog deserialized = HyperLogLog.newInstance((Slice)serialized);
        deserialized.verify();
        Assert.assertEquals((long)hll.cardinality(), (long)deserialized.cardinality());
        Slice reserialized = deserialized.serialize();
        SliceAssertions.assertSlicesEqual((Slice)serialized, (Slice)reserialized);
    }
}

