/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.airlift.stats.cardinality.PrivateLpcaSketch;
import com.facebook.airlift.stats.cardinality.RandomizationStrategy;
import com.facebook.airlift.stats.cardinality.TestingDeterministicRandomizationStrategy;
import io.airlift.slice.Slice;
import io.airlift.slice.testing.SliceAssertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPrivateLpcaSketch {
    @Test
    public void testThresholding() {
        HyperLogLog hll = HyperLogLog.newInstance((int)1024);
        for (int i = 0; i < 100000; ++i) {
            hll.add((long)i);
        }
        PrivateLpcaSketch lpca = new PrivateLpcaSketch(hll, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, (RandomizationStrategy)new TestingDeterministicRandomizationStrategy());
        int threshold = lpca.getThreshold();
        int[] rawBuckets = this.getBucketValues(hll);
        for (int i = 0; i < rawBuckets.length; ++i) {
            Assert.assertEquals((boolean)lpca.getBitmap().getBit(i), (rawBuckets[i] > threshold ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRoundTrip() {
        HyperLogLog hll = HyperLogLog.newInstance((int)1024);
        for (int i = 0; i < 100000; ++i) {
            hll.add((long)i);
        }
        PrivateLpcaSketch one = new PrivateLpcaSketch(hll, 1.0, 1.0);
        Slice serialized = one.serialize();
        PrivateLpcaSketch two = new PrivateLpcaSketch(serialized);
        Slice reserialized = two.serialize();
        SliceAssertions.assertSlicesEqual((Slice)serialized, (Slice)reserialized);
    }

    @Test
    public void testBitmapSize() {
        int[] bucketCounts;
        for (int count : bucketCounts = new int[]{16, 32, 64, 128, 256, 512, 1024, 2048, 4096}) {
            HyperLogLog hll = HyperLogLog.newInstance((int)count);
            PrivateLpcaSketch lpca = new PrivateLpcaSketch(hll, 1.0, 1.0);
            Assert.assertEquals((int)lpca.getBitmap().length(), (int)count);
        }
    }

    @Test
    public void testUpdate() {
        HyperLogLog hll1 = HyperLogLog.newInstance((int)1024);
        HyperLogLog hll2 = HyperLogLog.newInstance((int)1024);
        for (int i = 0; i < 100000; ++i) {
            hll1.add((long)(i + 1));
            hll2.add((long)(-i));
        }
        PrivateLpcaSketch lpca = new PrivateLpcaSketch(hll1, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, (RandomizationStrategy)new TestingDeterministicRandomizationStrategy());
        lpca.update(hll2);
        int threshold = lpca.getThreshold();
        int[] values1 = this.getBucketValues(hll1);
        int[] values2 = this.getBucketValues(hll2);
        for (int i = 0; i < values1.length; ++i) {
            Assert.assertEquals((boolean)lpca.getBitmap().getBit(i), (Math.max(values1[i], values2[i]) > threshold ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUpdateIncompatible() {
        HyperLogLog hll1 = HyperLogLog.newInstance((int)1024);
        HyperLogLog hll2 = HyperLogLog.newInstance((int)512);
        PrivateLpcaSketch lpca = new PrivateLpcaSketch(hll1, 1.0, 1.0, (RandomizationStrategy)new TestingDeterministicRandomizationStrategy());
        boolean thrown = false;
        try {
            lpca.update(hll2);
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    @Test
    public void testBitProportion() {
        HyperLogLog hll = HyperLogLog.newInstance((int)32);
        PrivateLpcaSketch lpca = new PrivateLpcaSketch(hll, 1.0, 1.0, (RandomizationStrategy)new TestingDeterministicRandomizationStrategy());
        int cutoff = 18;
        for (int i = 0; i < lpca.getNumberOfBuckets(); ++i) {
            lpca.getBitmap().setBit(i, i < cutoff);
        }
        Assert.assertEquals((Object)lpca.getRawBitProportion(), (Object)0.5625);
    }

    private int[] getBucketValues(HyperLogLog hll) {
        int[] values = new int[hll.getNumberOfBuckets()];
        hll.eachBucket((i, value) -> {
            values[i] = value;
        });
        return values;
    }
}

