/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.Bitmap;
import com.facebook.airlift.stats.cardinality.RandomizationStrategy;
import com.facebook.airlift.stats.cardinality.SecureRandomizationStrategy;
import com.facebook.airlift.stats.cardinality.SfmSketch;
import com.facebook.airlift.stats.cardinality.TestingSeededRandomizationStrategy;
import io.airlift.slice.Slice;
import io.airlift.slice.testing.SliceAssertions;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSfmSketch {
    @Test
    public void testRoundTrip() {
        SfmSketch sketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        for (int i = 0; i < 100000; ++i) {
            sketch.add((long)i);
        }
        sketch.enablePrivacy(2.0);
        Slice serialized = sketch.serialize();
        SfmSketch unserialized = SfmSketch.deserialize((Slice)serialized, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        SliceAssertions.assertSlicesEqual((Slice)serialized, (Slice)unserialized.serialize());
    }

    @Test
    public void testPrivacyEnabled() {
        SfmSketch sketch = SfmSketch.create((int)32, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        Assert.assertFalse((boolean)sketch.isPrivacyEnabled());
        sketch.enablePrivacy(Double.POSITIVE_INFINITY);
        Assert.assertFalse((boolean)sketch.isPrivacyEnabled());
        sketch.enablePrivacy(1.23);
        Assert.assertTrue((boolean)sketch.isPrivacyEnabled());
    }

    @Test
    public void testSerializedSize() {
        SfmSketch sketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        sketch.enablePrivacy(1.23);
        Assert.assertEquals((int)sketch.estimatedSerializedSize(), (int)sketch.serialize().length());
    }

    @Test
    public void testRetainedSize() {
        SfmSketch sketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new SecureRandomizationStrategy());
        sketch.enablePrivacy(4.0);
        Assert.assertEquals((long)sketch.getRetainedSizeInBytes(), (long)((long)(ClassLayout.parseClass(SfmSketch.class).instanceSize() + ClassLayout.parseClass(SecureRandomizationStrategy.class).instanceSize()) + sketch.getBitmap().getRetainedSizeInBytes()));
    }

    @Test
    public void testBitmapSize() {
        int[] buckets = new int[]{32, 64, 512, 1024, 4096, 32768};
        int[] precisions = new int[]{8, 16, 24, 32};
        for (int numberOfBuckets : buckets) {
            for (int precision : precisions) {
                SfmSketch sketch = SfmSketch.create((int)numberOfBuckets, (int)precision, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
                Assert.assertEquals((int)sketch.getBitmap().length(), (int)(numberOfBuckets * precision));
            }
        }
    }

    @Test
    public void testMergeNonPrivate() {
        SfmSketch sketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        SfmSketch sketch2 = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        for (int i = 0; i < 100000; ++i) {
            sketch.add((long)i);
            sketch2.add((long)(-i - 1));
        }
        Bitmap before = sketch.getBitmap().clone();
        sketch.mergeWith(sketch2);
        Assert.assertEquals((byte[])sketch.getBitmap().toBytes(), (byte[])before.or(sketch2.getBitmap()).toBytes());
        Assert.assertFalse((boolean)sketch.isPrivacyEnabled());
    }

    @Test
    public void testMergePrivate() {
        SfmSketch sketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        SfmSketch sketch2 = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(2L));
        for (int i = 0; i < 100000; ++i) {
            sketch.add((long)i);
            sketch2.add((long)(-i - 1));
        }
        Bitmap nonPrivateBitmap = sketch.getBitmap().clone();
        Bitmap nonPrivateBitmap2 = sketch2.getBitmap().clone();
        sketch.enablePrivacy(3.0);
        sketch2.enablePrivacy(4.0);
        double p1 = sketch.getRandomizedResponseProbability();
        double p2 = sketch2.getRandomizedResponseProbability();
        Bitmap unmergedBitmap = sketch.getBitmap().clone();
        sketch.mergeWith(sketch2);
        Assert.assertTrue((boolean)sketch.isPrivacyEnabled());
        Assert.assertEquals((Object)sketch.getRandomizedResponseProbability(), (Object)SfmSketch.mergeRandomizedResponseProbabilities((double)p1, (double)p2));
        Assert.assertNotEquals((Object)sketch.getBitmap().toBytes(), (Object)unmergedBitmap.or(sketch2.getBitmap()).toBytes());
        int actualBitCount = sketch.getBitmap().getBitCount();
        Bitmap hypotheticalBitmap = nonPrivateBitmap.or(nonPrivateBitmap2);
        hypotheticalBitmap.flipAll(sketch.getRandomizedResponseProbability(), (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        Assert.assertEquals((float)hypotheticalBitmap.getBitCount(), (float)actualBitCount, (float)100.0f);
    }

    @Test
    public void testMergeMixed() {
        SfmSketch sketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        SfmSketch sketch2 = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(2L));
        for (int i = 0; i < 100000; ++i) {
            sketch.add((long)i);
            sketch2.add((long)(-i - 1));
        }
        sketch2.enablePrivacy(3.0);
        Bitmap before = sketch.getBitmap().clone();
        sketch.mergeWith(sketch2);
        Assert.assertTrue((boolean)sketch.isPrivacyEnabled());
        for (int i = 0; i < before.length(); ++i) {
            if (before.getBit(i)) continue;
            Assert.assertEquals((boolean)sketch.getBitmap().getBit(i), (boolean)sketch2.getBitmap().getBit(i));
        }
    }

    @Test
    public void testMergedProbabilities() {
        Assert.assertEquals((Object)SfmSketch.mergeRandomizedResponseProbabilities((double)0.1, (double)0.2), (Object)SfmSketch.mergeRandomizedResponseProbabilities((double)0.2, (double)0.1));
        Assert.assertEquals((Object)SfmSketch.mergeRandomizedResponseProbabilities((double)0.0, (double)0.1), (Object)0.1);
        Assert.assertEquals((Object)SfmSketch.mergeRandomizedResponseProbabilities((double)0.15, (double)0.0), (Object)0.15);
        Assert.assertEquals((Object)SfmSketch.mergeRandomizedResponseProbabilities((double)0.0, (double)0.0), (Object)0.0);
        double epsilon1 = 1.2;
        double epsilon2 = 3.4;
        double p1 = SfmSketch.getRandomizedResponseProbability((double)epsilon1);
        double p2 = SfmSketch.getRandomizedResponseProbability((double)epsilon2);
        double epsilonStar = -Math.log(Math.exp(-epsilon1) + Math.exp(-epsilon2) - Math.exp(-(epsilon1 + epsilon2)));
        double pStar = SfmSketch.getRandomizedResponseProbability((double)epsilonStar);
        Assert.assertEquals((double)SfmSketch.mergeRandomizedResponseProbabilities((double)p1, (double)p2), (double)pStar, (double)1.0E-6);
        Assert.assertTrue((pStar > Math.max(p1, p2) ? 1 : 0) != 0);
    }

    @Test
    public void testEmptySketchCardinality() {
        SfmSketch nonPrivateSketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        SfmSketch privateSketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(2L));
        privateSketch.enablePrivacy(3.0);
        Assert.assertEquals((long)nonPrivateSketch.cardinality(), (long)0L);
        Assert.assertEquals((float)privateSketch.cardinality(), (float)0.0f, (float)200.0f);
    }

    @Test
    public void testSmallCardinality() {
        int[] ns;
        for (int n : ns = new int[]{1, 5, 10, 50, 100, 200, 500, 1000}) {
            SfmSketch nonPrivateSketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
            SfmSketch privateSketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(2L));
            for (int i = 0; i < n; ++i) {
                nonPrivateSketch.add((long)i);
                privateSketch.add((long)i);
            }
            privateSketch.enablePrivacy(3.0);
            Assert.assertEquals((double)nonPrivateSketch.cardinality(), (double)n, (double)Math.max(10.0, 0.1 * (double)n));
            Assert.assertEquals((float)privateSketch.cardinality(), (float)n, (float)200.0f);
        }
    }

    @Test
    public void testActualCardinalityEstimates() {
        int[] magnitudes = new int[]{4, 5, 6};
        double[] epsilons = new double[]{4.0, Double.POSITIVE_INFINITY};
        for (int mag : magnitudes) {
            int n = (int)Math.pow(10.0, mag);
            for (double eps : epsilons) {
                SfmSketch sketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
                for (int i = 0; i < n; ++i) {
                    sketch.add((long)i);
                }
                sketch.enablePrivacy(eps);
                Assert.assertEquals((double)sketch.cardinality(), (double)n, (double)((double)n * 0.1));
            }
        }
    }

    @Test
    public void testSimulatedCardinalityEstimates() {
        int[] magnitudes = new int[]{6, 9, 12, 15, 18, 21, 24, 27, 30, 33};
        double[] epsilons = new double[]{4.0, Double.POSITIVE_INFINITY};
        for (int mag : magnitudes) {
            int n = (int)Math.pow(10.0, mag);
            for (double eps : epsilons) {
                SfmSketch sketch = TestSfmSketch.createSketchWithTargetCardinality(4096, 24, eps, n);
                Assert.assertEquals((double)sketch.cardinality(), (double)n, (double)((double)n * 0.1));
            }
        }
    }

    @Test
    public void testMergedCardinalities() {
        double[] epsilons;
        for (double eps1 : epsilons = new double[]{3.0, 4.0, Double.POSITIVE_INFINITY}) {
            for (double eps2 : epsilons) {
                SfmSketch sketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
                SfmSketch sketch2 = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(2L));
                for (int i = 0; i < 300000; ++i) {
                    sketch.add((long)(i + 1));
                    if (i >= 200000) continue;
                    sketch2.add((long)(-i));
                }
                sketch.enablePrivacy(eps1);
                sketch2.enablePrivacy(eps2);
                sketch.mergeWith(sketch2);
                Assert.assertEquals((double)sketch.cardinality(), (double)500000.0, (double)50000.0);
            }
        }
    }

    @Test
    public static void testEnablePrivacy() {
        SfmSketch sketch = SfmSketch.create((int)4096, (int)24, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        double epsilon = 4.0;
        for (int i = 0; i < 100000; ++i) {
            sketch.add((long)i);
        }
        long cardinalityBefore = sketch.cardinality();
        sketch.enablePrivacy(epsilon);
        long cardinalityAfter = sketch.cardinality();
        Assert.assertEquals((Object)sketch.getRandomizedResponseProbability(), (Object)SfmSketch.getRandomizedResponseProbability((double)epsilon));
        Assert.assertTrue((boolean)sketch.isPrivacyEnabled());
        Assert.assertEquals((double)cardinalityAfter, (double)cardinalityBefore, (double)((double)cardinalityBefore * 0.1));
    }

    private static SfmSketch createSketchWithTargetCardinality(int numberOfBuckets, int precision, double epsilon, int cardinality) {
        TestingSeededRandomizationStrategy random = new TestingSeededRandomizationStrategy(1L);
        SfmSketch sketch = SfmSketch.create((int)numberOfBuckets, (int)precision, (RandomizationStrategy)random);
        Bitmap bitmap = sketch.getBitmap();
        double c1 = sketch.getOnProbability();
        double c2 = sketch.getOnProbability() - sketch.getRandomizedResponseProbability();
        for (int l = 0; l < precision; ++l) {
            double p = c1 - c2 * Math.pow(1.0 - Math.pow(2.0, -(l + 1)) / (double)numberOfBuckets, cardinality);
            for (int b = 0; b < numberOfBuckets; ++b) {
                bitmap.setBit(sketch.getBitLocation(b, l), random.nextBoolean(p));
            }
        }
        sketch.enablePrivacy(epsilon);
        return sketch;
    }
}

