/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.DenseHll;
import com.facebook.airlift.stats.cardinality.SparseHll;
import com.facebook.airlift.stats.cardinality.TestUtils;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Murmur3Hash128;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.testing.SliceAssertions;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestSparseHll {
    private static final int SPARSE_HLL_INSTANCE_SIZE = ClassLayout.parseClass(SparseHll.class).instanceSize();

    @Test(dataProvider="bits")
    public void testNumberOfZeros(int indexBitLength) {
        for (int i = 0; i < 64 - indexBitLength; ++i) {
            long hash = 1L << i;
            int expectedValue = Long.numberOfLeadingZeros(hash << indexBitLength) + 1;
            SparseHll sparseHll = new SparseHll(indexBitLength);
            sparseHll.insertHash(hash);
            sparseHll.eachBucket((bucket, value) -> {
                Assert.assertEquals((int)bucket, (int)0);
                Assert.assertEquals((int)value, (int)expectedValue);
            });
        }
    }

    @Test(dataProvider="bits")
    public void testMerge(int prefixBitLength) throws Exception {
        TestSparseHll.verifyMerge(prefixBitLength, TestUtils.sequence(0, 100), TestUtils.sequence(50, 150));
        TestSparseHll.verifyMerge(prefixBitLength, TestUtils.sequence(50, 150), TestUtils.sequence(0, 100));
        TestSparseHll.verifyMerge(prefixBitLength, TestUtils.sequence(0, 100), TestUtils.sequence(200, 300));
        TestSparseHll.verifyMerge(prefixBitLength, TestUtils.sequence(200, 300), TestUtils.sequence(0, 100));
        TestSparseHll.verifyMerge(prefixBitLength, TestUtils.sequence(0, 100), TestUtils.sequence(0, 100));
        TestSparseHll.verifyMerge(prefixBitLength, (List<Long>)ImmutableList.of((Object)29678L, (Object)54004L), (List<Long>)ImmutableList.of((Object)64034L, (Object)20591L, (Object)56987L));
        TestSparseHll.verifyMerge(prefixBitLength, (List<Long>)ImmutableList.of((Object)64034L, (Object)20591L, (Object)56987L), (List<Long>)ImmutableList.of((Object)29678L, (Object)54004L));
    }

    @Test(dataProvider="bits")
    public void testToDense(int prefixBitLength) throws Exception {
        TestSparseHll.verifyToDense(prefixBitLength, TestUtils.sequence(0, 10000));
        TestSparseHll.verifyToDense(prefixBitLength, (List<Long>)ImmutableList.of((Object)201L, (Object)280L));
        TestSparseHll.verifyToDense(prefixBitLength, (List<Long>)ImmutableList.of((Object)224L, (Object)271L));
    }

    @Test
    public void testRetainedSize() {
        SparseHll sparseHll = new SparseHll(10);
        int[] entries = new int[1];
        long retainedSize = SizeOf.sizeOf((int[])entries) + (long)SPARSE_HLL_INSTANCE_SIZE;
        for (int value = 0; value < 100; ++value) {
            sparseHll.insertHash(Murmur3Hash128.hash64((long)value));
            if (value % 10 == 1) {
                entries = new int[value + 10];
                retainedSize = SizeOf.sizeOf((int[])entries) + (long)SPARSE_HLL_INSTANCE_SIZE;
            }
            Assert.assertEquals((long)sparseHll.estimatedInMemorySize(), (long)retainedSize);
        }
    }

    private static void verifyMerge(int prefixBitLength, List<Long> one, List<Long> two) {
        long hash;
        SparseHll hll1 = new SparseHll(prefixBitLength);
        SparseHll hll2 = new SparseHll(prefixBitLength);
        SparseHll expected = new SparseHll(prefixBitLength);
        for (long value : one) {
            hash = Murmur3Hash128.hash64((long)value);
            hll1.insertHash(hash);
            expected.insertHash(hash);
        }
        for (long value : two) {
            hash = Murmur3Hash128.hash64((long)value);
            hll2.insertHash(hash);
            expected.insertHash(hash);
        }
        hll1.verify();
        hll2.verify();
        hll1.mergeWith(hll2);
        hll1.verify();
        Assert.assertEquals((long)hll1.cardinality(), (long)expected.cardinality());
        SliceAssertions.assertSlicesEqual((Slice)hll1.serialize(), (Slice)expected.serialize());
    }

    private static void verifyToDense(int prefixBitLength, List<Long> values) {
        DenseHll expected = new DenseHll(prefixBitLength);
        SparseHll sparse = new SparseHll(prefixBitLength);
        for (long value : values) {
            long hash = Murmur3Hash128.hash64((long)value);
            sparse.insertHash(hash);
            expected.insertHash(hash);
        }
        sparse.verify();
        expected.verify();
        SliceAssertions.assertSlicesEqual((Slice)sparse.toDense().serialize(), (Slice)expected.serialize());
    }

    @DataProvider(name="bits")
    private Object[][] prefixLengths() {
        return new Object[][]{{4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {14}, {15}};
    }
}

