/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public final class TestUtils {
    private TestUtils() {
    }

    public static List<Long> sequence(int start, int end) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long i = (long)start; i < (long)end; ++i) {
            builder.add((Object)i);
        }
        return builder.build();
    }

    public static long createHashForBucket(int indexBitLength, int bucket, int leadingZeros) {
        long hash = 1L << 64 - (indexBitLength + leadingZeros + 1);
        return hash |= (long)bucket << 64 - indexBitLength;
    }

    @Test
    public void testPowerOf2() {
        for (int i = 1; i < 20; ++i) {
            Assert.assertTrue((boolean)Utils.isPowerOf2((long)Math.round(Math.pow(2.0, i))));
            Assert.assertFalse((boolean)Utils.isPowerOf2((long)(Math.round(Math.pow(2.0, i)) + 1L)));
        }
    }

    @Test
    public void testNumberOfBuckets() {
        for (int i = 1; i < 20; ++i) {
            Assert.assertEquals((long)Utils.numberOfBuckets((int)i), (long)Math.round(Math.pow(2.0, i)));
        }
    }

    @Test
    public void testIndexBitLength() {
        for (int i = 1; i < 20; ++i) {
            Assert.assertEquals((int)Utils.indexBitLength((int)((int)Math.pow(2.0, i))), (int)i);
        }
    }

    @Test
    public void testNumberOfLeadingZeros() {
        for (int indexBitLength : new int[]{6, 12, 18}) {
            for (int i = 0; i < 64 - indexBitLength; ++i) {
                long hash = TestUtils.createHashForBucket(indexBitLength, 0, i);
                Assert.assertEquals((int)Utils.numberOfLeadingZeros((long)hash, (int)indexBitLength), (int)i);
            }
        }
    }

    @Test
    public void testNumberOfTrailingZeros() {
        for (int indexBitLength : new int[]{6, 12, 18}) {
            for (int i = 0; i < 63; ++i) {
                long hash = 1L << i;
                Assert.assertEquals((int)Utils.numberOfTrailingZeros((long)hash, (int)indexBitLength), (int)Math.min(i, 64 - indexBitLength));
            }
        }
    }

    @Test
    public void testComputeIndex() {
        for (int indexBitLength : new int[]{6, 12, 18}) {
            long index = 5L;
            long hash = index << 64 - indexBitLength;
            Assert.assertEquals((long)Utils.computeIndex((long)hash, (int)indexBitLength), (long)index);
        }
    }
}

