/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.RandomizationStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceInput;
import org.openjdk.jol.info.ClassLayout;

public class Bitmap {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Bitmap.class).instanceSize();
    private final byte[] bitmap;

    public Bitmap(int length) {
        Bitmap.validateLength(length);
        this.bitmap = new byte[length / 8];
    }

    private Bitmap(byte[] bytes) {
        this.bitmap = bytes;
    }

    public static Bitmap fromBytes(byte[] bytes) {
        return new Bitmap(bytes);
    }

    public static Bitmap fromSliceInput(SliceInput input, int length) {
        Bitmap.validateLength(length);
        byte[] bytes = new byte[length / 8];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = input.readByte();
        }
        return Bitmap.fromBytes(bytes);
    }

    public byte[] toBytes() {
        return this.bitmap;
    }

    @VisibleForTesting
    static int bitmapBitShift(int position) {
        return position % 8;
    }

    @VisibleForTesting
    static int bitmapByteIndex(int position) {
        return Math.floorDiv(position, 8);
    }

    public int byteLength() {
        return this.bitmap.length;
    }

    public Bitmap clone() {
        return Bitmap.fromBytes((byte[])this.bitmap.clone());
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.bitmap);
    }

    public boolean getBit(int position) {
        int shift;
        int b = Bitmap.bitmapByteIndex(position);
        return (this.bitmap[b] >> (shift = Bitmap.bitmapBitShift(position)) & 1) == 1;
    }

    public int getBitCount() {
        int count = 0;
        for (byte b : this.bitmap) {
            count += Integer.bitCount(Byte.toUnsignedInt(b));
        }
        return count;
    }

    public void flipAll(double probability, RandomizationStrategy randomizationStrategy) {
        for (int i = 0; i < this.bitmap.length * 8; ++i) {
            this.flipBit(i, probability, randomizationStrategy);
        }
    }

    public void flipBit(int position) {
        byte oneBit = (byte)(1 << Bitmap.bitmapBitShift(position));
        int n = Bitmap.bitmapByteIndex(position);
        this.bitmap[n] = (byte)(this.bitmap[n] ^ oneBit);
    }

    public void flipBit(int position, double probability, RandomizationStrategy randomizationStrategy) {
        if (randomizationStrategy.nextBoolean(probability)) {
            this.flipBit(position);
        }
    }

    public int length() {
        return this.bitmap.length * 8;
    }

    public void setBit(int position, boolean value) {
        byte oneBit = (byte)(1 << Bitmap.bitmapBitShift(position));
        if (value) {
            int n = Bitmap.bitmapByteIndex(position);
            this.bitmap[n] = (byte)(this.bitmap[n] | oneBit);
        } else {
            int n = Bitmap.bitmapByteIndex(position);
            this.bitmap[n] = (byte)(this.bitmap[n] & ~oneBit);
        }
    }

    public Bitmap or(Bitmap other) {
        byte[] bytesOther;
        byte[] bytes = (byte[])this.toBytes().clone();
        Preconditions.checkArgument((bytes.length == (bytesOther = other.toBytes()).length ? 1 : 0) != 0, (Object)"cannot OR two bitmaps of different size");
        for (int i = 0; i < bytes.length; ++i) {
            int n = i;
            bytes[n] = (byte)(bytes[n] | bytesOther[i]);
        }
        return Bitmap.fromBytes(bytes);
    }

    public Bitmap xor(Bitmap other) {
        byte[] bytesOther;
        byte[] bytes = (byte[])this.toBytes().clone();
        Preconditions.checkArgument((bytes.length == (bytesOther = other.toBytes()).length ? 1 : 0) != 0, (Object)"cannot XOR two bitmaps of different size");
        for (int i = 0; i < bytes.length; ++i) {
            int n = i;
            bytes[n] = (byte)(bytes[n] ^ bytesOther[i]);
        }
        return Bitmap.fromBytes(bytes);
    }

    private static void validateLength(int length) {
        Preconditions.checkArgument((length > 0 && length % 8 == 0 ? 1 : 0) != 0, (String)"bitmap size must be a positive multiple of %s", (int)8);
    }
}

