/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats.cardinality;

import com.facebook.airlift.stats.cardinality.Format;
import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.airlift.stats.cardinality.RandomizationStrategy;
import com.facebook.airlift.stats.cardinality.SecureRandomizationStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PrivateLpcaSketch {
    private byte[] bitmap;
    private final int threshold;
    private final int numberOfBuckets;
    private final double epsilonThreshold;
    private final double epsilonRandomizedResponse;
    private final RandomizationStrategy randomizationStrategy;
    private static final int BYTE_MASK = 255;

    public PrivateLpcaSketch(HyperLogLog hll, double epsilonThreshold, double epsilonRandomizedResponse) {
        this(hll, epsilonThreshold, epsilonRandomizedResponse, new SecureRandomizationStrategy());
    }

    public PrivateLpcaSketch(Slice serialized) {
        this(serialized, new SecureRandomizationStrategy());
    }

    public PrivateLpcaSketch(HyperLogLog hll, double epsilonThreshold, double epsilonRandomizedResponse, RandomizationStrategy randomizationStrategy) {
        this.randomizationStrategy = randomizationStrategy;
        this.epsilonThreshold = epsilonThreshold;
        this.epsilonRandomizedResponse = epsilonRandomizedResponse;
        this.numberOfBuckets = hll.getNumberOfBuckets();
        this.threshold = this.findThreshold(hll);
        this.writeBitmap(hll);
        this.applyRandomizedResponse();
    }

    public PrivateLpcaSketch(Slice serialized, RandomizationStrategy randomizationStrategy) {
        this.randomizationStrategy = randomizationStrategy;
        BasicSliceInput input = serialized.getInput();
        byte format = input.readByte();
        Preconditions.checkArgument((format == Format.PRIVATE_LPCA_V1.getTag() ? 1 : 0) != 0, (Object)"Wrong format tag");
        this.numberOfBuckets = input.readInt();
        this.threshold = input.readInt();
        this.epsilonThreshold = input.readDouble();
        this.epsilonRandomizedResponse = input.readDouble();
        this.bitmap = new byte[this.numberOfBuckets / 8];
        for (int i = 0; i < this.bitmap.length; ++i) {
            this.bitmap[i] = input.readByte();
        }
    }

    private void applyRandomizedResponse() {
        double p = this.getFlipProbability();
        for (int i = 0; i < this.numberOfBuckets; ++i) {
            if (!this.randomizationStrategy.nextBoolean(p)) continue;
            this.flipBit(i);
        }
    }

    private void applyRandomizedResponse(int bucket) {
        double p = this.getFlipProbability();
        if (this.randomizationStrategy.nextBoolean(p)) {
            this.flipBit(bucket);
        }
    }

    @VisibleForTesting
    static int bitmapBitShift(int bucket) {
        return bucket % 8;
    }

    @VisibleForTesting
    static int bitmapByteIndex(int bucket) {
        return Math.floorDiv(bucket, 8);
    }

    public long cardinality() {
        double proportion = this.getDebiasedBitProportion();
        double estimate = -Math.pow(2.0, this.threshold) * Math.log1p(-proportion) * (double)this.numberOfBuckets;
        return Math.round(estimate);
    }

    public int estimatedSerializedSize() {
        return 25 + this.numberOfBuckets / 8 * 1;
    }

    private int findThreshold(HyperLogLog hll) {
        int[] values = new int[hll.getNumberOfBuckets()];
        hll.eachBucket((i, value) -> {
            values[i] = value;
        });
        double mean = 0.0;
        for (int val : values) {
            mean += (double)val / (double)hll.getNumberOfBuckets();
        }
        double sensitivity = (double)hll.getMaxBucketValue() / (double)hll.getNumberOfBuckets();
        double noise = this.randomizationStrategy.nextLaplace(sensitivity / this.epsilonThreshold);
        int result = (int)Math.round(mean + noise - 0.2);
        return Math.min(hll.getMaxBucketValue() - 1, Math.max(0, result));
    }

    @VisibleForTesting
    void flipBit(int bucket) {
        byte oneBit = (byte)(1 << PrivateLpcaSketch.bitmapBitShift(bucket));
        int n = PrivateLpcaSketch.bitmapByteIndex(bucket);
        this.bitmap[n] = (byte)(this.bitmap[n] ^ oneBit);
    }

    @VisibleForTesting
    byte[] getBitmap() {
        return this.bitmap;
    }

    private double getDebiasedBitProportion() {
        double effProbability = this.randomizationStrategy.effectiveProbability(this.getFlipProbability());
        return (this.getRawBitProportion() - effProbability) / (1.0 - 2.0 * effProbability);
    }

    private double getFlipProbability() {
        return 1.0 / (Math.exp(this.epsilonRandomizedResponse) + 1.0);
    }

    public int getNumberOfBuckets() {
        return this.numberOfBuckets;
    }

    @VisibleForTesting
    double getRawBitProportion() {
        double count = 0.0;
        for (byte b : this.bitmap) {
            count += (double)Integer.bitCount(b & 0xFF);
        }
        return count / (double)this.numberOfBuckets;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public Slice serialize() {
        int size = this.estimatedSerializedSize();
        DynamicSliceOutput output = new DynamicSliceOutput(size).appendByte((int)Format.PRIVATE_LPCA_V1.getTag()).appendInt(this.numberOfBuckets).appendInt(this.threshold).appendDouble(this.epsilonThreshold).appendDouble(this.epsilonRandomizedResponse).appendBytes(this.bitmap);
        return output.slice();
    }

    @VisibleForTesting
    void setBit(int bucket, boolean value) {
        byte oneBit = (byte)(1 << PrivateLpcaSketch.bitmapBitShift(bucket));
        if (value) {
            int n = PrivateLpcaSketch.bitmapByteIndex(bucket);
            this.bitmap[n] = (byte)(this.bitmap[n] | oneBit);
        } else {
            int n = PrivateLpcaSketch.bitmapByteIndex(bucket);
            this.bitmap[n] = (byte)(this.bitmap[n] & ~oneBit);
        }
    }

    public void update(HyperLogLog hllOther) {
        Preconditions.checkArgument((hllOther.getNumberOfBuckets() == this.numberOfBuckets ? 1 : 0) != 0, (String)"Cannot update sketch using HyperLogLog with different number of buckets: %s vs %s", (int)this.numberOfBuckets, (int)hllOther.getNumberOfBuckets());
        hllOther.eachBucket((i, value) -> {
            if (value > this.threshold) {
                this.setBit(i, true);
                this.applyRandomizedResponse(i);
            }
        });
    }

    private void writeBitmap(HyperLogLog hll) {
        this.bitmap = new byte[this.numberOfBuckets / 8];
        hll.eachBucket((i, value) -> this.setBit(i, value > this.threshold));
    }
}

