/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.GarbageCollectionNotificationInfo;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.airlift.units.Duration;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JmxGcMonitor
implements GcMonitor {
    private final Logger log = Logger.get(JmxGcMonitor.class);
    private final NotificationListener notificationListener = (notification, ignored) -> this.onNotification(notification);
    private final AtomicLong majorGcCount = new AtomicLong();
    private final AtomicLong majorGcTime = new AtomicLong();
    private final TimeStat majorGc = new TimeStat();
    private final TimeStat minorGc = new TimeStat();
    @GuardedBy(value="this")
    private long lastGcEndTime = System.currentTimeMillis();

    @PostConstruct
    public void start() {
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            ObjectName objectName = mbean.getObjectName();
            try {
                ManagementFactory.getPlatformMBeanServer().addNotificationListener(objectName, this.notificationListener, null, null);
            }
            catch (JMException e) {
                throw new RuntimeException("Unable to add GC listener", e);
            }
        }
    }

    @PreDestroy
    public void stop() {
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            ObjectName objectName = mbean.getObjectName();
            try {
                ManagementFactory.getPlatformMBeanServer().removeNotificationListener(objectName, this.notificationListener);
            }
            catch (JMException jMException) {}
        }
    }

    @Override
    public long getMajorGcCount() {
        return this.majorGcCount.get();
    }

    @Override
    public Duration getMajorGcTime() {
        return new Duration((double)this.majorGcTime.get(), TimeUnit.MILLISECONDS);
    }

    @Managed
    @Nested
    public TimeStat getMajorGc() {
        return this.majorGc;
    }

    @Managed
    @Nested
    public TimeStat getMinorGc() {
        return this.minorGc;
    }

    private synchronized void onNotification(Notification notification) {
        if ("com.sun.management.gc.notification".equals(notification.getType())) {
            GarbageCollectionNotificationInfo info = new GarbageCollectionNotificationInfo((CompositeData)notification.getUserData());
            if (info.isMajorGc()) {
                this.majorGcCount.incrementAndGet();
                this.majorGcTime.addAndGet(info.getDurationMs());
                this.majorGc.add(info.getDurationMs(), TimeUnit.MILLISECONDS);
                long applicationRuntime = Math.max(0L, info.getStartTime() - this.lastGcEndTime);
                this.lastGcEndTime = info.getEndTime();
                this.log.info("Major GC: application %sms, stopped %sms: %s -> %s", new Object[]{applicationRuntime, info.getDurationMs(), info.getBeforeGcTotal(), info.getAfterGcTotal()});
            } else if (info.isMinorGc()) {
                this.minorGc.add(info.getDurationMs(), TimeUnit.MILLISECONDS);
                this.log.debug("Minor GC: duration %sms: %s -> %s", new Object[]{info.getDurationMs(), info.getBeforeGcTotal(), info.getAfterGcTotal()});
            }
        }
    }
}

