/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.airlift.stats.cardinality;

// These tables are generated empirically by running several thousand experiments and computing the average error for each cardinality
// TODO: check in the code for generating the tables
final class BiasCorrection
{
    private BiasCorrection() {}

    // bias correction tables starting at p = 4
    public static final double[][] RAW_ESTIMATES = {
            {
                    11.238823092354272, 11.725363299909107, 12.222487291610099, 12.735431957728302, 13.270736917504793, 13.822501301508458, 14.391255094466214, 14.969524108237062,
                    15.56691362087194, 16.175198427092205, 16.7981527546064, 17.448134120729758, 18.097592087776068, 18.759433618300417, 19.450004708799035, 20.156932338684754,
                    20.875136059898335, 21.60835330066454, 22.351989350566974, 23.113857534769974, 23.90429312484887, 24.67713081912686, 25.49420317767964, 26.309863939212107,
                    27.126802013148428, 27.972605647700796, 28.820451945782686, 29.67281734661721, 30.53644672326387, 31.39668010644774, 32.27870983729891, 33.14771510141357,
                    34.05425420817575, 34.97509016051461, 35.8818490065124, 36.792441662708065, 37.70780466307142, 38.62317635261747, 39.55502952281605, 40.49619871344004,
                    41.44603403431558, 42.42092766507492, 43.3709558040624, 44.327316505552744, 45.29307979619073, 46.24997474501817, 47.201710877073786, 48.18726977279131,
                    49.14448219007698, 50.137421167014054, 51.104818781406934, 52.10820437202683, 53.10052633157516, 54.0725395290788, 55.03295380938293, 56.033147332017876,
                    57.00397278312336, 58.062370314420136, 59.0227246094072, 60.00043177933829, 61.006867272215594, 61.97490128147253, 63.01903209306433, 63.971348060146816,
                    64.91162631773415, 65.85294872512344, 66.84339832519024, 67.79984837197942, 68.75333942356372, 69.77448114087566, 70.76918920249851, 71.77758462099953,
                    72.81907388775971, 73.82988285948488, 74.80625898013463, 75.79911363341205, 76.71741012222735, 77.6987982563626, 78.63348046315684, 79.62908902169245,
            },
            {
                    22.77932649294573, 23.261115695867563, 23.751159067226258, 24.24915910631809, 24.75476648688801, 25.26732497026536, 25.786578222898626, 26.310905487923645,
                    26.839927196274342, 27.387865333182482, 27.94149546391533, 28.497249235818824, 29.059912306269123, 29.636802183334773, 30.22131848480806, 30.813233117380097,
                    31.406254563377363, 32.01114372186672, 32.61633519216477, 33.23200121019319, 33.8545001677627, 34.484029809476574, 35.124634639543416, 35.763358479018244,
                    36.42375698997327, 37.08614917999027, 37.768999116479655, 38.461184231325056, 39.14991724989846, 39.83535010437971, 40.53198877923012, 41.233663012500315,
                    41.95148310122916, 42.68221857875466, 43.403434589772075, 44.13934054539383, 44.88238280732905, 45.643917737439786, 46.394616846716765, 47.14524158486915,
                    47.904357522212386, 48.682141938915976, 49.4613425771598, 50.23246528465661, 51.00507853817475, 51.79679890970103, 52.59367935848412, 53.40124729599998,
                    54.21205142080146, 55.034610026416765, 55.86466243417469, 56.70015425059533, 57.54401311390876, 58.39385821257159, 59.22521021058371, 60.089290769757376,
                    60.95894725053715, 61.81542007186899, 62.666961224851526, 63.55349195818499, 64.42481374851235, 65.2840538099318, 66.15558862021457, 67.04972089567735,
                    67.93390957080265, 68.83079228437437, 69.7186239565501, 70.61074424926983, 71.51511208737145, 72.42924058054682, 73.3331481037979, 74.25178751536052,
                    75.15461273650473, 76.0794699409806, 77.00401813021591, 77.92067007066713, 78.82758185775968, 79.7585425145911, 80.6387463303789, 81.56851600227802, 82.51327204772852,
                    83.45797121387919, 84.41117650756297, 85.33285965326263, 86.2783412507562, 87.25064175559649, 88.1951944417447, 89.12771088513622, 90.10362358308917,
                    91.06182558116019, 92.002863892934, 92.94517201025293, 93.93458324321051, 94.87779889452023, 95.8536022538649, 96.83723858115665, 97.82095580229137, 98.82362070900676,
                    99.77944951035852, 100.77602256431138, 101.75167760375842, 102.71093796308753, 103.7028366449849, 104.67223583073061, 105.65029327904286, 106.63886770280547,
                    107.6237034396032, 108.58712460552255, 109.54762987179726, 110.53874105930242, 111.52920835619366, 112.55779104517525, 113.54361236488315, 114.51142338265662,
                    115.49447666964366, 116.46507922964537, 117.43881734646392, 118.42968165038685, 119.42983356803025, 120.4601306876298, 121.45059523184032, 122.41649774138901,
                    123.39336589514583, 124.4049044729134, 125.3842953165607, 126.32063285027671, 127.28967873110413, 128.28266606917657, 129.25532262489594, 130.23933874898773,
                    131.25819523494158, 132.24090748038762, 133.2297629541157, 134.22534951364486, 135.22035867773053, 136.1678562665769, 137.12796347528385, 138.1340270095745,
                    139.1189380526937, 140.0537398375486, 141.07634390152796, 142.073110720766, 143.040795363473, 143.98192941463194, 144.96284196892032, 145.90561111080373,
                    146.95345755896653, 147.93678120623173, 148.9334165695148, 149.97317687889736, 150.98329126343938, 152.0347759146844, 153.00198765200474, 153.98235642430805,
                    154.97860226311164, 155.9697402149397, 156.96609109521634, 157.96284964484528, 158.91621843372602, 159.91708349191092,
            },
            {
                    45.854533130412854, 47.31072242086501, 48.29929645296603, 49.80832079609545, 51.34888741647967, 53.45748177790311, 54.53342031818346, 55.62364530505762,
                    56.727805614623165, 58.98144360990141, 60.129787381154244, 61.293268346875685, 62.4709700350214, 64.2558361487712, 65.46421418969446, 67.29074416313107,
                    68.54355767689897, 70.4484221038948, 73.04105149253134, 73.70633117479629, 74.35497376545588, 75.01433813755582, 75.68724740562939, 76.37270066728811,
                    77.71796857261704, 79.07420144916753, 80.46115952175705, 82.57276076341451, 83.28898515261109, 84.70515072297304, 86.15237381333378, 87.61636104566209,
                    88.3600325345711, 89.82859541233302, 92.81272268755218, 94.31452129789375, 95.828760992489, 98.13160585081147, 98.92531949856895, 100.45711178024001,
                    102.03257131914106, 102.80234262759095, 105.15407838273727, 108.3655629752791, 109.15674736027415, 109.98589195510806, 112.39568935298358, 113.18575147060288,
                    114.03210278299062, 114.84116444407297, 115.66992694946393, 116.51167865680164, 117.33947404522743, 120.69267241138799, 121.50962008913476, 122.39226298256881,
                    124.94113081205148, 126.61150006264253, 127.49441369308887, 129.20157709573363, 130.0736343105852, 132.63769264486032, 133.47709162353496, 136.9962659564278,
                    140.48806609662918, 141.3863940441779, 143.1421855702465, 144.07336753364896, 144.980256109538, 146.77132820906183, 148.60038943868207, 149.48687678895365,
                    154.07471141192576, 155.01192277049543, 155.93069311527395, 156.86576895230874, 158.6925567655158, 159.62510014648623, 161.46779181331155, 163.36541856542576,
                    166.14411192248377, 167.11031113384806, 168.04975878592248, 168.95334510813785, 172.7224138950209, 174.59448376951818, 176.534466878692, 177.48563687422936,
                    178.4168373486183, 179.404453087958, 180.33714343007378, 181.29285656479732, 182.26413531364435, 184.1633825009286, 185.16536877967062, 189.05517521763838,
                    190.0647637904211, 191.97763714868236, 192.89671599080265, 194.80425704458005, 195.8051727860706, 197.68986510910162, 199.58861448928957, 200.59802676257644,
                    201.57194705405402, 204.452991143457, 206.39210296776724, 207.3985192699964, 209.331879540886, 210.315622249521, 211.26215728343084, 213.24765174223248,
                    215.1661627983063, 216.1738131044242, 218.10156102540725, 220.11524137527718, 221.0977093643887, 223.0284016977248, 223.97671016352066, 224.90491286823328,
                    225.91294490677927, 226.8522139881627, 227.8192445919417, 228.80497857170414, 229.77581769142353, 231.76122478346318, 232.72808375870122, 233.73269877506553,
                    234.68168723472496, 235.6775151290225, 236.70685583728832, 237.69208889988715, 240.6035756939352, 241.58696164500378, 242.53514941402875, 243.5136136866957,
                    245.5439336931616, 246.53264782794383, 247.4795684383069, 249.4218388868179, 250.3673552957724, 251.40832089717136, 252.3278484642049, 253.28522589571384,
                    254.26386350912614, 255.22664403458154, 256.28403711913927, 258.18688976302906, 259.24067272852307, 260.2462607367207, 262.21642614291045, 263.2405506324472,
                    265.21263550393434, 266.1483824353132, 267.1661088158451, 268.11092541090835, 270.1216470331842, 271.0705615945983, 272.0964411533475, 273.05618962855823,
                    274.03169645727434, 275.05406801670085, 276.0208348825076, 277.0115775293853, 277.969551652295, 278.9999638142669, 279.9799929658816, 280.98287126005556,
                    282.00456073135956, 282.98056535711294, 283.92235039303756, 284.91021860071606, 285.87048062164644, 286.84504410520015, 288.8595648237398, 289.81725855585887,
                    290.83361431690116, 291.80346949982095, 292.8365748309084, 293.79543488205104, 294.7995300177809, 295.75879331855447, 296.7647579184519, 297.82327398609283,
                    299.88319977442654, 301.8192945473352, 302.7516120171321, 303.7170521590099, 304.70328058450764, 305.7265573935557, 306.7015824476859, 307.7681334511439,
                    308.79405871690483, 309.7927984031691, 310.82086592021955, 311.81302301639863, 312.7534065395336, 314.7314765664714, 318.7116483648745, 319.74022867571614,
            },
            {
                    92.03509566514494, 95.44497621836193, 97.93301152406725, 101.49180819872358, 105.65088450234082, 108.85980426212826, 111.58262041691164, 114.89455607870187,
                    119.43589024787555, 122.9163500097106, 127.06844359764042, 133.15351467381302, 135.01434491448396, 140.03077953204075, 142.57666354443413, 147.1137322595245,
                    151.74047957549945, 157.10442156072784, 162.58661616787234, 166.11422992616212, 167.50059641687366, 174.57847260909153, 178.90812903222218, 181.14036108332618,
                    182.5874117423085, 186.29078057530805, 189.29180315613382, 190.06376255308078, 195.33339289317792, 199.93670232968688, 204.59875004573706, 211.69353304653652,
                    214.1198533744616, 216.49257080996975, 218.9291577595253, 222.13007153901384, 225.3744241940457, 232.74210823831666, 235.23609687001905, 237.69361835143724,
                    241.08227796296825, 246.94489397557123, 247.75746494849855, 253.71303781724143, 256.29223072991454, 257.1256563823788, 261.4104754480469, 264.89566266433127,
                    266.6066523441263, 267.4944657102422, 269.20548961801046, 272.6806568652068, 273.58775510581694, 278.0092433761338, 282.39035649809506, 285.93674833532117,
                    295.8717004999003, 296.80399910166705, 298.5856421631121, 299.44467791257523, 307.5764827262699, 311.265142372392, 312.1449164399839, 314.8918999386731,
                    319.5321947704583, 322.26784577559096, 323.2182290670821, 324.1084885976447, 325.0733490300525, 326.9011347180376, 334.43539804303094, 338.1219818790606,
                    339.09961258235774, 344.76990450335796, 349.40232414085364, 350.3649522738527, 351.27982886318995, 355.10091445982414, 356.9305444893733, 362.676501927006,
                    365.4642266327095, 366.4474671476038, 367.3811973912587, 373.1158185497122, 377.76318134159203, 379.691143475922, 380.6132140385909, 381.58525961273887,
                    384.4026011502023, 387.306800451803, 389.2880919170236, 393.1512923955702, 394.142794801798, 395.0831210884745, 397.07125280297316, 399.9890133687759,
                    402.9730157913189, 404.9022652657989, 406.787491691716, 411.6679919664327, 415.4654621194505, 418.3709129215508, 420.42887377878924, 422.4176233665061,
                    425.3331847363532, 426.36321246158343, 437.93628451839226, 439.91911509671985, 440.86735691778847, 442.8291946737918, 451.52643079284906, 454.3502543187279,
                    457.2401348625619, 459.09880791177426, 460.10765606172384, 462.0433915143628, 464.02746424732607, 464.97894580697556, 465.98728235286296, 466.9457042355389,
                    467.9716493224284, 469.952895126153, 470.90205041356137, 471.8978141263659, 472.850818800059, 477.8969098904873, 479.7860743487078, 483.7512013081145,
                    484.7784990127453, 488.7330076075651, 489.67603349280984, 491.63572616272523, 493.72339144570026, 495.67534091041233, 499.7271092833366, 503.6412797374585,
                    505.5002945337613, 506.50992558916954, 508.4526985990731, 509.48313241565353, 511.41278098184745, 512.4546865922741, 513.3888394758542, 514.4288551293096,
                    518.3016895767877, 519.3395550920872, 522.2366044843038, 523.2519954165105, 525.1552988364048, 528.1428483253017, 530.1812920462645, 531.1493210844883,
                    534.1320123491877, 537.1801316512037, 538.1518025075683, 540.1830626803153, 543.124710980792, 548.0945584787735, 550.1464423508572, 552.1387813848073,
                    553.1906718144394, 555.1053998600016, 556.0131373229553, 558.9257829854911, 561.9134152379364, 562.8560972469294, 565.7911652042748, 568.8317823911899,
                    569.8150593887624, 570.8505248140114, 571.829369147002, 577.8982662683503, 578.8806962929154, 579.9137998702437, 583.9135058785267, 584.8446491655831,
                    586.8235811012087, 589.8878837974004, 590.8513701890881, 594.8798420329019, 595.8248678596194, 597.7965508706933, 599.8575486844194, 603.7405554194753,
                    606.7405042295918, 608.6761993025847, 610.713326324779, 612.6976510769083, 613.7664643765897, 614.677083249776, 620.7255511251976, 626.7135644233679,
                    628.6482693710398, 629.6570105099962, 631.7400311199661, 632.7118891638025, 635.7923587859781, 636.7709992391547, 637.8175487128655, 639.845112431125,
            },
            {
                    184.3579859401234, 192.15443283236525, 196.64802549992893, 201.73378884943716, 209.52358084097227, 216.97691752635689, 224.0657993482173, 231.2862994438282,
                    238.6625730493835, 242.12408374656806, 249.15561782714988, 256.86471818361053, 263.5319594189586, 269.69586545849444, 275.31692514546455, 280.37778290772025,
                    291.9478638244543, 300.513497637161, 311.19794713029614, 316.63338160003235, 326.2836213329782, 333.96927781514285, 343.90841349102305, 355.4321905415327,
                    361.252430896053, 376.8323797468785, 387.39565954837866, 388.95387120776206, 394.25069503908753, 406.5751476081739, 412.0255709668396, 423.0368620509097,
                    427.85241248994515, 436.56670992765095, 448.6292975576179, 462.4971762699291, 465.0181329297163, 473.23028532363463, 494.21821330177335, 500.2434993554995,
                    513.0014139242118, 522.496114486894, 523.3168928943005, 531.9670562412849, 532.8711506150325, 544.1597408165791, 549.5100029267074, 552.1042259223233,
                    563.6853804561397, 573.3721908171308, 585.9698197341706, 588.5887838237893, 593.0741324403267, 606.7892991240519, 608.5480547483602, 624.0489334691753,
                    636.0119530229101, 638.7069486891311, 647.0702912092839, 653.45853792942, 658.1066220021323, 660.9695512159882, 670.2482611345346, 672.0439958533756,
                    688.8620623207361, 689.837601476221, 694.467443510656, 698.3050483874695, 709.5286091001703, 711.4958669465436, 712.4011920599339, 713.3956516374291,
                    715.2578337301354, 721.94146846189, 741.8317347736604, 743.677216267255, 757.0396508112627, 761.6854715358696, 763.643985916227, 770.2833878742357, 771.1795755249319,
                    777.925639149453, 783.6420677560948, 787.5911979357787, 789.4782206160799, 791.4862054664015, 803.9390536356827, 813.6647304995123, 823.192909529516,
                    828.1613375497931, 829.0784558301758, 831.1108351357013, 833.9435567609042, 842.7825840977509, 851.4847821767731, 855.4492099065142, 861.1528386263293,
                    863.1477431250398, 868.9580084279557, 874.6575284645011, 882.5505042589203, 883.4520422270363, 886.4264765324858, 887.3390667109261, 891.3824519702691,
                    899.1866593259443, 905.8205127765627, 911.8339813322575, 921.7265292754852, 926.5688610573277, 932.5099164592001, 935.6170179874478, 941.4892642985235,
                    943.5076114706833, 946.3928437680761, 950.4036796364679, 952.3284855397286, 956.3867546637368, 960.162538945685, 962.2535585402532, 966.1194868652601,
                    971.1132262837799, 975.0123521444228, 975.9241245963434, 978.8364299502302, 982.8490322233816, 991.6844199868463, 995.7058814734006, 997.626983124524,
                    1001.7054416129671, 1007.6703305966038, 1010.5779494726818, 1018.6353254890861, 1019.5704413811535, 1027.6061631316975, 1031.50270141741, 1040.5587129300611,
                    1042.4956826155196, 1043.5398720559738, 1052.4157045189665, 1056.2006012480815, 1073.035130227522, 1077.1008964464959, 1082.0138853699345, 1085.093949128817,
                    1089.9631741079747, 1096.965754582916, 1099.886063523516, 1104.9144828217911, 1105.848979511025, 1107.8634448066625, 1110.7459978156887, 1111.7669136568938,
                    1121.4995513078188, 1124.554675004647, 1127.5203486727237, 1130.3681660562618, 1137.3411610436212, 1143.1601815334398, 1147.1715966924762, 1148.1052085805802,
                    1154.069027187493, 1159.127039195876, 1165.93250135203, 1170.0025626733925, 1173.9247902934667, 1174.974155518286, 1181.9556455070372, 1184.0097986698054,
                    1184.9625590230953, 1194.0877760519652, 1195.0336743851974, 1197.0938050828192, 1206.0613724898317, 1207.1367604041764, 1212.0612351981104, 1213.1379974106208,
                    1216.048195019326, 1221.1112797216022, 1223.005557645146, 1227.0391903379211, 1227.9854774610744, 1235.9642503261903, 1238.0326284684475, 1251.8117078014764,
                    1252.8603727887098, 1261.7356816439792, 1263.6430445292704, 1265.64932015684, 1267.7456479627224, 1273.8219604039284, 1275.7683805978327, 1277.8750726888861,
                    1283.8893465472297, 1284.9620788769657, 1287.8214884938702, 1290.7770876742688, 1293.852039971248, 1297.6156557963761, 1300.5406066066353,
            },
            {
                    369.0069786460945, 380.1669746478074, 387.57806250005774, 396.090322539455, 404.7421424771744, 414.5521582364457, 428.78572659222965, 437.9224700071899,
                    451.03092190250413, 465.5372251526111, 476.90434126302773, 490.8138580868185, 510.3126805745858, 524.1926000432966, 536.4847337664372, 549.5681955159181,
                    567.880654546859, 582.0336325140005, 595.7299149650378, 613.6524954733262, 629.2013158625574, 644.9343600042034, 660.18057152058, 674.9651807312857, 699.9294951568326,
                    715.7982027109316, 737.8552498132973, 764.6871604135629, 790.3957581755715, 820.5169765065407, 836.2322267546139, 848.1938887438894, 872.7278564863554,
                    883.2755167336167, 904.9579657864062, 921.2776622283246, 955.1143095638191, 991.8756977088178, 1005.4404837478854, 1009.7664820288746, 1021.5606556407852,
                    1026.7777789420866, 1033.5718422927264, 1064.6350860854716, 1073.4727527645973, 1095.2433258604299, 1112.8263180491886, 1134.1908642693772, 1140.3319576949648,
                    1153.7439480057878, 1158.3195510737555, 1183.3092702379063, 1187.006937710601, 1195.0172151396107, 1203.2155063555444, 1227.5162963323864, 1234.9003735914184,
                    1243.9155022424313, 1256.7847712474688, 1277.705166371933, 1283.2994186405633, 1295.1441159420144, 1312.6138882967186, 1321.0476259593484, 1330.183890478004,
                    1335.8394051820978, 1341.3431423279164, 1352.5360141688313, 1363.580035992931, 1382.246712834379, 1396.4206982150802, 1412.2396579714825, 1415.1451048150943,
                    1425.440645183607, 1431.2125299031713, 1436.780878815219, 1440.6628123398261, 1447.2249989351576, 1453.963088765123, 1467.0749017123774, 1477.65946246654,
                    1482.3147948077863, 1499.4596182178927, 1505.0464164982868, 1519.5241654035487, 1528.0490747390836, 1529.0813851739194, 1541.4743098082406, 1548.2819017055058,
                    1559.6528304991684, 1569.3130992201063, 1577.7981363254587, 1586.4657533025868, 1600.1243761694066, 1602.9357583750525, 1611.6811691861765, 1616.403132208867,
                    1633.7138499820037, 1654.2933052103538, 1658.0538642300667, 1672.5588300119155, 1677.520528027786, 1695.864501950808, 1705.719152104358, 1718.257189001944,
                    1726.2418712545018, 1731.0005145786267, 1741.879884638363, 1755.3228688502384, 1758.3578508280748, 1774.9309605683004, 1795.6397226414226, 1809.1641624705485,
                    1813.1648323228246, 1815.0590896867811, 1818.1227679942472, 1833.6869139998364, 1837.6652029820843, 1840.5263759815034, 1842.5832833783088, 1851.4636710914292,
                    1868.9118285386505, 1880.8872911783294, 1883.7862412211332, 1885.8406992000027, 1889.6825177845078, 1904.6285077739772, 1920.2560459005317, 1926.9913731247534,
                    1948.562812734647, 1954.307623327181, 1981.8975214782256, 1991.545832251982, 2000.362985621308, 2002.4398099369382, 2012.2669116821014, 2023.254072730304,
                    2027.1023184782662, 2047.049585587554, 2064.632905884122, 2083.37941783785, 2103.910516409591, 2108.947450183494, 2114.7948201725, 2116.882257086098,
                    2132.6759076404387, 2133.7788437041486, 2146.827394702432, 2148.9532398627566, 2155.913788776539, 2164.121974353269, 2174.1741486998276, 2180.990996193192,
                    2191.0486980344676, 2207.732620769437, 2220.7287938109625, 2222.595647718888, 2243.5942968864024, 2245.4907471345578, 2251.5507413918635, 2260.3277993395814,
                    2264.4098951652277, 2281.323154478904, 2283.202168840815, 2289.1405504545437, 2296.286625121649, 2299.165926100625, 2308.147571548645, 2311.043821473149,
                    2315.139001819763, 2323.9171730894595, 2334.0371862174784, 2345.8886641391045, 2348.7452822347345, 2361.7786973213097, 2372.667557396289, 2376.7382689753213,
                    2385.5906053064596, 2388.694131501548, 2392.597622128922, 2404.5964271917373, 2414.8096864687955, 2427.754246271575, 2442.400427286218, 2447.539821764057,
                    2451.4840541632125, 2457.5958721049724, 2462.502914424055, 2470.6816280568123, 2472.5832652497766, 2480.6937510834537, 2502.7510782651643, 2504.65513901555,
                    2535.859495931439, 2545.6955551727424, 2560.6578010407443, 2565.4960747318532, 2569.581872221322, 2581.4001947342213, 2600.677552837471,
            },
            {
                    738.3121672049899, 750.8709568608225, 768.0452620387489, 795.0624676324497, 812.9422477277452, 833.6908233403522, 856.4153505085907, 874.6715977902304,
                    895.9590156860164, 924.861548665045, 953.2498284074398, 978.6862080836326, 998.6448834859378, 1018.2629429828837, 1039.315751473298, 1061.2609987443702,
                    1077.2858655499413, 1112.3045136314513, 1136.4878338605367, 1160.9231205160602, 1180.4449371721794, 1200.1869279293437, 1226.1031345422393, 1259.1547935432402,
                    1298.8381082978158, 1339.2426495213333, 1368.1627887110842, 1396.6859191745298, 1436.4984666882747, 1469.5673646160521, 1489.6064066652236, 1539.9511489220813,
                    1599.319535629224, 1648.123772067616, 1694.5368410324836, 1727.847265075143, 1798.6864223061464, 1849.324205242884, 1895.5442982331697, 1920.5743601362365,
                    1944.9800124400274, 1971.6317994280055, 1996.8545256071673, 2065.7541617757843, 2117.375196928537, 2178.981143900484, 2189.587925179454, 2211.358272775329,
                    2273.0218213049993, 2323.8577864607855, 2377.7303647137232, 2427.5089433265507, 2507.8880771212816, 2534.1848148082922, 2561.634389541705, 2587.6543795850203,
                    2593.098501723725, 2606.1745726344484, 2619.014021276789, 2646.0633121789538, 2669.0728410564707, 2717.5644088298163, 2732.2823681909877, 2749.2374760965713,
                    2755.658310464027, 2789.3565256944435, 2830.2217728057853, 2833.879091133576, 2852.0187681053735, 2872.5840883047963, 2945.5171858387876, 2952.0204204543047,
                    2965.3525489960825, 2997.2752977230657, 3015.6085966349447, 3079.3363996667963, 3081.354773602133, 3086.016066055672, 3116.0211052657646, 3123.5203690147337,
                    3136.1583196422857, 3162.0177744436614, 3171.792501011691, 3182.2081596146095, 3233.4083177642474, 3253.020749219256, 3256.7463635794866, 3277.992148041131,
                    3336.3933679459547, 3350.8288151947954, 3356.4384473575274, 3361.396222767123, 3374.8311106593965, 3408.885709283062, 3476.642739802436, 3521.1769962462067,
                    3543.7328870902465, 3547.5220610191723, 3550.583129911124, 3586.516754172186, 3624.9564886365297, 3630.6752259466557, 3634.716616189889, 3645.3693430321055,
                    3664.2379206169603, 3733.461005053302, 3782.791043041641, 3798.340773422409, 3803.3684719309326, 3827.574107404053, 3840.570589172893, 3844.3444685494787,
                    3854.383523354582, 3876.816476483121, 3885.7800377608037, 3889.5946184556574, 3897.59438232769, 3911.132298583358, 3987.9943148984935, 3995.709810101547,
                    4001.785941329434, 4008.590025487513, 4014.63162496964, 4031.1838155120613, 4049.1579743091534, 4056.9594313778207, 4064.0195163175663, 4079.71199766146,
                    4084.7741521873086, 4091.5307228704946, 4107.606931233608, 4121.452271701284, 4131.150455676433, 4143.3663998067, 4166.003224139183, 4188.075729177734,
                    4196.8219022214125, 4221.934293434066, 4223.779014261575, 4246.425877223805, 4264.078919282584, 4300.113021045544, 4328.532077584275, 4356.418891007588,
                    4359.271886254437, 4386.237693663916, 4406.021577662483, 4413.138029513586, 4423.90772170406, 4431.980375895137, 4433.8594049057865, 4451.935263866126,
                    4489.5043722291675, 4515.863004637008, 4527.783396989829, 4534.520512200982, 4558.293391878358, 4565.413995978089, 4581.111968004318, 4590.172303259496,
                    4602.922892869976, 4627.924895507071, 4645.1659759607855, 4650.029700293791, 4666.090980619031, 4670.884854106726, 4705.942109217537, 4707.802909848261,
                    4730.580384235971, 4742.283161560952, 4750.333837500232, 4757.09829513052, 4773.012494683431, 4844.0459901656395, 4852.915667241751, 4872.308689747196,
                    4902.1550952864045, 4904.9816472566845, 4914.224503684604, 4932.967572984758, 4937.121278691746, 4976.629372928708, 5027.0969805555715, 5034.880685557757,
                    5063.841009157964, 5075.578463604391, 5079.723412969765, 5091.592850856239, 5097.347056005392, 5103.457925856681, 5106.312318845121, 5121.301677272891,
                    5140.8764873703385, 5151.99053442684, 5162.869153498311, 5165.0032979670605, 5172.851710764541, 5184.133666672314, 5191.054656606777, 5203.29159407058,
            },
            {
                    1476.924446188915, 1498.1796341799545, 1523.5979169673353, 1546.8278104449653, 1572.8018862369254, 1620.0525427843104, 1653.6537005742682, 1695.1561482576576,
                    1729.2713809472139, 1783.487335717438, 1822.1083517886716, 1846.6931843845132, 1902.1467438338536, 1924.5274554507023, 1974.4408080177734, 2004.413100831765,
                    2034.7066301354998, 2076.1353175191075, 2108.301165310745, 2146.973304338528, 2199.834496313234, 2245.2752458955542, 2276.540631142832, 2321.5530709575546,
                    2379.509900764931, 2406.5211131833607, 2471.8432307909848, 2513.648217047119, 2566.946602138324, 2634.716516215193, 2690.0007429225493, 2751.5546513783365,
                    2811.0255446823844, 2875.471947586095, 2925.253470059913, 3002.3511311103725, 3047.2582764187678, 3113.786454970172, 3188.505104359521, 3239.355267203595,
                    3327.907850430572, 3406.772137623815, 3477.519225641772, 3544.9687122422774, 3635.7739009580832, 3726.678369939559, 3786.2015661678497, 3878.77778520415,
                    4013.296546937156, 4115.6136242289185, 4151.862537898837, 4174.04144950305, 4280.251565067811, 4344.542395750094, 4409.275277667036, 4476.941109104329,
                    4526.269374662147, 4616.626406148709, 4727.324622478976, 4842.661570306329, 4873.604569315125, 4910.551011408715, 4976.073984125033, 5052.930448014204,
                    5124.557140164952, 5311.093643909351, 5416.288495649787, 5434.222013856799, 5476.886420023292, 5512.685043752059, 5598.538773614692, 5705.828854886829,
                    5738.056815564466, 5769.789562270955, 5801.004079799245, 5816.755630188153, 5967.833648913663, 6009.991918988551, 6026.006103178877, 6069.842253348887,
                    6097.328133351067, 6132.884778878381, 6145.96489782143, 6188.795812260001, 6237.781683864925, 6254.83161831134, 6308.679015832518, 6321.904704266095,
                    6380.772315596307, 6466.436864560426, 6504.367918781012, 6520.584657486119, 6562.392316198156, 6679.921383702226, 6870.7562382170745, 6875.392650554656,
                    6915.947213309693, 7013.882451750406, 7031.109593918486, 7102.273712444959, 7113.774713874882, 7187.407063566685, 7224.3664951665905, 7312.266500336023,
                    7332.458133276452, 7388.009246458315, 7457.154810007796, 7485.318000739496, 7502.246179572434, 7538.36498667715, 7603.497573920852, 7618.93625858085,
                    7725.549618406889, 7753.806719498825, 7770.880576833499, 7809.283430588657, 7818.403356773285, 7849.956949544676, 7883.092460845031, 7905.062852045179,
                    7977.845869262026, 8034.686314818803, 8057.160946526386, 8142.587573558249, 8175.927172455497, 8205.903067968782, 8250.191461451577, 8258.362649182844,
                    8330.55069067596, 8340.699040307587, 8360.254933864591, 8364.410369696128, 8407.723234482644, 8446.623904045442, 8451.353812164381, 8493.86965857335,
                    8501.013265726697, 8595.800102137451, 8639.766984246415, 8647.427751408677, 8714.347235334004, 8758.994322173172, 8775.434681822533, 8872.850098320052,
                    8929.087624005053, 8936.191739896181, 8951.819083959355, 9044.522722200594, 9101.88188308152, 9105.066601450964, 9209.5192033409, 9255.536520311854, 9262.296320773094,
                    9282.467877564624, 9302.159686444771, 9313.562422100085, 9340.621171023073, 9400.114629575606, 9407.248490339005, 9427.64986943322, 9471.411712245996,
                    9539.628213992784, 9552.35290235594, 9566.42633304041, 9574.147787713535, 9607.00368988963, 9618.234840659052, 9670.62184200939, 9689.869856697129, 9694.582412227675,
                    9723.770481905709, 9729.554096709538, 9783.489892882575, 9812.978195347774, 9838.874183765505, 9857.438568846936, 10008.830868033156, 10012.595764003565,
                    10020.7467364098, 10063.34313472884, 10071.542757800704, 10085.317076488267, 10117.501495316152, 10130.18949827186, 10168.513547034847, 10176.307774461973,
                    10214.347637072777, 10221.030928865768, 10234.197389139865, 10254.989483396508, 10277.284585343552, 10330.304279837901, 10339.610760605663, 10368.322434230016,
                    10385.418833996424, 10401.839409146887, 10427.020354391034, 10452.604269335548, 10461.79987607386, 10501.611710079445,
            },
            {
                    2954.1464563382638, 2997.170296357156, 3047.5030376560485, 3084.002707389513, 3138.34388453738, 3178.6368953644746, 3239.7899948364206, 3279.9749325394596,
                    3326.244864676897, 3400.5003985815233, 3460.809262527319, 3514.2681512750437, 3573.154415153337, 3638.8576397919296, 3704.753022826492, 3764.046003869108,
                    3813.0486875994316, 3873.9738555386202, 3912.8887584442887, 3984.3633164810444, 4063.155958293407, 4162.8566976187685, 4271.488814212619, 4380.652717278149,
                    4442.214543646379, 4496.0135991347115, 4566.860679211462, 4691.618585344003, 4751.688445009344, 4842.724787110381, 4942.941217670757, 5029.945843807851,
                    5112.384478703784, 5172.791166552444, 5275.933941059574, 5356.242125095975, 5445.1671064493885, 5547.695546031384, 5628.84051110048, 5728.05053868821,
                    5826.741912626391, 5887.823026751878, 5992.550690813526, 6068.072564038706, 6162.998056660449, 6296.682756694981, 6441.597926823603, 6508.172800072052,
                    6669.664029289952, 6755.3261904492065, 6857.458004951967, 6981.151248248127, 7097.815609712603, 7250.593238529809, 7392.127595361595, 7447.238355670063,
                    7543.3040060546045, 7714.772981671303, 7923.699371849615, 8067.4585116834605, 8243.16272781733, 8465.054650147338, 8568.373633856669, 8737.614820177934,
                    8866.592417344822, 9040.361326389107, 9135.634966563204, 9205.506639161531, 9354.552521525968, 9469.564888315503, 9555.388898484578, 9675.314244814734,
                    9777.895202425369, 9885.310512980257, 10123.906679467858, 10330.277223904553, 10544.197980294111, 10744.317764468758, 10832.735305843682, 11021.535724969277,
                    11287.562939601361, 11366.789963744865, 11397.717916122889, 11739.981067727878, 11795.333490073657, 11869.086940929812, 12224.841735036598, 12310.294731844986,
                    12433.375342268411, 12474.292787227903, 12513.944689050357, 12562.508802032882, 12643.377567282938, 12686.257192442292, 12721.141235818852, 12746.670395681373,
                    12978.808412699056, 12997.382068904411, 13035.711611542618, 13140.320783064122, 13235.517197271934, 13399.475060890405, 13500.781681609229, 13512.64746969481,
                    13831.712411501323, 13964.806730678463, 14005.427048723068, 14115.211607375515, 14199.903015733677, 14266.652093413428, 14387.496160453245, 14423.157965706672,
                    14501.975742202685, 14589.386634091445, 14606.72166954049, 14726.877734812051, 14813.034294696969, 14887.947223079229, 14947.594092138454, 14980.361796243482,
                    15307.813050982253, 15538.480347410006, 15566.461527028883, 15617.478343979794, 15663.422559359344, 15830.530213236747, 15871.302970028135, 15920.283978718648,
                    16053.953068028428, 16060.109076297473, 16325.422786520026, 16361.462445725569, 16492.553247814605, 16638.362821940187, 16694.29654469703, 16718.786229442976,
                    16752.922789445936, 16913.45131822025, 17073.99130370704, 17144.12250330759, 17215.365485398903, 17291.396871207682, 17332.67103664024, 17466.1109244456,
                    17485.706190341203, 17560.763831382093, 17606.196567959032, 17661.436370180276, 17736.06274126823, 17781.45291878873, 17829.402533211163, 17892.558431499805,
                    17920.726739415382, 17929.364206844206, 18060.598673223893, 18083.025061770008, 18139.832428820886, 18182.159711717206, 18235.199460362972, 18287.552606593086,
                    18356.495849785962, 18386.003419628196, 18464.07481405007, 18485.717804629145, 18511.919897021788, 18554.268296081307, 18745.702658300845, 18781.145726328203,
                    18829.27089578382, 18980.470472769517, 19058.636074396676, 19201.16465742659, 19237.363609544813, 19293.760601293496, 19310.045045317882, 19481.219213652395,
                    19549.067678941992, 19586.160886348338, 19654.144127600826, 19684.25985909379, 19709.716496631656, 19784.828345766247, 19828.367203085923, 19956.295032628102,
                    20010.98020726903, 20028.262951695084, 20204.971230835188, 20253.418522795586, 20305.60788189338, 20409.349300542002, 20496.265782118706, 20535.641196965396,
                    20585.893439708896, 20675.527811022446, 20700.778643692007, 20728.42741934836, 20830.78898710803, 20889.60335970332, 20968.951931246447, 21008.074277544645,
            },
            {
                    5908.59037259784, 6019.901289523198, 6148.5801092591855, 6259.597147438802, 6401.460261712385, 6495.598301776293, 6568.884293533163, 6666.278961879988,
                    6744.534833095583, 6816.515829215206, 6921.729444799358, 6980.923187501, 7069.359632911879, 7208.494314772083, 7301.552526219073, 7433.114185018561, 7599.850732631423,
                    7719.89094962892, 7880.19249105427, 8007.172261859096, 8075.914826495482, 8235.43198464755, 8377.638818449961, 8488.170852949312, 8588.989096963667, 8695.032378130194,
                    8826.239995868633, 8927.730760635912, 9084.778530099422, 9277.59044265233, 9391.80168231086, 9537.036258152417, 9741.577532015774, 9927.091224068123,
                    10084.020810349391, 10257.976970288873, 10345.146982398672, 10530.061126173889, 10653.651402759147, 10835.91892110067, 10990.571910422177, 11110.54653101062,
                    11271.343973629535, 11441.02143719832, 11658.240118124773, 11907.783465161025, 12049.214618801518, 12261.308982004046, 12428.450057062642, 12591.16589717483,
                    12745.669835390005, 12898.27068858608, 13067.99997500351, 13267.616115323246, 13448.066799286717, 13632.04400192896, 13803.599500220618, 14060.509511707998,
                    14282.037429545251, 14445.105504274838, 14727.535906772071, 15065.718391793393, 15301.30226268141, 15462.310062241979, 15889.970151095498, 16087.378214329095,
                    16354.912672034006, 16586.075089726073, 16748.719292822258, 17116.725679190713, 17398.180206007823, 17622.83368123115, 17915.310612311896, 18124.78989034852,
                    18478.365872098464, 18686.39467076671, 18919.374167920923, 19143.728494715226, 19200.009025233103, 19644.645785970046, 20074.328247628582, 20378.206928445088,
                    20743.522644574154, 21198.004591356348, 21242.00817486205, 21426.25502500753, 21667.272151756748, 22058.323138287244, 22115.71353092448, 22297.409263294103,
                    22548.694442926266, 22861.1443558341, 23248.01485493211, 23553.305445219346, 23819.757377434315, 24226.244753341656, 24515.433999725345, 24885.875745174097,
                    24973.46835655312, 25381.900404589378, 25588.739691491806, 25678.711548179417, 25729.1116240537, 25804.650006005242, 25912.156929503897, 26050.34578599577,
                    26287.93157176747, 26387.143463641012, 26453.505676956192, 26939.46152960968, 27028.270481680316, 27316.021412339585, 27347.601211282647, 27630.879728915188,
                    28002.150642323373, 28181.756937479182, 28327.383147924767, 28497.546000816084, 28694.23576729056, 29161.022870229965, 29348.395979549303, 29702.69103114622,
                    29818.841708815187, 29941.210700447165, 29965.407188077148, 30248.182859493125, 30653.36529594024, 30807.255592353897, 30870.578318898024, 31051.657439803505,
                    31184.253544716303, 31734.914842800677, 31815.2497357844, 31972.371043585692, 32008.466202896245, 32183.85823452268, 32301.746718424758, 32355.460794891544,
                    32558.079516419606, 32652.492707533576, 32710.392787660683, 32999.33986704946, 33032.586402050736, 33277.68140336112, 33305.824369330614, 33573.74693349188,
                    33817.14460961934, 33863.38026556199, 34014.93184650621, 34142.25345854573, 34257.82231528342, 34471.74397148778, 34619.29237775281, 34696.3533555786,
                    34978.35787219777, 35147.645705015864, 35189.885671230346, 35248.86663235365, 35423.92670346899, 35611.231338911566, 35642.602646917585, 35796.60367187511,
                    36207.20817570764, 36291.657483091265, 36323.05484388122, 36400.16857425642, 36642.17224643523, 36652.48001529269, 37000.59281167143, 37452.803750730265,
                    37589.27269888348, 37719.50056087664, 37885.04885383869, 38153.96707060569, 38374.37355212518, 38506.026579471625, 38557.25901637052, 38847.80072468681,
                    38899.82583915901, 39096.631007015945, 39190.37843588755, 39289.54191563119, 39434.644869254524, 39525.3749844504, 39695.61107690911, 39741.98033953684,
                    39916.68948038638, 39961.166799407, 40471.59928849396, 40596.153694295455, 40689.14167424357, 40945.26204340346, 41144.54487142977, 41204.08393118228,
                    41234.612296106374, 41269.183253739866, 41565.23191335165, 41663.463643446186, 41733.45429816502, 42011.07895808608,
            },
            {
                    11817.48284814069, 12025.030152959966, 12248.464195296252, 12405.01818427126, 12617.778358464597, 12847.438540703668, 13007.265038320045, 13235.073605058598,
                    13405.0579491439, 13663.553132655054, 13853.986296820434, 14092.167685994842, 14316.680466515418, 14538.619141937597, 14685.019452482671, 14930.993807382209,
                    15107.906198997342, 15266.122881636436, 15512.492951696953, 15795.566797500669, 15951.1720654472, 16095.899273870584, 16321.465032255444, 16607.815822100183,
                    16801.463180656727, 16992.851950260214, 17297.447163103196, 17509.257909147327, 17816.456537123406, 18042.777641744804, 18163.262466408913, 18517.3435549237,
                    18656.573047168997, 18903.57415031232, 19159.063881387796, 19301.084603672418, 19499.226683644727, 19851.737489572584, 20186.20199316548, 20329.79570413158,
                    20573.494383877598, 20809.03649523294, 21000.9292932581, 21248.87214778442, 21655.87886127781, 21981.282573777742, 22374.74539610225, 22585.99825438857,
                    22965.094229314134, 23276.898428752178, 23585.295459186844, 24032.233494191812, 24274.28256622153, 24673.854146868754, 25088.080246181093, 25337.77906428822,
                    25539.50873836242, 25897.8036273155, 26149.575348286624, 26513.59516189047, 26736.999651484835, 27286.716708715434, 27774.918948749575, 28043.02192718279,
                    28497.97818804517, 28930.615790815693, 29200.57022600932, 29690.509486080784, 29988.056297845756, 30645.991905586507, 30956.22246920247, 31289.775764778133,
                    31853.030105629456, 32271.36518453615, 32468.709057878063, 32977.72567643425, 33414.11888603862, 33808.27381333534, 34491.79693257003, 34845.74081192588,
                    35250.83830143174, 35516.921246488644, 35924.268480323604, 36347.164696462045, 36751.299562693486, 37206.531027200544, 37681.97395311277, 37986.59665367647,
                    38603.64723512325, 39267.56997034544, 39766.35419539569, 40527.8087854173, 41392.330207790656, 41592.92201033885, 41995.92453925431, 42693.315471461196,
                    43096.8897773028, 44019.16655363803, 44280.74832842459, 44444.70012666934, 45312.54980893415, 45668.9683099376, 46388.39412925136, 47852.35671903567,
                    48467.710122297285, 49648.733946069115, 50254.84010255284, 50836.71911226846, 51012.14372539943, 52302.73320661809, 52436.744044789244, 52816.77539587083,
                    53019.52898984149, 53117.36670282434, 53571.557319694024, 54198.008560948474, 54414.065926819516, 54608.66450125954, 55615.64930325156, 55920.93685839912,
                    56016.66214267581, 57578.93540077729, 57626.48398308241, 57784.23044622798, 58071.82492909185, 58314.960914047944, 58890.70676439089, 58962.52052038851,
                    59540.03831282236, 59745.033985631075, 60555.68226396474, 60783.35250874083, 60871.007684026874, 62144.40878205181, 62374.66449999, 63964.79392626599,
                    64544.72520432804, 65405.94160988867, 65609.38341029624, 65855.34324611587, 66347.12847265646, 66438.28362352039, 66541.81045314795, 66827.0338341525,
                    67191.34725376232, 67975.66207241916, 68138.16033626764, 68191.3896865123, 68801.20624550495, 69120.67046147799, 69166.18743358155, 69700.7730015856,
                    70124.27048156314, 70308.16410238993, 70537.69539100963, 70782.83755356305, 70888.57881951089, 72004.40138912469, 72389.70910055735, 72745.81512322256,
                    73107.6979157422, 73383.12241293085, 73511.26718852727, 73804.4157033782, 74208.63609802125, 74396.66300781416, 74624.80579761098, 75014.35929611747,
                    75660.38284719188, 76050.14791912262, 76346.26464865675, 76459.62688375934, 76898.95858165064, 76962.54562456123, 77101.11100936931, 77283.4448464156,
                    77398.37363132581, 77651.39533049139, 77995.03476855856, 78282.26115372841, 78389.93225444441, 78493.36065919467, 78756.67315839021, 79147.05195488808,
                    79913.64068416048, 80199.60853142221, 80407.14576880759, 80928.45933381062, 81140.92495826371, 81557.77030919166, 82074.87361430205, 82504.03981365131,
                    82740.33776350027, 83123.46518537514, 83211.8208441617, 83400.26917127652, 83439.77357849317, 83471.01660312648, 83652.03382005985, 84025.10834292526,
            },
            {
                    23635.26250432443, 23794.30602789379, 24064.553615582015, 24338.874224687228, 24729.936018665605, 25002.147594322778, 25366.773977533063, 25625.019386813325,
                    25849.2088781992, 26099.033387656782, 26329.71202427824, 26661.656582902724, 26944.65570467436, 27270.612021644745, 27628.77114870539, 27916.56360543604,
                    28215.635684759884, 28628.085034890395, 28853.29367269045, 29191.854806354302, 29520.18481438468, 29780.368754225954, 30228.908137565988, 30688.584076924686,
                    31016.762623592538, 31390.327245706572, 31782.14355523691, 32049.73877380041, 32436.011288994898, 32662.201797771224, 33116.413890907694, 33441.42588576025,
                    33808.186418903104, 34233.867116267924, 34565.75413627513, 34862.18635669768, 35148.80149106708, 35609.56276733607, 36018.751950549995, 36563.41394184721,
                    36852.70351784452, 37182.372367484495, 37608.12144325968, 38077.444637455534, 38549.955251495856, 38954.88592082942, 39417.20505074357, 39719.21837290385,
                    40125.8042792429, 40724.961968813164, 41164.446272483015, 41812.49813492699, 42224.63331218628, 42696.16521971619, 43122.731069360976, 43799.471345968566,
                    44197.703964797154, 44646.15197543685, 45355.273930893854, 45824.229860239706, 46444.4887234516, 47134.91510550991, 47505.61346218054, 48093.25864686965,
                    48463.17322173295, 49202.644495571345, 49866.369538109204, 50307.0209373876, 50846.60775977639, 51577.42823677959, 52130.304148016454, 52691.69511085835,
                    53250.59897519543, 53967.63275140123, 54700.274430892474, 55372.01112053795, 55968.06987639319, 56867.35031473779, 57451.79982367642, 58303.09723544275,
                    58922.8114712268, 59778.29071557835, 60439.80336735719, 61070.38087021157, 62150.70579251569, 62506.2400896546, 63285.862270972764, 63649.8611841696,
                    64726.87956382803, 65193.53374374984, 65935.18078656228, 66478.24328217992, 67629.98753672457, 68075.27010430768, 69145.32377943303, 69879.54466395514,
                    70696.55103333302, 71654.7944444127, 72568.83597503215, 73543.6436505053, 74275.19928173361, 75061.84521541459, 76269.7516604588, 77463.51204693466, 78305.1789992632,
                    79411.95751984186, 80449.48391667801, 81867.38287662473, 82620.18603676399, 82944.96919543215, 83662.72836443047, 84043.33839954434, 85409.69753521914,
                    85971.29046297049, 87086.74165015959, 88481.83407147469, 89605.47221179189, 91526.81443755922, 92312.68978050741, 93643.31323778773, 94767.15504944729,
                    95911.9688314506, 96207.94226957098, 96557.98902011877, 97863.26429671576, 98690.18988085617, 100232.32087194078, 101282.92635004457, 102170.33744450907,
                    103419.96173645303, 105806.54240375882, 106885.7372462029, 108126.24266870097, 108352.78687260809, 109374.55719880741, 109985.82712955638, 111547.30250090164,
                    112219.54254045247, 112524.56181491369, 114222.13331339943, 115463.91211497717, 116301.28073471365, 116568.80752773283, 117545.88479743751, 118842.59674462846,
                    121251.37569304225, 122225.69118269537, 122553.41921701186, 124328.21439674891, 125911.04853568034, 126332.67981340272, 126778.59316507734, 128133.6364062359,
                    128940.7315370688, 129869.8564397216, 130816.27189549909, 131565.61592123925, 132335.19109727684, 133541.2433914402, 134856.99530451663, 135793.35514701836,
                    137660.8903957349, 139129.9766200432, 141240.50028465324, 142358.38109197514, 144220.28479912528, 144701.31459441246, 145687.72698996292, 145843.2784935425,
                    147261.06000399432, 148146.63163076664, 148589.9698039796, 150013.94834580386, 150484.86664524925, 151451.4972291893, 151508.11546051747, 152429.0542690752,
                    152871.364127855, 153370.06021153688, 153641.78862003674, 154849.60962490333, 155790.46469390494, 156281.4865058937, 156977.02901953223, 157472.55296719086,
                    158192.49607328785, 158315.9914360443, 158613.02078164357, 159256.1275360414, 159485.63731920972, 160649.9507699145, 162065.77879570262, 164040.82836848975,
                    164253.15745128618, 164518.2295916837, 166264.35692674396, 166346.1241747027, 166484.73418291975, 167760.38706816608, 168046.91179316072,
            },
            {
                    47270.82162542315, 47612.6003882724, 48124.97050889209, 48806.865950659325, 49291.150790504194, 49650.72287078281, 50095.72289876183, 50683.79936198399,
                    51149.38583946996, 51872.735586218005, 52343.42234611583, 52856.607978855645, 53473.73273307313, 53915.84077838252, 54473.502474986155, 54875.45821700446,
                    55307.911888649345, 55748.46589845833, 56425.49354484362, 57081.95468276005, 57518.46926949399, 58141.93048815492, 58856.519215375396, 59226.33416256713,
                    59791.207615602456, 60605.46226322718, 61134.21447993713, 61955.6571271055, 62747.68309023563, 63492.31174488727, 64194.0102460736, 64717.92677240835,
                    65279.272353442255, 66083.5282114963, 66969.78133703033, 67481.44617127757, 68012.69112191009, 68522.32009313258, 69469.37420253527, 70067.0898301875, 70887.178675695,
                    71478.88697056568, 72114.21966790121, 72701.43984369676, 73483.68558111228, 74488.55779008688, 75251.09256181798, 75645.71752692231, 76494.64678387501,
                    77191.55832127016, 77939.89153744273, 78910.77240837885, 79478.67426548121, 80527.12129378975, 81387.53565899115, 81957.84389966795, 82800.12446947607,
                    83534.17895192992, 84228.82972175677, 84971.82746636451, 85784.87233481342, 86480.71285935756, 87672.98366678407, 88985.97998457833, 89601.12954041036,
                    90531.50899412342, 91738.90306102768, 92557.56817985185, 93868.73584377483, 94918.44039124223, 96223.49372440959, 97074.91249303488, 97889.69455412764,
                    98889.2755267402, 99531.97647523394, 100154.1509511274, 101257.82237326172, 102253.32717065712, 102960.96420645724, 104159.17673686496, 105012.09095103221,
                    105691.55194967844, 106488.91239032547, 107368.75917403684, 108407.15730746115, 109100.1200746079, 110021.99347326191, 110698.45139902468, 111675.67510622002,
                    112877.73286103945, 114309.50840195913, 115841.72362104406, 116634.5786915186, 117532.9162393803, 118776.33209454716, 120241.77401333873, 121254.5863858341,
                    122307.38549659493, 123634.50403331353, 125185.71812610143, 127142.1178438596, 128550.10176251282, 129884.3808381802, 131116.79696994726, 132610.6839630497,
                    133846.10045950869, 135325.1717496334, 136824.957907786, 138064.16125512627, 139325.70086610343, 141564.40387324974, 142639.3255128661, 143959.2859309,
                    145257.03781513628, 147027.1333823731, 149067.05354282158, 151711.81274094107, 153038.19819248506, 155398.6201218249, 157458.14779339853, 159849.27434453266,
                    161374.9352159001, 162857.97985592482, 164769.11720744925, 166147.99633650604, 167577.98001603963, 170419.56777390657, 171941.58288474844, 173559.62865373245,
                    175876.81962667927, 177802.64760756906, 179403.25887214657, 182141.4447441623, 184157.2619806166, 185987.52384298953, 189532.5628119443, 192618.02407572692,
                    196868.76513427327, 199421.25423186316, 202909.09836376304, 204841.88315899466, 208160.2163544678, 212184.63308609757, 214460.84505382317, 216393.99988388436,
                    219981.91491706518, 225902.8174322498, 230016.95609678063, 231119.78613955065, 232784.49405840438, 236847.35730770032, 238300.2762582974, 240745.73813290277,
                    242342.50925377544, 244465.1937314753, 245160.11078883402, 249534.3165309213, 253286.29488829247, 253624.37480595623, 257650.01444310325, 260673.3535187715,
                    261582.10369184543, 266650.47108694474, 266795.4791610051, 267799.86174038623, 268054.0422243958, 269830.37320485315, 270457.0307620312, 270675.32191205537,
                    272791.814343606, 275214.80167340493, 277188.203275372, 283831.16339052055, 284993.80190333363, 286750.54324496986, 290000.3170697107, 291023.1314566506,
                    293173.73961718613, 293533.353780165, 295035.15811863565, 300147.81524280395, 304257.82900497457, 309062.3647832776, 310936.55125602294, 313342.5459188892,
                    314743.20487610216, 316994.84273719386, 318215.3943710811, 321101.43468237336, 323603.30094258615, 324278.270774957, 327699.72886823973, 328182.1147374806,
                    330525.8316341028, 331706.8112985908, 332177.6565437824, 332485.42023789266, 333915.48719946627, 334468.9826006183, 336062.0295492246,
            },
    };

    public static final double[][] BIAS = {
            {
                    10.238823092354272, 9.725363299909107, 9.222487291610099, 8.735431957728302, 8.270736917504793, 7.822501301508534, 7.391255094466184, 6.969524108237091,
                    6.566913620871893, 6.175198427092166, 5.798152754606432, 5.4481341207297564, 5.097592087776076, 4.759433618300469, 4.450004708799128, 4.156932338684772,
                    3.8751360598984688, 3.6083533006645165, 3.35198935056703, 3.113857534769951, 2.904293124848894, 2.6771308191268623, 2.494203177679573, 2.309863939212093,
                    2.1268020131484757, 1.9726056477009326, 1.820451945782651, 1.6728173466173288, 1.536446723263771, 1.3966801064477672, 1.2787098372986367, 1.1477151014137548,
                    1.054254208175691, 0.9750901605149008, 0.8818490065123549, 0.792441662708069, 0.7078046630714576, 0.6231763526174284, 0.5550295228159745, 0.4961987134400305,
                    0.4460340343155875, 0.42092766507493157, 0.3709558040625834, 0.32731650555261926, 0.2930797961906953, 0.24997474501807215, 0.20171087707374413, 0.1872697727911162,
                    0.14448219007693647, 0.13742116701404872, 0.1048187814070875, 0.10820437202685436, 0.10052633157509167, 0.07253952907892267, 0.032953809383083635,
                    0.033147332017672955, 0.003972783123437948, 0.06237031442010072, 0.02272460940724239, 4.3177933812619325E-4, 0.006867272215557697, -0.02509871852774808,
                    0.019032093064211296, -0.02865193985317796, -0.0883736822658644, -0.14705127487667033, -0.15660167481003034, -0.20015162802077294, -0.246660576435814,
                    -0.22551885912460168, -0.23081079750132674, -0.22241537900060998, -0.1809261122402105, -0.17011714051528953, -0.19374101986580122, -0.2008863665881389,
                    -0.2825898777727797, -0.3012017436374525, -0.3665195368432668, -0.37091097830764735,
            },
            {
                    21.77932649294573, 21.261115695867563, 20.751159067226258, 20.24915910631809, 19.75476648688801, 19.26732497026536, 18.786578222898626, 18.310905487923645,
                    17.839927196274342, 17.387865333182482, 16.94149546391533, 16.497249235818824, 16.059912306269123, 15.636802183334744, 15.221318484808126, 14.813233117380165,
                    14.406254563377503, 14.011143721866615, 13.61633519216458, 13.232001210193262, 12.85450016776248, 12.48402980947681, 12.124634639543544, 11.763358479018141,
                    11.423756989973404, 11.086149179990363, 10.76899911647982, 10.46118423132486, 10.149917249898477, 9.835350104379586, 9.531988779230048, 9.233663012500285,
                    8.951483101229117, 8.682218578754679, 8.403434589771958, 8.139340545393749, 7.882382807328878, 7.643917737439683, 7.394616846716786, 7.1452415848692326,
                    6.904357522212664, 6.682141938915918, 6.46134257715977, 6.232465284656567, 6.0050785381748, 5.7967989097010975, 5.5936793584841595, 5.4012472959998075,
                    5.2120514208014646, 5.034610026416895, 4.864662434174742, 4.700154250595166, 4.544013113908661, 4.393858212571545, 4.225210210583605, 4.089290769757506,
                    3.958947250536936, 3.815420071869014, 3.6669612248516854, 3.5534919581849955, 3.4248137485120123, 3.284053809931329, 3.1555886202142154, 3.0497208956774853,
                    2.9339095708025402, 2.8307922843740005, 2.7186239565503643, 2.6107442492694934, 2.5151120873717723, 2.4292405805468102, 2.333148103797608, 2.251787515360601,
                    2.1546127365044243, 2.079469940980697, 2.0040181302161737, 1.9206700706673732, 1.8275818577595784, 1.7585425145913012, 1.6387463303789769, 1.5685160022781572,
                    1.5132720477289832, 1.4579712138790037, 1.4111765075632128, 1.3328596532626158, 1.2783412507560097, 1.2506417555966487, 1.1951944417448852, 1.1277108851360589,
                    1.1036235830889602, 1.0618255811601471, 1.0028638929343798, 0.9451720102529964, 0.9345832432103716, 0.8777988945202787, 0.8536022538646535, 0.8372385811565642,
                    0.8209558022916645, 0.8236207090065446, 0.7794495103587237, 0.7760225643112777, 0.7516776037580291, 0.7109379630876675, 0.7028366449853753, 0.6722358307307404,
                    0.6502932790426181, 0.6388677028055114, 0.6237034396030041, 0.5871246055231347, 0.5476298717977784, 0.5387410593020013, 0.5292083561936225, 0.557791045175323,
                    0.5436123648830029, 0.5114233826564353, 0.49447666964380055, 0.4650792296451013, 0.43881734646396675, 0.4296816503868671, 0.4298335680300805, 0.4601306876301886,
                    0.4505952318407142, 0.4164977413892308, 0.39336589514580783, 0.40490447291308174, 0.3842953165607519, 0.32063285027683625, 0.28967873110400405, 0.2826660691758951,
                    0.2553226248956084, 0.2393387489878183, 0.2581952349423751, 0.2409074803876497, 0.22976295411531825, 0.22534951364428663, 0.22035867773015272, 0.16785626657607147,
                    0.12796347528368981, 0.13402700957482616, 0.11893805269337548, 0.05373983754872391, 0.07634390152854563, 0.07311072076653374, 0.04079536347221738,
                    -0.018070585368414174, -0.037158031079677335, -0.09438888919648052, -0.04654244103360447, -0.06321879376789193, -0.06658343048439672, -0.026823121101906957,
                    -0.016708736560567743, 0.03477591468481151, 0.001987652004478293, -0.01764357569287579, -0.021397736888609797, -0.030259785060503395, -0.03390890478393419,
                    -0.03715035515431388, -0.08378156627423045, -0.08291650808946355,
            },
            {
                    44.854533130412854, 43.31072242086501, 42.29929645296603, 40.80832079609545, 39.34888741647967, 37.45748177790311, 36.53342031818346, 35.62364530505762,
                    34.727805614623165, 32.98144360990141, 32.129787381154244, 31.293268346875685, 30.470970035021207, 29.255836148770943, 28.464214189694253, 27.290744163131215,
                    26.54355767689911, 25.448422103894863, 24.041051492531412, 23.70633117479583, 23.354973765455576, 23.01433813755566, 22.687247405629638, 22.37270066728848,
                    21.71796857261621, 21.07420144916793, 20.461159521757235, 19.57276076341442, 19.288985152611264, 18.705150722973066, 18.152373813334002, 17.616361045661588,
                    17.360032534571506, 16.828595412333556, 15.812722687551899, 15.314521297893567, 14.82876099248924, 14.131605850811457, 13.9253194985686, 13.457111780240043,
                    13.032571319140546, 12.802342627591026, 12.154078382737248, 11.365562975279467, 11.156747360274363, 10.985891955108356, 10.395689352983817, 10.185751470603346,
                    10.03210278299047, 9.841164444073238, 9.669926949464095, 9.511678656801768, 9.339474045227302, 8.692672411388367, 8.509620089134764, 8.392262982568443,
                    7.941130812051664, 7.6115000626421745, 7.494413693088954, 7.201577095733469, 7.073634310585061, 6.637692644860348, 6.477091623534802, 5.996265956427894,
                    5.488066096628463, 5.3863940441776, 5.14218557024678, 5.073367533649235, 4.980256109537748, 4.771328209061618, 4.600389438682898, 4.486876788953755, 4.074711411925955,
                    4.011922770495271, 3.930693115274875, 3.865768952308706, 3.692556765515613, 3.6251001464859876, 3.467791813311393, 3.3654185654259465, 3.1441119224837664,
                    3.110311133848298, 3.049758785922488, 2.953345108137933, 2.722413895021309, 2.594483769518061, 2.5344668786924593, 2.485636874229575, 2.4168373486182473,
                    2.404453087958691, 2.337143430073386, 2.292856564797395, 2.2641353136453852, 2.1633825009284364, 2.165368779670483, 2.055175217637801, 2.0647637904209613,
                    1.9776371486831243, 1.896715990802653, 1.8042570445800072, 1.8051727860704079, 1.6898651091017534, 1.5886144892897662, 1.598026762577158, 1.5719470540540192,
                    1.4529911434565776, 1.3921029677671037, 1.3985192699967117, 1.3318795408860253, 1.3156222495209002, 1.2621572834309658, 1.2476517422325166, 1.1661627983063834,
                    1.1738131044248716, 1.1015610254066064, 1.1152413752774786, 1.097709364388729, 1.0284016977251795, 0.9767101635208612, 0.9049128682328635, 0.9129449067796686,
                    0.8522139881626348, 0.8192445919418104, 0.8049785717031411, 0.7758176914235289, 0.7612247834627898, 0.7280837587006755, 0.7326987750657397, 0.6816872347249137,
                    0.6775151290225544, 0.7068558372877913, 0.6920888998869059, 0.6035756939348997, 0.5869616450036578, 0.5351494140289458, 0.513613686696769, 0.5439336931613779,
                    0.5326478279443929, 0.4795684383068691, 0.4218388868180399, 0.3673552957721631, 0.4083208971707777, 0.32784846420409286, 0.2852258957136279, 0.2638635091260102,
                    0.22664403458173105, 0.28403711914016816, 0.1868897630288896, 0.24067272852269903, 0.24626073671990226, 0.21642614291081932, 0.24055063244603248, 0.21263550393571345,
                    0.1483824353130072, 0.16610881584448686, 0.11092541090870796, 0.12164703318215392, 0.07056159459919392, 0.09644115334866335, 0.05618962855806992, 0.03169645727509667,
                    0.05406801670207662, 0.020834882507554716, 0.011577529385406652, -0.03044834770523534, -3.6185732718440385E-5, -0.020007034119743833, -0.017128739945423625,
                    0.004560731359479733, -0.019434642886575645, -0.07764960696164745, -0.08978139928457948, -0.12951937835343627, -0.1549558948012581, -0.14043517625996074,
                    -0.18274144414165458, -0.16638568309801233, -0.19653050017910223, -0.163425169090774, -0.20456511795019372, -0.2004699822183182, -0.24120668144529994,
                    -0.23524208154574072, -0.17672601390716763, -0.11680022557183257, -0.18070545266322452, -0.2483879828675978, -0.2829478409901944, -0.2967194154906021,
                    -0.27344260644626034, -0.2984175523132326, -0.23186654885731436, -0.20594128309459322, -0.20720159683012584, -0.1791340797798821, -0.18697698360234122,
                    -0.24659346046755506, -0.268523433528275, -0.28835163512635237, -0.25977132428251165,
            },
            {
                    91.03509566514494, 87.44497621836193, 84.93301152406725, 81.49180819872358, 77.65088450234082, 74.85980426212826, 72.58262041691164, 69.89455607870187,
                    66.43589024787555, 63.91635000971054, 61.068443597640474, 57.15351467381366, 56.01434491448414, 53.03077953204141, 51.57666354443399, 49.11373225952451,
                    46.74047957549946, 44.10442156072723, 41.586616167872634, 40.1142299261621, 39.50059641687388, 36.57847260909103, 34.908129032222234, 34.14036108332653,
                    33.58741174230862, 32.29078057530824, 31.29180315613434, 31.06376255308094, 29.33339289317789, 27.93670232968653, 26.598750045737333, 24.693533046536697,
                    24.1198533744616, 23.49257080996978, 22.929157759524596, 22.130071539013798, 21.37442419404564, 19.742108238316952, 19.23609687001916, 18.69361835143731,
                    18.082277962968732, 16.944893975571375, 16.757464948498548, 15.713037817241487, 15.292230729912951, 15.125656382377569, 14.410475448045473, 13.895662664332173,
                    13.606652344126571, 13.494465710243631, 13.205489618009471, 12.680656865206673, 12.587755105815647, 12.009243376134092, 11.390356498094269, 10.936748335320617,
                    9.871700499898518, 9.803999101667733, 9.585642163113436, 9.444677912575658, 8.576482726269687, 8.265142372392402, 8.144916439983897, 7.8918999386739745,
                    7.532194770457669, 7.267845775592312, 7.218229067083793, 7.108488597645096, 7.073349030052328, 6.901134718039511, 6.435398043030226, 6.121981879062108,
                    6.099612582356893, 5.769904503358634, 5.402324140854049, 5.364952273850942, 5.279828863189935, 5.100914459825475, 4.9305444893739026, 4.676501927006466,
                    4.464226632708796, 4.447467147603902, 4.38119739125753, 4.115818549712875, 3.763181341591027, 3.6911434759225354, 3.613214038590998, 3.585259612738368,
                    3.402601150200612, 3.3068004518027547, 3.288091917023403, 3.1512923955682868, 3.142794801797373, 3.0831210884754774, 3.0712528029735453, 2.989013368777191,
                    2.9730157913194857, 2.9022652657978845, 2.7874916917164576, 2.667991966432039, 2.4654621194499433, 2.3709129215527645, 2.428873778787659, 2.417623366505394,
                    2.333184736350441, 2.3632124615823327, 1.9362845183903423, 1.9191150967202997, 1.8673569177882585, 1.8291946737915759, 1.526430792850817, 1.3502543187292082,
                    1.2401348625626898, 1.0988079117740268, 1.107656061723966, 1.0433915143613834, 1.0274642473261595, 0.9789458069745539, 0.9872823528630178, 0.9457042355400557,
                    0.9716493224273058, 0.9528951261532481, 0.9020504135625397, 0.8978141263662645, 0.8508188000598256, 0.8969098904857925, 0.7860743487099492, 0.7512013081151059,
                    0.7784990127439121, 0.7330076075667638, 0.6760334928103322, 0.6357261627239759, 0.7233914456992959, 0.6753409104113175, 0.7271092833350659, 0.6412797374586572,
                    0.5002945337610523, 0.5099255891692488, 0.4526985990731207, 0.48313241565288895, 0.41278098184838546, 0.4546865922723207, 0.3888394758548597, 0.4288551293086143,
                    0.3016895767863453, 0.3395550920861157, 0.2366044843032744, 0.2519954165100637, 0.15529883640302475, 0.14284832529965405, 0.1812920462621344, 0.14932108448906484,
                    0.1320123491863321, 0.18013165120279864, 0.15180250757010771, 0.18306268031891054, 0.12471098079157028, 0.09455847877229533, 0.14644235085877944, 0.13878138480501748,
                    0.19067181444038553, 0.10539986000045887, 0.013137322955277262, -0.07421701451067989, -0.08658476206378092, -0.14390275307098993, -0.20883479572324945,
                    -0.168217608811913, -0.18494061123695332, -0.14947518599042425, -0.17063085299960973, -0.1017337316469722, -0.1193037070855437, -0.08620012975385775,
                    -0.08649412147192426, -0.15535083441507938, -0.1764188987922718, -0.11211620260078244, -0.14862981091134642, -0.12015796709772761, -0.17513214037844713,
                    -0.20344912930551876, -0.14245131558437496, -0.2594445805240912, -0.25949577040979105, -0.32380069741380524, -0.28667367522266435, -0.30234892309057076,
                    -0.2335356234139539, -0.32291675022196165, -0.27444887480286273, -0.2864355766322526, -0.35173062896380747, -0.34298949000174517, -0.25996888003383645,
                    -0.2881108361976834, -0.20764121401902658, -0.22900076084450552, -0.18245128713404513, -0.1548875688722315,
            },
            {
                    183.3579859401234, 175.15443283236525, 170.64802549992893, 165.73378884943716, 158.52358084097227, 151.97691752635689, 146.0657993482173, 140.2862994438282,
                    134.6625730493835, 132.12408374656806, 127.15561782715064, 121.86471818361017, 117.53195941895858, 113.69586545849359, 110.31692514546307, 107.37778290772013,
                    100.94786382445464, 96.513497637161, 91.1979471302961, 88.633381600033, 84.28362133297816, 80.96927781514182, 76.90841349102274, 72.43219054153332, 70.25243089605287,
                    64.83237974687898, 61.39565954837967, 60.95387120776302, 59.25069503908912, 55.575147608173744, 54.025570966841215, 51.03686205090903, 49.85241248994508,
                    47.566709927651345, 44.62929755761811, 41.497176269927216, 41.01813292971517, 39.230285323635535, 35.21821330177322, 34.243499355498265, 32.0014139242113,
                    30.496114486899664, 30.31689289430333, 28.967056241288592, 28.87115061503281, 27.159740816581795, 26.510002926704807, 26.104225922321056, 24.685380456139562,
                    23.372190817129308, 21.96981973416916, 21.58878382378962, 21.074132440321698, 19.789299124047986, 19.54805474836127, 18.048933469179108, 17.011953022907825,
                    16.706948689131202, 16.070291209282086, 15.458537929421265, 15.106622002133937, 14.969551215988568, 14.248261134539396, 14.043995853376595, 12.862062320735408,
                    12.837601476223199, 12.467443510659312, 12.305048387470043, 11.528609100172543, 11.495866946545167, 11.401192059935239, 11.395651637428864, 11.25783373013738,
                    10.941468461893601, 9.831734773659438, 9.677216267255126, 9.03965081126265, 8.685471535870699, 8.643985916225759, 8.28338787423246, 8.179575524934364,
                    7.925639149452067, 7.642067756097123, 7.591197935777718, 7.478220616079007, 7.486205466404321, 6.939053635682827, 6.6647304995102745, 6.192909529518144,
                    6.161337549794166, 6.07845583017274, 6.110835135699631, 5.9435567609064295, 5.782584097752108, 5.48478217677292, 5.449209906513182, 5.152838626331962,
                    5.147743125040923, 4.958008427955844, 4.657528464499171, 4.550504258917985, 4.45204222703702, 4.426476532483813, 4.339066710924163, 4.382451970268392,
                    4.186659325944689, 3.820512776562806, 3.8339813322565024, 3.7265292754856563, 3.5688610573288555, 3.509916459201078, 3.617017987449731, 3.4892642985240836,
                    3.507611470682056, 3.3928437680796564, 3.4036796364677184, 3.3284855397290762, 3.386754663737092, 3.1625389456842203, 3.253558540254674, 3.119486865261406,
                    3.1132262837815188, 3.012352144423518, 2.9241245963411484, 2.8364299502299595, 2.8490322233863092, 2.6844199868481406, 2.705881473401638, 2.6269831245222077,
                    2.70544161296671, 2.6703305966035606, 2.577949472679685, 2.6353254890876343, 2.5704413811509506, 2.6061631316965825, 2.5027014174139826, 2.558712930064865,
                    2.4956826155236342, 2.5398720559753327, 2.4157045189646253, 2.2006012480821964, 2.0351302275210976, 2.100896446502091, 2.0138853699296644, 2.0939491288115186,
                    1.9631741079761822, 1.9657545829164609, 1.886063523513105, 1.914482821790948, 1.8489795110233442, 1.8634448066576956, 1.745997815687976, 1.7669136568917276,
                    1.4995513078244929, 1.5546750046472122, 1.52034867272662, 1.368166056256219, 1.341161043616554, 1.1601815334401984, 1.1715966924735681, 1.1052085805777911,
                    1.0690271874970565, 1.1270391958768313, 0.9325013520303044, 1.0025626733837871, 0.9247902934588768, 0.9741555182789692, 0.9556455070370892, 1.009798669798038,
                    0.9625590230949643, 1.0877760519625175, 1.0336743852001236, 1.093805082815207, 1.0613724898390187, 1.1367604041823456, 1.0612351981125525, 1.1379974106252915,
                    1.0481950193208047, 1.1112797215948322, 1.0055576451485848, 1.0391903379214649, 0.9854774610749386, 0.9642503261962265, 1.0326284684475724, 0.8117078014671361,
                    0.8603727887116251, 0.7356816439809376, 0.6430445292736828, 0.6493201568338235, 0.745647962719053, 0.821960403934129, 0.7683805978249386, 0.8750726888844104,
                    0.8893465472327295, 0.9620788769735585, 0.8214884938680619, 0.7770876742710623, 0.8520399712472916, 0.6156557963754946, 0.540606606632952,
            },
            {
                    368.0069786460945, 356.1669746478074, 348.57806250005774, 340.090322539455, 331.7421424771744, 322.5521582364457, 309.78572659222965, 301.9224700071899,
                    291.03092190250413, 279.5372251526111, 270.90434126302773, 260.8138580868185, 247.31268057458692, 238.19260004329902, 230.48473376643884, 222.56819551592127,
                    211.88065454686046, 204.03363251400242, 196.72991496503573, 187.65249547332374, 180.20131586256164, 172.93436000420104, 166.18057152057875, 159.96518073128505,
                    149.9294951568351, 143.79820271093104, 135.85524981329934, 126.68716041356404, 118.39575817557059, 109.51697650654297, 105.23222675461457, 102.19388874389021,
                    95.7278564863568, 93.27551673361708, 87.95796578640554, 84.27766222832612, 77.11430956381774, 69.87569770881842, 67.44048374788903, 66.76648202887709,
                    64.56065564078641, 63.77777894208579, 62.571842292726906, 57.63508608547455, 56.472752764601076, 53.243325860425195, 50.826318049188515, 48.190864269380924,
                    47.33195769496756, 45.7439480057862, 45.31955107375711, 42.30927023790365, 42.00693771059287, 41.017215139612446, 40.215506355546715, 37.51629633238418,
                    36.90037359141804, 35.91550224243003, 34.78477124746838, 32.70516637193439, 32.29941864056301, 31.14411594200565, 29.613888296721115, 29.047625959346224,
                    28.18389047801257, 27.839405182098943, 27.343142327916798, 26.536014168834505, 25.580035992937322, 24.24671283438351, 23.42069821508499, 22.23965797148287,
                    22.14510481509427, 21.440645183609252, 21.21252990316887, 20.7808788152241, 20.662812339831955, 20.22499893516055, 19.963088765125814, 19.07490171237684,
                    18.659462466536105, 18.314794807788594, 17.459618217892274, 17.046416498284906, 16.524165403550608, 16.04907473908279, 16.08138517392056, 15.474309808229474,
                    15.281901705504016, 14.652830499163565, 14.313099220104005, 13.798136325455902, 13.46575330258252, 13.124376169402092, 12.935758375054101, 12.681169186167427,
                    12.403132208870481, 11.713849982002058, 11.293305210352887, 11.053864230067244, 10.558830011915356, 10.520528027785872, 9.864501950808698, 9.719152104354187,
                    9.25718900194388, 9.241871254500266, 9.000514578623227, 8.87988463836227, 8.322868850238299, 8.357850828077035, 7.930960568300436, 7.639722641425123,
                    7.164162470546003, 7.164832322823764, 7.059089686774249, 7.122767994245008, 6.6869139998362295, 6.665202982081365, 6.52637598149885, 6.583283378305895,
                    6.4636710914323485, 5.91182853865124, 5.88729117832858, 5.7862412211402505, 5.8406991999901825, 5.682517784510844, 5.628507773974217, 5.256045900538127,
                    4.991373124751668, 4.562812734642668, 4.307623327175526, 3.897521478224666, 3.545832251986073, 3.3629856213093556, 3.4398099369332833, 3.2669116821018043,
                    3.2540727303058654, 3.102318478265756, 3.049585587549698, 2.6329058841165462, 2.379417837851498, 1.9105164095930682, 1.947450183490001, 1.7948201724956008,
                    1.8822570860975094, 1.6759076404405189, 1.778843704144762, 1.8273947024265165, 1.9532398627556264, 1.9137887765347916, 2.121974353282605, 2.1741486998279393,
                    1.9909961931778895, 2.048698034481168, 1.732620769441942, 1.7287938109546162, 1.5956477188790787, 1.594296886383122, 1.4907471345532903, 1.550741391868184,
                    1.3277993395822199, 1.4098951652432226, 1.3231544789073761, 1.2021688408080935, 1.1405504545575365, 1.2866251216456577, 1.165926100607628, 1.1475715486439606,
                    1.0438214731432403, 1.1390018197500036, 0.9171730894655317, 1.0371862174826252, 0.8886641391057875, 0.7452822347378377, 0.7786973213174605, 0.6675573962932657,
                    0.7382689753177741, 0.5906053064486934, 0.6941315015443014, 0.5976221289192901, 0.596427191739937, 0.80968646880955, 0.7542462715714094, 0.40042728621033497,
                    0.5398217640493861, 0.4840541632211209, 0.5958721049620195, 0.5029144240664055, 0.6816280568173227, 0.5832652497801212, 0.6937510834510658, 0.7510782651607842,
                    0.6551390155425925, 0.8594959314434841, 0.6955551727430519, 0.6578010407473527, 0.4960747318468698, 0.5818722213058686, 0.4001947342190544, 0.6775528374579478,
            },
            {
                    737.3121672049899, 723.8709568608225, 706.0452620387489, 679.0624676324497, 661.9422477277452, 642.6908233403522, 622.4153505085907, 606.6715977902304,
                    588.9590156860164, 565.861548665045, 544.2498284074398, 525.6862080836326, 511.6448834859407, 498.262942982882, 484.315751473299, 470.2609987443733,
                    460.28586554994376, 439.3045136314493, 425.4878338605352, 411.9231205160592, 401.4449371721781, 391.18692792934047, 378.10313454223217, 362.1547935432406,
                    343.83810829781703, 326.24264952133774, 314.1627887110847, 302.6859191745341, 287.49846668827547, 275.5673646160462, 268.60640666522585, 251.9511489220825,
                    233.31953562923204, 219.12377206761292, 206.5368410324891, 197.8472650751431, 180.68642230614728, 169.32420524288793, 159.5442982331665, 154.5743601362339,
                    149.98001244002, 144.63179942799803, 139.85452560716755, 127.75416177579123, 119.37519692854184, 109.98114390047856, 108.58792517945514, 105.35827277533261,
                    97.02182130499855, 90.85778646078188, 84.73036471372362, 79.5089433265559, 71.88807712127402, 69.18481480830022, 66.63438954171103, 64.65437958501576,
                    64.09850172372869, 63.1745726344622, 62.01402127678661, 60.06331217895317, 58.07284105645449, 54.564408829836076, 53.28236819098931, 52.23747609657953,
                    51.65831046403508, 49.356525694450724, 47.22177280577809, 46.879091133574846, 46.01876810536664, 44.58408830479701, 40.517185838789054, 40.02042045430546,
                    39.352548996078795, 37.27529772306616, 36.608596634948455, 33.336399666795074, 33.35477360213348, 33.01606605567361, 32.02110526575872, 31.52036901472501,
                    31.158319642281878, 30.017774443649728, 29.792501011688604, 29.208159614608046, 27.408317764250743, 27.020749219261173, 26.746363579479066, 25.992148041136875,
                    24.39336794594681, 23.82881519479763, 23.43844735752361, 23.396222767127817, 22.831110659389804, 21.885709283069687, 20.642739802432203, 19.176996246212557,
                    18.7328870902497, 18.522061019170014, 18.583129911124008, 17.5167541721867, 16.95648863652457, 16.675225946652414, 16.7166161898879, 16.3693430321102,
                    16.237920616968196, 14.461005053298255, 13.791043041645901, 13.34077342241088, 13.368471930924134, 12.5741074040475, 12.570589172907892, 12.34446854948873,
                    12.383523354584364, 11.81647648311514, 11.780037760800386, 11.594618455657471, 11.594382327690004, 11.132298583360425, 9.99431489848765, 9.709810101553451,
                    9.78594132942962, 9.590025487511596, 9.631624969645669, 9.183815512055745, 9.157974309144015, 8.95943137782311, 9.019516317565573, 8.711997661466322, 8.77415218729795,
                    8.530722870477403, 8.60693123360486, 8.452271701257828, 8.150455676447141, 8.366399806710715, 8.003224139192135, 8.0757291777397, 7.8219022214407685,
                    7.934293434054334, 7.779014261579994, 7.42587722382507, 7.078919282589461, 7.11302104552076, 6.532077584268357, 6.4188910075824515, 6.271886254414798,
                    6.237693663934459, 6.021577662474476, 6.138029513577281, 5.907721704086147, 5.980375895126972, 5.859404905771034, 5.935263866121038, 5.504372229154045,
                    5.863004637024792, 5.783396989853594, 5.520512200993608, 5.293391878378253, 5.413995978087865, 5.111968004337783, 5.17230325945725, 4.922892869966052,
                    4.924895507058817, 5.165975960814142, 5.029700293776178, 5.090980619060587, 4.884854106738264, 4.9421092175308425, 4.802909848249303, 4.580384235968738,
                    4.283161560972114, 4.333837500236265, 4.098295130521738, 4.0124946834213775, 4.045990165659868, 3.915667241759442, 4.308689747181873, 4.155095286389661,
                    3.981647256698916, 4.224503684595857, 3.9675729847647543, 4.121278691725224, 3.6293729286965593, 4.096980555572773, 3.880685557739672, 3.841009157956013,
                    3.578463604389455, 3.7234129697845235, 3.5928508562225616, 3.3470560054022553, 3.4579258567022344, 3.3123188451134777, 3.3016772728935564, 2.8764873703257434,
                    2.9905344268141683, 2.869153498315134, 3.003297967057929, 2.8517107645389688, 3.13366667235333, 3.0546566067940075, 3.291594070550902,
            },
            {
                    1475.924446188915, 1453.1796341799545, 1426.5979169673353, 1402.8278104449653, 1376.8018862369254, 1331.0525427843104, 1299.6537005742682, 1262.1561482576576,
                    1232.2713809472139, 1186.487335717438, 1155.1083517886716, 1135.6931843845132, 1093.1467438338536, 1076.5274554507023, 1040.4408080177734, 1019.4131008317702,
                    998.7066301355037, 971.135317519096, 950.3011653107541, 925.9733043385185, 893.8344963132334, 867.2752458955532, 849.5406311428428, 824.553070957566,
                    793.5099007649404, 779.5211131833531, 746.8432307909808, 726.648217047118, 701.9466021383128, 671.716516215197, 648.0007429225425, 622.5546513783277,
                    599.0255446823782, 574.4719475860993, 556.2534700599119, 529.3511311103719, 514.2582764187674, 492.78645497017095, 469.50510435953123, 454.3552672036006,
                    428.9078504305691, 407.77213762381746, 389.5192256417531, 372.96871224228, 351.77390095807607, 331.67836993955643, 319.20156616786664, 300.7777852041382,
                    275.2965469371565, 257.61362422890664, 251.8625378988146, 248.04144950305445, 231.25156506780294, 221.54239575009586, 212.27527766702917, 202.9411091043228,
                    196.2693746621384, 184.62640614871844, 171.32462247895484, 158.66157030631288, 155.60456931510578, 151.5510114086996, 145.0739841250729, 137.93044801420876,
                    131.55714016495028, 116.09364390934645, 108.2884956497772, 107.22201385679003, 103.88642002325538, 101.68504375203864, 95.53877361467491, 88.82885488681993,
                    87.0568155644678, 84.78956227094311, 83.00407979925295, 81.75563018815417, 73.83364891368511, 71.99191898854794, 71.00610317888132, 68.84225334890742,
                    67.32813335105986, 65.88477887836487, 64.9648978214457, 62.79581226000677, 60.7816838649101, 59.83161831135646, 57.67901583249938, 56.90470426608239,
                    54.77231559631814, 51.436864560423366, 50.36791878099414, 49.58465748610667, 48.39231619815478, 43.921383702232035, 37.75623821706801, 37.39265055464607,
                    35.94721330967447, 33.882451750406965, 33.10959391849086, 31.27371244495293, 30.774713874879517, 29.407063566698064, 28.36649516659171, 27.266500336013785,
                    26.458133276467304, 25.009246458299565, 24.154810007794122, 23.31800073949117, 23.24617957242202, 22.364986677128947, 21.497573920883866, 20.93625858083659,
                    19.549618406913932, 18.806719498811127, 18.88057683350483, 18.283430588649768, 18.403356773290238, 17.956949544701896, 17.092460845026675, 17.062852045173646,
                    15.845869262045452, 15.68631481881132, 15.160946526383407, 14.587573558257528, 13.92717245551287, 13.903067968738343, 13.191461451613428, 13.362649182886674,
                    12.550690675925098, 12.699040307575356, 12.25493386456602, 12.41036969612929, 11.723234482595213, 11.623904045442536, 11.35381216440383, 10.869658573289128,
                    11.013265726679789, 9.800102137459751, 9.766984246374053, 9.427751408639502, 9.347235334051033, 8.994322173166749, 8.434681822523212, 7.850098320018794,
                    7.087624005006715, 7.1917398962048615, 6.8190839593736845, 6.522722200578303, 5.881883081543943, 6.066601450949161, 5.519203340972851, 5.5365203118315645,
                    5.296320773139161, 5.467877564643896, 5.159686444739783, 5.562422100102622, 5.621171023087619, 5.114629575668982, 5.248490338979483, 4.649869433228929,
                    4.411712245923794, 4.628213992784325, 4.352902355929351, 4.426333040470885, 4.147787713573789, 4.003689889681914, 4.234840659037003, 3.6218420094013015,
                    3.869856697134824, 3.5824122277185753, 3.7704819056939285, 3.5540967095132174, 3.4898928825072, 2.9781953477478273, 2.874183765512495, 2.4385688470176565,
                    1.830868033172719, 1.5957640036471028, 1.7467364098012463, 1.3431347287997308, 1.542757800707062, 1.3170764882879493, 1.501495316195384, 1.1894982718368061,
                    1.5135470349427347, 1.3077744619609148, 1.3476370728004075, 1.0309288657468383, 1.197389139830681, 0.9894833965175882, 1.284585343511254, 1.3042798378889455,
                    1.610760605656551, 1.3224342299892577, 1.4188339964082448, 1.8394091468410607, 2.0203543910390884, 1.6042693355615243, 1.79987607388383, 1.6117100794837167,
            },
            {
                    2953.1464563382638, 2907.170296357156, 2854.5030376560485, 2817.002707389513, 2762.34388453738, 2722.6368953644746, 2663.7899948364206, 2625.9749325394596,
                    2583.244864676897, 2516.5003985815233, 2463.809262527319, 2418.2681512750437, 2369.154415153337, 2315.8576397919296, 2263.753022826492, 2218.046003869108,
                    2181.0486875994316, 2135.9738555386202, 2107.8887584442887, 2057.3633164810444, 2003.1559582934153, 1936.8566976187644, 1867.4888142126044, 1800.6527172781384,
                    1764.214543646395, 1733.0135991347352, 1692.8606792114904, 1624.6185853439958, 1592.68844500936, 1545.7247871104112, 1495.9412176707624, 1453.945843807871,
                    1415.3844787037779, 1387.7911665524325, 1341.933941059581, 1307.2421250959796, 1270.16710644939, 1228.6955460313725, 1196.8405111004608, 1159.0505386882157,
                    1122.7419126264144, 1100.8230267518834, 1064.5506908135173, 1039.0725640386825, 1007.9980566604727, 965.6827566949449, 921.597926823577, 902.1728000720481,
                    856.6640292899492, 833.3261904492308, 806.4580049519608, 775.1512482481172, 746.8156097125973, 711.5932385297949, 680.1275953615825, 668.2383556700952,
                    648.3040060546119, 613.7729816712746, 573.6993718496195, 547.4585116834376, 517.162727817309, 481.05465014738365, 465.3736338566445, 440.61482017795225,
                    422.5924173448098, 399.3613263891252, 387.6349665632167, 378.50663916157595, 360.55252152599047, 347.5648883154843, 337.3888984845234, 324.3142448147866,
                    313.8952024253618, 302.31051298033685, 278.9066794678829, 260.2772239046164, 242.19798029411865, 226.31776446878274, 219.73530584369587, 206.53572496928444,
                    188.56293960139467, 183.78996374487775, 181.7179161229008, 161.9810677278882, 159.33349007365155, 155.0869409297708, 137.8417350365973, 133.2947318449789,
                    128.3753422684014, 126.29278722790504, 124.944689050387, 122.50880203287942, 119.37756728293608, 117.25719244225505, 116.14123581881161, 114.67039568139789,
                    105.80841269903009, 105.38206890441992, 103.711611542557, 100.32078306409464, 96.5171972719623, 91.47506089037485, 87.7816816091971, 87.6474696948268,
                    77.71241150131554, 74.80673067846705, 73.42704872306737, 71.2116073755126, 68.903015733733, 66.65209341351033, 63.49616045327397, 63.15796570667261, 60.97574220267245,
                    59.38663409147522, 58.72166954047739, 56.87773481202455, 55.03429469692863, 53.94722307922193, 52.594092138496954, 52.361796243452275, 46.81305098227441,
                    43.48034741001723, 43.46152702887654, 42.47834397982397, 42.42255935932753, 39.53021323675283, 39.302970028112135, 38.2839787186517, 36.95306802845159,
                    37.10907629752438, 33.42278652002176, 33.462445725623404, 31.55324781462879, 30.362821940048015, 30.29654469705957, 29.786229443029338, 29.922789445871185,
                    27.45131822031141, 25.99130370709419, 26.12250330749306, 25.365485398831606, 25.396871207654407, 24.671036640234142, 24.11092444559575, 23.706190341177315,
                    23.763831382092057, 23.19656795897967, 23.436370180302685, 23.06274126818625, 22.45291878868188, 22.40253321116311, 21.55843149989131, 21.726739415464756,
                    21.364206844186764, 20.59867322392241, 20.02506177006047, 19.832428820798075, 19.159711717333465, 19.199460362953047, 18.552606593134694, 18.49584978593723,
                    18.00341962816599, 18.07481405005218, 17.71780462908891, 17.919897021845685, 17.26829608128148, 16.70265830086001, 16.145726328222555, 16.27089578387082,
                    15.47047276954796, 14.636074396663108, 14.164657426553093, 13.363609544874754, 12.760601293450435, 13.045045317940566, 12.219213652275318, 11.067678941977384,
                    11.160886348305386, 10.144127600779791, 10.259859093828643, 9.716496631645498, 9.828345766230056, 9.367203086008772, 10.295032628008737, 9.980207269022355,
                    10.262951695151264, 9.9712308353302, 9.418522795621596, 9.60788189340713, 8.349300542051319, 8.265782118705795, 7.64119696541036, 7.89343970896552, 7.5278110223693595,
                    7.778643691996762, 7.427419348212125, 7.788987108071113, 8.603359703352513, 7.95193124637438, 8.074277544621555,
            },
            {
                    5907.59037259784, 5788.901289523198, 5655.5801092591855, 5543.597147438802, 5404.460261712385, 5314.598301776293, 5245.884293533163, 5156.278961879988,
                    5085.534833095583, 5021.515829215206, 4929.729444799358, 4878.923187501, 4804.359632911879, 4689.494314772083, 4614.552526219073, 4511.114185018561, 4383.850732631423,
                    4294.89094962892, 4179.19249105427, 4090.172261859073, 4042.9148264954706, 3935.4319846475423, 3842.638818449992, 3772.170852949328, 3708.989096963646,
                    3644.0323781302645, 3565.2399958686738, 3505.730760635905, 3415.778530099446, 3308.5904426522766, 3246.801682310875, 3170.0362581523623, 3065.5775320157672,
                    2974.0912240680977, 2899.0208103494247, 2817.9769702888293, 2778.14698239867, 2696.061126173911, 2642.651402759101, 2565.918921100682, 2502.571910422198,
                    2454.546531010629, 2391.343973629503, 2327.0214371983034, 2247.2401181247633, 2158.7834651610306, 2110.214618801576, 2039.308982004056, 1985.4500570626678,
                    1934.1658971748766, 1886.6698353900108, 1841.2706885860855, 1791.9999750035242, 1735.6161153232322, 1686.0667992867286, 1637.0440019289306, 1592.59950022068,
                    1528.509511707983, 1475.0374295452339, 1437.105504274881, 1373.5359067720635, 1300.7183917933799, 1252.3022626813763, 1220.3100622419672, 1138.970151095462,
                    1103.3782143291128, 1056.9126720340626, 1018.0750897261725, 991.7192928223254, 934.7256791905796, 893.1802060078736, 860.833681231087, 820.310612311833,
                    792.7898903485795, 748.3658720985425, 723.3946707667079, 696.3741679210276, 671.7284947151709, 665.0090252331148, 617.6457859699426, 575.32824762857,
                    547.2069284450579, 514.5226445741038, 477.0045913563675, 474.0081748620729, 459.25502500746865, 441.272151756809, 413.3231382872106, 409.71353092454467,
                    396.40926329412173, 379.69444292634745, 360.1443558341577, 338.01485493216705, 319.30544521929806, 304.7573774342253, 285.2447533416349, 270.4339997253706,
                    253.87574517414836, 250.46835655320615, 231.90040458943037, 224.73969149172825, 220.7115481794327, 219.11162405376894, 215.65000600524172, 212.15692950388092,
                    206.34578599588534, 197.93157176739837, 195.14346364091963, 192.50567695609143, 176.46152960967984, 174.27048168035805, 165.02141233956877, 164.60121128260252,
                    155.87972891510327, 147.15064232338935, 141.75693747914033, 138.3831479248035, 133.54600081610403, 129.23576729061668, 118.02287023001341, 114.3959795492584,
                    108.69103114627428, 105.84170881512713, 104.21070044712403, 103.40718807708801, 99.18285949316098, 91.3652959400763, 89.25559235382391, 87.57831889811717,
                    85.65743980360291, 83.25354471631378, 75.91484280068245, 74.24973578438521, 72.3710435857296, 71.46620289627207, 69.85823452272155, 67.74671842477252,
                    67.46079489162857, 64.07951641958823, 63.4927075335897, 62.39278766071774, 59.339867049473504, 58.58640205076805, 56.681403361050904, 55.82436933067917,
                    53.7469334917878, 51.14460961926227, 51.38026556184993, 49.93184650628197, 49.253458545783424, 47.82231528359613, 46.7439714879003, 45.292377752793925,
                    45.35335557876674, 42.35787219771276, 41.645705015875635, 40.88567123065583, 40.86663235373817, 38.92670346891674, 38.231338911388036, 37.60264691751528,
                    37.603671875223135, 34.2081757076238, 34.65748309121624, 34.05484388119773, 34.168574256309256, 32.17224643514825, 32.4800152928856, 29.592811671421302,
                    28.803750730055786, 27.272698883544738, 27.500560876428736, 26.048853838805595, 24.96707060563569, 24.373552125182812, 23.02657947168903, 23.25901637041092,
                    21.800724686827326, 20.82583915903295, 19.63100701611584, 18.378435887496472, 18.541915631560386, 17.644869254436102, 16.374984450331578, 15.611076909259161,
                    15.98033953681757, 15.689480386454795, 16.166799407002728, 14.59928849392338, 15.15369429527587, 14.141674243741619, 14.262043403370312, 13.544871429497388,
                    14.083931182225655, 13.612296106431868, 14.183253739962689, 12.231913351885428, 12.463643446306712, 11.45429816491159, 11.078958086032223,
            },
            {
                    11816.48284814069, 11595.030152959966, 11362.464195296252, 11203.01818427126, 10990.778358464597, 10767.438540703668, 10615.265038320045, 10403.073605058598,
                    10248.0579491439, 10017.553132655054, 9851.986296820434, 9649.167685994842, 9462.680466515418, 9282.619141937597, 9166.019452482671, 8973.993807382209,
                    8838.906198997342, 8720.122881636436, 8538.492951696953, 8335.566797500669, 8226.1720654472, 8125.899273870594, 7972.465032255407, 7782.8158221001295,
                    7657.463180656707, 7535.851950260256, 7346.447163103096, 7218.257909147372, 7036.456537123354, 6905.777641744824, 6837.26246640887, 6640.34355492371,
                    6564.573047168921, 6432.574150312273, 6299.063881387845, 6226.084603672464, 6126.226683644712, 5952.737489572591, 5792.20199316548, 5724.795704131632,
                    5612.494383877544, 5506.036495232817, 5420.929293258122, 5312.872147784395, 5140.878861277771, 5007.28257377773, 4850.745396102178, 4768.998254388644,
                    4626.094229314131, 4511.898428752113, 4401.295459186885, 4246.233494191898, 4164.282566221569, 4032.854146868805, 3901.080246180994, 3823.7790642883097,
                    3762.5087383624136, 3655.8036273155276, 3582.575348286593, 3479.595161890546, 3417.9996514848617, 3270.7167087155103, 3144.9189487495883, 3078.0219271828173,
                    2967.9781880451396, 2866.6157908157443, 2805.5702260092858, 2697.5094860808163, 2634.0562978458406, 2498.9919055865257, 2437.2224692024047, 2372.775764778115,
                    2267.030105629418, 2191.3651845362515, 2156.7090578779635, 2069.7256764345366, 1998.1188860387172, 1935.2738133353043, 1830.7969325701615, 1778.740811925828,
                    1720.838301431762, 1683.92124648844, 1629.2684803235438, 1574.1646964620336, 1523.299562693527, 1467.5310272003285, 1410.9739531126083, 1376.5966536764754,
                    1308.647235123348, 1239.569970345192, 1189.3541953958522, 1117.8087854171542, 1040.3302077905582, 1023.9220103388105, 988.9245392543743, 932.3154714611456,
                    900.8897773030216, 833.1665536380252, 815.7483284245958, 803.7001266694376, 747.5498089341354, 724.9683099376111, 681.3941292514405, 600.356719035478,
                    568.7101222970397, 512.7339460692237, 485.84010255306424, 462.719112268523, 455.14372539935283, 404.7332066180799, 400.7440447889226, 386.7753958707021,
                    380.5289898416893, 376.366702824151, 362.557319693995, 342.0085609486169, 336.0659268195215, 329.6645012598121, 301.64930325140807, 294.9368583992677,
                    291.66214267566477, 252.93540077712476, 252.48398308247687, 248.23044622781242, 242.82492909195824, 236.96091404784656, 226.70676439096755, 224.5205203885506,
                    213.03831282242018, 210.03398563113294, 193.68226396481225, 190.35250874078693, 188.0076840269464, 167.40878205199846, 165.664499989905, 141.79392626577905,
                    136.72520432806877, 125.94160988866957, 124.38341029594602, 120.34324611568609, 115.12847265662671, 115.28362352055198, 113.81045314809468, 112.03383415240242,
                    107.34725376252757, 100.66207241919817, 98.1603362679522, 98.38968651211043, 92.2062455051056, 87.67046147810485, 88.18743358181597, 82.77300158583373,
                    80.27048156308999, 78.16410239005147, 76.69539100953834, 75.83755356282182, 74.57881951114953, 69.40138912481248, 65.70910055745915, 63.8151232224294,
                    60.697915741781884, 61.122412930857415, 59.267188527388825, 58.41570337836653, 55.63609802153704, 55.66300781428184, 53.80579761067165, 52.35929611759057,
                    48.38284719181614, 48.147919122396374, 46.26464865650929, 46.62688375892381, 44.9585816508133, 45.54562456138821, 44.11100936942567, 44.4448464155148,
                    43.37363132586948, 43.395330491142765, 41.03476855860733, 40.26115372838158, 38.9322544448244, 39.36065919499468, 37.67315839058522, 37.05195488783294,
                    33.6406841609001, 33.6085314220572, 32.14576880686867, 31.459333810496116, 29.924958263724267, 28.77030919167918, 29.873614301647017, 28.039813651665614,
                    28.337763499819907, 26.46518537491207, 26.82084416192872, 25.269171275995742, 25.773578493414927, 25.01660312629283, 26.03382005971967, 25.108342925072776,
            },
            {
                    23634.26250432443, 23463.30602789379, 23176.553615582015, 22889.874224687228, 22488.936018665605, 22215.147594322778, 21854.773977533063, 21604.019386813325,
                    21389.2088781992, 21153.033387656782, 20937.71202427824, 20632.656582902724, 20376.65570467436, 20086.612021644745, 19773.77114870539, 19526.56360543604,
                    19273.635684759884, 18931.085034890395, 18747.29367269045, 18474.854806354302, 18215.18481438468, 18012.368754225954, 17668.908137565988, 17324.584076924686,
                    17083.762623592538, 16814.327245706572, 16537.14355523691, 16350.738773800551, 16086.011288994874, 15933.201797771102, 15631.41389090769, 15419.425885760227,
                    15184.18641890297, 14915.867116267795, 14710.754136275007, 14530.186356697737, 14357.801491066999, 14085.56276733596, 13848.751950549933, 13540.41394184706,
                    13379.703517844631, 13199.372367484639, 12970.121443259462, 12722.444637455497, 12477.955251496018, 12272.885920829489, 12043.205050743572, 11895.218372903853,
                    11699.804279242884, 11417.96196881291, 11215.446272483, 10924.498134927011, 10743.633312186275, 10540.165219716135, 10359.731069361007, 10080.471345968625,
                    9919.703964797307, 9742.151975436904, 9468.273930893884, 9291.229860239644, 9062.488723451841, 8813.915105509925, 8683.613462180641, 8481.258646869697,
                    8356.173221733066, 8112.644495571176, 7899.369538108896, 7761.020937387758, 7595.607759776452, 7376.428236779508, 7214.304148016302, 7053.695110858391,
                    6897.598975195622, 6702.632751401534, 6509.274430892418, 6337.011120537963, 6187.069876393019, 5968.3503147378615, 5829.799823676404, 5634.097235442795,
                    5495.811471226749, 5311.290715578406, 5171.803367357178, 5042.38087021139, 4827.705792515711, 4759.240089654604, 4612.862270972826, 4545.861184169433,
                    4352.879563828063, 4271.533743749782, 4145.180786562142, 4055.2432821797715, 3870.987536724381, 3802.2701043079646, 3641.3237794331976, 3534.5446639552592,
                    3418.5510333331245, 3286.794444412789, 3165.8359750322998, 3042.6436505054694, 2953.1992817334253, 2859.8452154144657, 2720.751660459032, 2589.5120469347567,
                    2501.178999263009, 2387.9575198416596, 2287.48391667766, 2157.3828766248894, 2090.1860367643626, 2062.9691954320047, 1999.7283644302438, 1968.338399544369,
                    1858.6975352192774, 1815.2904629705097, 1731.7416501597372, 1632.8340714747608, 1557.4722117919855, 1435.8144375593472, 1387.689780507204, 1310.3132377880986,
                    1248.1550494468681, 1188.9688314504226, 1174.9422695711482, 1155.9890201188182, 1091.2642967158438, 1053.1898808562457, 986.3208719407808, 944.9263500443865,
                    907.3374445092724, 858.961736452919, 774.5424037587073, 738.7372462027345, 700.2426687007305, 691.78687260836, 663.5571988075759, 644.8271295564812, 601.3025009015081,
                    584.5425404525321, 575.561814913464, 532.1333133992247, 503.9121149772194, 483.28073471378696, 478.8075277327732, 456.8847974371593, 430.596744628803,
                    387.3756930422962, 372.69118269542514, 366.41921701200494, 338.21439674902, 316.04853568023645, 308.67981340259485, 303.59316507717364, 282.63640623598053,
                    273.7315370686611, 259.8564397215438, 249.27189549930537, 242.61592123961128, 232.19109727680924, 219.24339143987146, 206.99530451668264, 196.3551470184283,
                    180.89039573506014, 169.97662004416708, 157.50028465272615, 148.38109197542317, 138.28479912559771, 133.31459441272062, 127.72698996236034, 128.27849354239635,
                    118.06000399422352, 115.63163076705436, 111.96980397955922, 104.94834580381401, 104.86664524926334, 100.49722918899676, 101.11546051758738, 95.05426907550297,
                    93.36412785516372, 93.06021153755376, 90.78862003636473, 86.60962490373039, 80.46469390493166, 80.4865058943335, 77.02901953248251, 76.5529671905439,
                    73.49607328806566, 71.9914360447838, 72.0207816436951, 69.12753604173426, 69.63731921016243, 64.95076991458161, 64.77879570288232, 55.82836848972288,
                    56.15745128555355, 54.22959168434901, 51.35692674401091, 50.12417470285462, 50.734182919451165, 46.38706816553514, 46.91179316091466,
            },
            {
                    47269.82162542315, 46902.6003882724, 46358.97050889209, 45647.865950659325, 45151.150790504194, 44786.72287078281, 44340.72289876183, 43759.79936198399,
                    43306.38583946996, 42613.735586218005, 42170.42234611583, 41693.607978855645, 41128.73273307313, 40729.84077838252, 40233.502474986155, 39880.45821700446,
                    39504.911888649345, 39126.46589845833, 38553.49354484362, 38006.95468276005, 37648.46926949399, 37143.93048815492, 36575.519215375396, 36285.33416256713,
                    35847.207615602456, 35226.46226322718, 34830.21447993713, 34224.6571271055, 33652.68309023563, 33125.31174488727, 32637.01024607348, 32277.92677240865,
                    31898.27235344247, 31362.52821149658, 30784.781337030206, 30456.446171277556, 30119.69112190991, 29800.320093132872, 29217.3742025355, 28856.089830187608,
                    28368.1786756947, 28021.88697056535, 27655.21966790101, 27321.439843696728, 26883.685581112455, 26332.557790086597, 25923.092561818088, 25713.717526922203,
                    25269.64678387516, 24911.558321270393, 24532.891537442363, 24050.772408378798, 23773.67426548105, 23271.12129378978, 22867.535658991037, 22603.843899667965,
                    22220.124469475842, 21891.178951929956, 21584.829721757153, 21262.82746636443, 20915.872334813233, 20623.71285935738, 20132.983666784003, 19606.979984578014,
                    19365.12954041062, 19005.508994123036, 18548.90306102784, 18245.568179852056, 17770.73584377489, 17400.440391242282, 16950.493724409702, 16662.912493034524,
                    16392.694554127887, 16067.27552673987, 15861.976475234262, 15666.150951127263, 15323.822373261559, 15021.327170656727, 14809.964206456976, 14459.176736864994,
                    14215.09095103244, 14023.551949678174, 13801.912390325633, 13561.759174037106, 13282.157307461264, 13099.120074607828, 12859.99347326185, 12687.451399024467,
                    12441.67510621988, 12145.732861039218, 11802.508401959181, 11445.723621044308, 11265.578691518516, 11064.916239380387, 10792.33209454703, 10479.77401333867,
                    10269.586385833982, 10055.385496594728, 9790.50403331358, 9491.718126101288, 9125.117843859685, 8870.101762512686, 8635.380838180274, 8423.796969947667,
                    8173.683963049304, 7972.100459509185, 7736.171749632659, 7502.9579077860735, 7317.161255126024, 7132.70086610325, 6815.40387325021, 6668.325512866442,
                    6491.285930899597, 6322.0378151379, 6098.13338237373, 5849.053542821054, 5538.8127409398185, 5389.198192485386, 5134.620121824295, 4921.1477933981305,
                    4682.274344532586, 4535.9352158999345, 4396.979855924066, 4224.117207449819, 4103.996336506334, 3983.980016039762, 3754.567773906602, 3635.582884748663,
                    3512.6286537325636, 3345.8196266787577, 3213.6476075685637, 3107.2588721462685, 2932.4447441611433, 2810.2619806164134, 2701.523842989206, 2501.5628119442235,
                    2341.0240757273527, 2132.765134272575, 2016.2542318627998, 1868.0983637635425, 1790.8831589952863, 1666.2163544675855, 1523.6330860977407, 1447.8450538228399,
                    1386.9998838851036, 1280.9149170651249, 1120.8174322503442, 1021.9560967811727, 998.7861395509709, 959.4940584044231, 875.3573077008449, 850.2762582975205,
                    801.7381329026227, 772.5092537748736, 738.1937314754222, 725.1107888347665, 653.3165309215746, 598.2948882923691, 595.3748059565306, 541.0144431035376,
                    504.35351877199486, 491.1036918461248, 433.47108694455824, 433.4791610046075, 421.86174038570255, 421.04222439719535, 402.37320485410197, 398.03076203226186,
                    394.3219120555458, 376.8143436056133, 351.80167340543875, 338.2032753713758, 286.16339052068633, 280.80190333282405, 266.5432449685702, 247.31706970977126,
                    239.13145664947805, 228.7396171852588, 225.35378016533662, 219.15811863383723, 185.815242801434, 163.82900497560766, 147.36478327928046, 136.55125602053604,
                    128.54591888887015, 120.20487610274584, 111.84273719319704, 112.3943710806699, 100.43468237395155, 94.30094258666544, 90.27077495728372, 83.72886824014772,
                    80.1147374793495, 76.83163410341199, 70.81129858975734, 71.6565437811166, 69.42023789273784, 68.4871994654306, 64.98260062038032, 62.02954922536067,
            },
    };
}
