/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.testing;

import com.google.common.annotations.Beta;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.testng.Assert;

@Beta
public final class ValidationAssertions {
    @GuardedBy(value="VALIDATOR")
    private static final Validator VALIDATOR = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).buildValidatorFactory().getValidator();

    private ValidationAssertions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Set<ConstraintViolation<T>> validate(T object) {
        Validator validator = VALIDATOR;
        synchronized (validator) {
            return VALIDATOR.validate(object, new Class[0]);
        }
    }

    public static void assertValidates(Object object) {
        ValidationAssertions.assertValidates(object, null);
    }

    public static void assertValidates(Object object, String message) {
        Assert.assertTrue((boolean)ValidationAssertions.validate(object).isEmpty(), (String)String.format("%sexpected:<%s> to pass validation", ValidationAssertions.toMessageString(message), object));
    }

    public static <T> void assertFailsValidation(T object, String field, String expectedErrorMessage, Class<? extends Annotation> annotation, String message) {
        Set<ConstraintViolation<T>> violations = ValidationAssertions.validate(object);
        for (ConstraintViolation<T> violation : violations) {
            if (!annotation.isInstance(violation.getConstraintDescriptor().getAnnotation()) || !violation.getPropertyPath().toString().equals(field)) continue;
            if (!violation.getMessage().equals(expectedErrorMessage)) {
                Assert.fail((String)String.format("%sexpected %s.%s for <%s> to fail validation for %s with message '%s', but message was '%s'", ValidationAssertions.toMessageString(message), object.getClass().getName(), field, message, annotation.getName(), expectedErrorMessage, violation.getMessage()));
            }
            return;
        }
        Assert.fail((String)String.format("%sexpected %s.%s for <%s> to fail validation for %s with message '%s'", ValidationAssertions.toMessageString(message), object.getClass().getName(), field, object, annotation.getName(), expectedErrorMessage));
    }

    public static <T> void assertFailsValidation(T object, String field, String expectedErrorMessage, Class<? extends Annotation> annotation) {
        ValidationAssertions.assertFailsValidation(object, field, expectedErrorMessage, annotation, null);
    }

    private static String toMessageString(String message) {
        return message == null ? "" : message + " ";
    }
}

