/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.units;

import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.MinDataSize;
import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class MinDataSizeValidator
implements ConstraintValidator<MinDataSize, DataSize> {
    private DataSize min;

    public void initialize(MinDataSize dataSize) {
        try {
            this.min = DataSize.valueOf(dataSize.value());
        }
        catch (IllegalArgumentException e) {
            throw new ConstraintDeclarationException((Throwable)e);
        }
    }

    public boolean isValid(DataSize dataSize, ConstraintValidatorContext context) {
        return dataSize == null || dataSize.compareTo(this.min) >= 0;
    }

    public String toString() {
        return "min:" + this.min;
    }
}

