/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.units;

import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.MaxDataSize;
import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class MaxDataSizeValidator
implements ConstraintValidator<MaxDataSize, DataSize> {
    private DataSize max;

    public void initialize(MaxDataSize dataSize) {
        try {
            this.max = DataSize.valueOf(dataSize.value());
        }
        catch (IllegalArgumentException e) {
            throw new ConstraintDeclarationException((Throwable)e);
        }
    }

    public boolean isValid(DataSize dataSize, ConstraintValidatorContext context) {
        return dataSize == null || dataSize.compareTo(this.max) <= 0;
    }

    public String toString() {
        return "max:" + this.max;
    }
}

