/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.api;

import android.content.Context;
import androidx.annotation.Keep;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.ads.internal.settings.MultithreadedBundleWrapper;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
public class InitSettingsBuilder
implements AudienceNetworkAds.InitSettingsBuilder {
    public static final String PLACEMENTS_KEY = "PLACEMENTS_KEY";
    private final MultithreadedBundleWrapper mInitSettings = new MultithreadedBundleWrapper();
    private final Context mContext;
    private AudienceNetworkAds.InitListener mInitializationListener;

    public InitSettingsBuilder(Context context) {
        this.mContext = context;
    }

    @Override
    public InitSettingsBuilder withPlacementIds(List<String> placementIds) {
        ArrayList<String> placementsIdsArrayList = new ArrayList<String>(placementIds);
        this.mInitSettings.putStringArrayList(PLACEMENTS_KEY, placementsIdsArrayList);
        return this;
    }

    @Override
    public InitSettingsBuilder withMediationService(String mediationService) {
        AdSettings.setMediationService(mediationService);
        return this;
    }

    @Override
    public InitSettingsBuilder withInitListener(AudienceNetworkAds.InitListener initializationListener) {
        this.mInitializationListener = initializationListener;
        return this;
    }

    @Override
    public void initialize() {
        DynamicLoaderFactory.initialize(this.mContext, this.mInitSettings, this.mInitializationListener, false);
    }
}

