/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AppEventsLogger;
import com.facebook.AuthorizationClient;
import com.facebook.FacebookAuthorizationException;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.LoginActivity;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.SessionDefaultAudience;
import com.facebook.SessionLoginBehavior;
import com.facebook.SessionState;
import com.facebook.Settings;
import com.facebook.SharedPreferencesTokenCachingStrategy;
import com.facebook.TokenCachingStrategy;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.SessionAuthorizationType;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphMultiResult;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class Session
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TAG = Session.class.getCanonicalName();
    public static final int DEFAULT_AUTHORIZE_ACTIVITY_CODE = 64206;
    public static final String WEB_VIEW_ERROR_CODE_KEY = "com.facebook.sdk.WebViewErrorCode";
    public static final String WEB_VIEW_FAILING_URL_KEY = "com.facebook.sdk.FailingUrl";
    public static final String ACTION_ACTIVE_SESSION_SET = "com.facebook.sdk.ACTIVE_SESSION_SET";
    public static final String ACTION_ACTIVE_SESSION_UNSET = "com.facebook.sdk.ACTIVE_SESSION_UNSET";
    public static final String ACTION_ACTIVE_SESSION_OPENED = "com.facebook.sdk.ACTIVE_SESSION_OPENED";
    public static final String ACTION_ACTIVE_SESSION_CLOSED = "com.facebook.sdk.ACTIVE_SESSION_CLOSED";
    private static final Object STATIC_LOCK = new Object();
    private static Session activeSession;
    private static volatile Context staticContext;
    private static final int TOKEN_EXTEND_THRESHOLD_SECONDS = 86400;
    private static final int TOKEN_EXTEND_RETRY_SECONDS = 3600;
    private static final String SESSION_BUNDLE_SAVE_KEY = "com.facebook.sdk.Session.saveSessionKey";
    private static final String AUTH_BUNDLE_SAVE_KEY = "com.facebook.sdk.Session.authBundleKey";
    private static final String PUBLISH_PERMISSION_PREFIX = "publish";
    private static final String MANAGE_PERMISSION_PREFIX = "manage";
    private static final Set<String> OTHER_PUBLISH_PERMISSIONS;
    private String applicationId;
    private SessionState state;
    private AccessToken tokenInfo;
    private Date lastAttemptedTokenExtendDate = new Date(0L);
    private AuthorizationRequest pendingAuthorizationRequest;
    private AuthorizationClient authorizationClient;
    private volatile Bundle authorizationBundle;
    private final List<StatusCallback> callbacks;
    private Handler handler;
    private AutoPublishAsyncTask autoPublishAsyncTask;
    private final Object lock = new Object();
    private TokenCachingStrategy tokenCachingStrategy;
    private volatile TokenRefreshRequest currentTokenRefreshRequest;
    private AppEventsLogger appEventsLogger;

    private Session(String applicationId, SessionState state, AccessToken tokenInfo, Date lastAttemptedTokenExtendDate, boolean shouldAutoPublish, AuthorizationRequest pendingAuthorizationRequest) {
        this.applicationId = applicationId;
        this.state = state;
        this.tokenInfo = tokenInfo;
        this.lastAttemptedTokenExtendDate = lastAttemptedTokenExtendDate;
        this.pendingAuthorizationRequest = pendingAuthorizationRequest;
        this.handler = new Handler(Looper.getMainLooper());
        this.currentTokenRefreshRequest = null;
        this.tokenCachingStrategy = null;
        this.callbacks = new ArrayList<StatusCallback>();
    }

    private Session(String applicationId, SessionState state, AccessToken tokenInfo, Date lastAttemptedTokenExtendDate, boolean shouldAutoPublish, AuthorizationRequest pendingAuthorizationRequest, Set<String> requestedPermissions) {
        this.applicationId = applicationId;
        this.state = state;
        this.tokenInfo = tokenInfo;
        this.lastAttemptedTokenExtendDate = lastAttemptedTokenExtendDate;
        this.pendingAuthorizationRequest = pendingAuthorizationRequest;
        this.handler = new Handler(Looper.getMainLooper());
        this.currentTokenRefreshRequest = null;
        this.tokenCachingStrategy = null;
        this.callbacks = new ArrayList<StatusCallback>();
    }

    public Session(Context currentContext) {
        this(currentContext, null, null, true);
    }

    Session(Context context, String applicationId, TokenCachingStrategy tokenCachingStrategy) {
        this(context, applicationId, tokenCachingStrategy, true);
    }

    Session(Context context, String applicationId, TokenCachingStrategy tokenCachingStrategy, boolean loadTokenFromCache) {
        Bundle tokenState;
        if (context != null && applicationId == null) {
            applicationId = Utility.getMetadataApplicationId(context);
        }
        Validate.notNull(applicationId, "applicationId");
        Session.initializeStaticContext(context);
        if (tokenCachingStrategy == null) {
            tokenCachingStrategy = new SharedPreferencesTokenCachingStrategy(staticContext);
        }
        this.applicationId = applicationId;
        this.tokenCachingStrategy = tokenCachingStrategy;
        this.state = SessionState.CREATED;
        this.pendingAuthorizationRequest = null;
        this.callbacks = new ArrayList<StatusCallback>();
        this.handler = new Handler(Looper.getMainLooper());
        Bundle bundle = tokenState = loadTokenFromCache ? tokenCachingStrategy.load() : null;
        if (TokenCachingStrategy.hasTokenInformation(tokenState)) {
            Date cachedExpirationDate = TokenCachingStrategy.getDate(tokenState, "com.facebook.TokenCachingStrategy.ExpirationDate");
            Date now = new Date();
            if (cachedExpirationDate == null || cachedExpirationDate.before(now)) {
                tokenCachingStrategy.clear();
                this.tokenInfo = AccessToken.createEmptyToken();
            } else {
                this.tokenInfo = AccessToken.createFromCache(tokenState);
                this.state = SessionState.CREATED_TOKEN_LOADED;
            }
        } else {
            this.tokenInfo = AccessToken.createEmptyToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Bundle getAuthorizationBundle() {
        Object object = this.lock;
        synchronized (object) {
            return this.authorizationBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpened() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.isOpened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.isClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SessionState getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    public final String getApplicationId() {
        return this.applicationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getAccessToken() {
        Object object = this.lock;
        synchronized (object) {
            return this.tokenInfo == null ? null : this.tokenInfo.getToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Date getExpirationDate() {
        Object object = this.lock;
        synchronized (object) {
            return this.tokenInfo == null ? null : this.tokenInfo.getExpires();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getPermissions() {
        Object object = this.lock;
        synchronized (object) {
            return this.tokenInfo == null ? null : this.tokenInfo.getPermissions();
        }
    }

    public boolean isPermissionGranted(String permission) {
        List<String> grantedPermissions = this.getPermissions();
        if (grantedPermissions != null) {
            return grantedPermissions.contains(permission);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getDeclinedPermissions() {
        Object object = this.lock;
        synchronized (object) {
            return this.tokenInfo == null ? null : this.tokenInfo.getDeclinedPermissions();
        }
    }

    public final void openForRead(OpenRequest openRequest) {
        this.open(openRequest, SessionAuthorizationType.READ);
    }

    public final void openForPublish(OpenRequest openRequest) {
        this.open(openRequest, SessionAuthorizationType.PUBLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(AccessToken accessToken, StatusCallback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingAuthorizationRequest != null) {
                throw new UnsupportedOperationException("Session: an attempt was made to open a session that has a pending request.");
            }
            if (this.state.isClosed()) {
                throw new UnsupportedOperationException("Session: an attempt was made to open a previously-closed session.");
            }
            if (this.state != SessionState.CREATED && this.state != SessionState.CREATED_TOKEN_LOADED) {
                throw new UnsupportedOperationException("Session: an attempt was made to open an already opened session.");
            }
            if (callback != null) {
                this.addCallback(callback);
            }
            this.tokenInfo = accessToken;
            if (this.tokenCachingStrategy != null) {
                this.tokenCachingStrategy.save(accessToken.toCacheBundle());
            }
            SessionState oldState = this.state;
            this.state = SessionState.OPENED;
            this.postStateChange(oldState, this.state, null);
        }
        this.autoPublishAsync();
    }

    public final void requestNewReadPermissions(NewPermissionsRequest newPermissionsRequest) {
        this.requestNewPermissions(newPermissionsRequest, SessionAuthorizationType.READ);
    }

    public final void requestNewPublishPermissions(NewPermissionsRequest newPermissionsRequest) {
        this.requestNewPermissions(newPermissionsRequest, SessionAuthorizationType.PUBLISH);
    }

    public final void refreshPermissions() {
        Request request = new Request(this, "me/permissions");
        request.setCallback(new Request.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(Response response) {
                PermissionsPair permissionsPair = Session.handlePermissionResponse(response);
                if (permissionsPair != null) {
                    Object object = Session.this.lock;
                    synchronized (object) {
                        Session.this.tokenInfo = AccessToken.createFromTokenWithRefreshedPermissions(Session.this.tokenInfo, permissionsPair.getGrantedPermissions(), permissionsPair.getDeclinedPermissions());
                        Session.this.postStateChange(Session.this.state, SessionState.OPENED_TOKEN_UPDATED, null);
                    }
                }
            }
        });
        request.executeAsync();
    }

    static PermissionsPair handlePermissionResponse(Response response) {
        if (response.getError() != null) {
            return null;
        }
        GraphMultiResult result = response.getGraphObjectAs(GraphMultiResult.class);
        if (result == null) {
            return null;
        }
        GraphObjectList<GraphObject> data = result.getData();
        if (data == null || data.size() == 0) {
            return null;
        }
        ArrayList<String> grantedPermissions = new ArrayList<String>(data.size());
        ArrayList<String> declinedPermissions = new ArrayList<String>(data.size());
        GraphObject firstObject = (GraphObject)data.get(0);
        if (firstObject.getProperty("permission") != null) {
            for (GraphObject graphObject : data) {
                String permission = (String)graphObject.getProperty("permission");
                if (permission.equals("installed")) continue;
                String status = (String)graphObject.getProperty("status");
                if (status.equals("granted")) {
                    grantedPermissions.add(permission);
                    continue;
                }
                if (!status.equals("declined")) continue;
                declinedPermissions.add(permission);
            }
        } else {
            Map<String, Object> permissionsMap = firstObject.asMap();
            for (Map.Entry<String, Object> entry : permissionsMap.entrySet()) {
                if (entry.getKey().equals("installed") || (Integer)entry.getValue() != 1) continue;
                grantedPermissions.add(entry.getKey());
            }
        }
        return new PermissionsPair(grantedPermissions, declinedPermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onActivityResult(Activity currentActivity, int requestCode, int resultCode, Intent data) {
        Validate.notNull(currentActivity, "currentActivity");
        Session.initializeStaticContext((Context)currentActivity);
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingAuthorizationRequest == null || requestCode != this.pendingAuthorizationRequest.getRequestCode()) {
                return false;
            }
        }
        FacebookException exception = null;
        AuthorizationClient.Result.Code code = AuthorizationClient.Result.Code.ERROR;
        if (data != null) {
            AuthorizationClient.Result result = (AuthorizationClient.Result)data.getSerializableExtra("com.facebook.LoginActivity:Result");
            if (result != null) {
                this.handleAuthorizationResult(resultCode, result);
                return true;
            }
            if (this.authorizationClient != null) {
                this.authorizationClient.onActivityResult(requestCode, resultCode, data);
                return true;
            }
        } else if (resultCode == 0) {
            exception = new FacebookOperationCanceledException("User canceled operation.");
            code = AuthorizationClient.Result.Code.CANCEL;
        }
        if (exception == null) {
            exception = new FacebookException("Unexpected call to Session.onActivityResult");
        }
        this.logAuthorizationComplete(code, null, exception);
        this.finishAuthOrReauth(null, exception);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Object object = this.lock;
        synchronized (object) {
            SessionState oldState = this.state;
            switch (this.state) {
                case CREATED: 
                case OPENING: {
                    this.state = SessionState.CLOSED_LOGIN_FAILED;
                    this.postStateChange(oldState, this.state, new FacebookException("Log in attempt aborted."));
                    break;
                }
                case CREATED_TOKEN_LOADED: 
                case OPENED: 
                case OPENED_TOKEN_UPDATED: {
                    this.state = SessionState.CLOSED;
                    this.postStateChange(oldState, this.state, null);
                    break;
                }
            }
        }
    }

    public final void closeAndClearTokenInformation() {
        if (this.tokenCachingStrategy != null) {
            this.tokenCachingStrategy.clear();
        }
        Utility.clearFacebookCookies(staticContext);
        Utility.clearCaches(staticContext);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCallback(StatusCallback callback) {
        List<StatusCallback> list = this.callbacks;
        synchronized (list) {
            if (callback != null && !this.callbacks.contains(callback)) {
                this.callbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCallback(StatusCallback callback) {
        List<StatusCallback> list = this.callbacks;
        synchronized (list) {
            this.callbacks.remove(callback);
        }
    }

    public String toString() {
        return "{Session" + " state:" + (Object)((Object)this.state) + ", token:" + (this.tokenInfo == null ? "null" : this.tokenInfo) + ", appId:" + (this.applicationId == null ? "null" : this.applicationId) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extendTokenCompleted(Bundle bundle) {
        Object object = this.lock;
        synchronized (object) {
            SessionState oldState = this.state;
            switch (this.state) {
                case OPENED: {
                    this.state = SessionState.OPENED_TOKEN_UPDATED;
                    this.postStateChange(oldState, this.state, null);
                    break;
                }
                case OPENED_TOKEN_UPDATED: {
                    break;
                }
                default: {
                    Log.d((String)TAG, (String)("refreshToken ignored in state " + (Object)((Object)this.state)));
                    return;
                }
            }
            this.tokenInfo = AccessToken.createFromRefresh(this.tokenInfo, bundle);
            if (this.tokenCachingStrategy != null) {
                this.tokenCachingStrategy.save(this.tokenInfo.toCacheBundle());
            }
        }
    }

    private Object writeReplace() {
        return new SerializationProxyV1(this.applicationId, this.state, this.tokenInfo, this.lastAttemptedTokenExtendDate, false, this.pendingAuthorizationRequest);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Cannot readObject, serialization proxy required");
    }

    public static final void saveSession(Session session, Bundle bundle) {
        if (bundle != null && session != null && !bundle.containsKey(SESSION_BUNDLE_SAVE_KEY)) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                new ObjectOutputStream(outputStream).writeObject(session);
            }
            catch (IOException e) {
                throw new FacebookException("Unable to save session.", e);
            }
            bundle.putByteArray(SESSION_BUNDLE_SAVE_KEY, outputStream.toByteArray());
            bundle.putBundle(AUTH_BUNDLE_SAVE_KEY, session.authorizationBundle);
        }
    }

    public static final Session restoreSession(Context context, TokenCachingStrategy cachingStrategy, StatusCallback callback, Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        byte[] data = bundle.getByteArray(SESSION_BUNDLE_SAVE_KEY);
        if (data != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            try {
                Session session = (Session)new ObjectInputStream(is).readObject();
                Session.initializeStaticContext(context);
                session.tokenCachingStrategy = cachingStrategy != null ? cachingStrategy : new SharedPreferencesTokenCachingStrategy(context);
                if (callback != null) {
                    session.addCallback(callback);
                }
                session.authorizationBundle = bundle.getBundle(AUTH_BUNDLE_SAVE_KEY);
                return session;
            }
            catch (ClassNotFoundException e) {
                Log.w((String)TAG, (String)"Unable to restore session", (Throwable)e);
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Unable to restore session.", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Session getActiveSession() {
        Object object = STATIC_LOCK;
        synchronized (object) {
            return activeSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setActiveSession(Session session) {
        Object object = STATIC_LOCK;
        synchronized (object) {
            if (session != activeSession) {
                Session oldSession = activeSession;
                if (oldSession != null) {
                    oldSession.close();
                }
                activeSession = session;
                if (oldSession != null) {
                    Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_UNSET);
                }
                if (session != null) {
                    Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_SET);
                    if (session.isOpened()) {
                        Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_OPENED);
                    }
                }
            }
        }
    }

    public static Session openActiveSessionFromCache(Context context) {
        return Session.openActiveSession(context, false, null);
    }

    public static Session openActiveSession(Activity activity, boolean allowLoginUI, StatusCallback callback) {
        return Session.openActiveSession((Context)activity, allowLoginUI, new OpenRequest(activity).setCallback(callback));
    }

    public static Session openActiveSession(Activity activity, boolean allowLoginUI, List<String> permissions, StatusCallback callback) {
        return Session.openActiveSession((Context)activity, allowLoginUI, (OpenRequest)new OpenRequest(activity).setCallback(callback).setPermissions((List)permissions));
    }

    public static Session openActiveSession(Context context, Fragment fragment, boolean allowLoginUI, StatusCallback callback) {
        return Session.openActiveSession(context, allowLoginUI, new OpenRequest(fragment).setCallback(callback));
    }

    public static Session openActiveSession(Context context, Fragment fragment, boolean allowLoginUI, List<String> permissions, StatusCallback callback) {
        return Session.openActiveSession(context, allowLoginUI, (OpenRequest)new OpenRequest(fragment).setCallback(callback).setPermissions((List)permissions));
    }

    public static Session openActiveSessionWithAccessToken(Context context, AccessToken accessToken, StatusCallback callback) {
        Session session = new Session(context, null, null, false);
        Session.setActiveSession(session);
        session.open(accessToken, callback);
        return session;
    }

    private static Session openActiveSession(Context context, boolean allowLoginUI, OpenRequest openRequest) {
        Session session = new Builder(context).build();
        if (SessionState.CREATED_TOKEN_LOADED.equals((Object)session.getState()) || allowLoginUI) {
            Session.setActiveSession(session);
            session.openForRead(openRequest);
            return session;
        }
        return null;
    }

    static Context getStaticContext() {
        return staticContext;
    }

    static void initializeStaticContext(Context currentContext) {
        if (currentContext != null && staticContext == null) {
            Context applicationContext = currentContext.getApplicationContext();
            staticContext = applicationContext != null ? applicationContext : currentContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authorize(AuthorizationRequest request) {
        boolean started = false;
        request.setApplicationId(this.applicationId);
        this.autoPublishAsync();
        this.logAuthorizationStart();
        started = this.tryLoginActivity(request);
        this.pendingAuthorizationRequest.loggingExtras.put("try_login_activity", started ? "1" : "0");
        if (!started && request.isLegacy) {
            this.pendingAuthorizationRequest.loggingExtras.put("try_legacy", "1");
            this.tryLegacyAuth(request);
            started = true;
        }
        if (!started) {
            Object object = this.lock;
            synchronized (object) {
                SessionState oldState = this.state;
                switch (this.state) {
                    case CLOSED: 
                    case CLOSED_LOGIN_FAILED: {
                        return;
                    }
                }
                this.state = SessionState.CLOSED_LOGIN_FAILED;
                FacebookException exception = new FacebookException("Log in attempt failed: LoginActivity could not be started, and not legacy request");
                this.logAuthorizationComplete(AuthorizationClient.Result.Code.ERROR, null, exception);
                this.postStateChange(oldState, this.state, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(OpenRequest openRequest, SessionAuthorizationType authType) {
        SessionState newState;
        this.validatePermissions(openRequest, authType);
        this.validateLoginBehavior(openRequest);
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingAuthorizationRequest != null) {
                this.postStateChange(this.state, this.state, new UnsupportedOperationException("Session: an attempt was made to open a session that has a pending request."));
                return;
            }
            SessionState oldState = this.state;
            switch (this.state) {
                case CREATED: {
                    this.state = newState = SessionState.OPENING;
                    if (openRequest == null) {
                        throw new IllegalArgumentException("openRequest cannot be null when opening a new Session");
                    }
                    this.pendingAuthorizationRequest = openRequest;
                    break;
                }
                case CREATED_TOKEN_LOADED: {
                    if (openRequest != null && !Utility.isNullOrEmpty(openRequest.getPermissions()) && !Utility.isSubset(openRequest.getPermissions(), this.getPermissions())) {
                        this.pendingAuthorizationRequest = openRequest;
                    }
                    if (this.pendingAuthorizationRequest == null) {
                        this.state = newState = SessionState.OPENED;
                        break;
                    }
                    this.state = newState = SessionState.OPENING;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Session: an attempt was made to open an already opened session.");
                }
            }
            if (openRequest != null) {
                this.addCallback(openRequest.getCallback());
            }
            this.postStateChange(oldState, newState, null);
        }
        if (newState == SessionState.OPENING) {
            this.authorize(openRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestNewPermissions(NewPermissionsRequest newPermissionsRequest, SessionAuthorizationType authType) {
        this.validatePermissions(newPermissionsRequest, authType);
        this.validateLoginBehavior(newPermissionsRequest);
        if (newPermissionsRequest != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.pendingAuthorizationRequest != null) {
                    throw new UnsupportedOperationException("Session: an attempt was made to request new permissions for a session that has a pending request.");
                }
                if (!this.state.isOpened()) {
                    if (this.state.isClosed()) {
                        throw new UnsupportedOperationException("Session: an attempt was made to request new permissions for a session that has been closed.");
                    }
                    throw new UnsupportedOperationException("Session: an attempt was made to request new permissions for a session that is not currently open.");
                }
                this.pendingAuthorizationRequest = newPermissionsRequest;
            }
            newPermissionsRequest.setValidateSameFbidAsToken(this.getAccessToken());
            this.addCallback(newPermissionsRequest.getCallback());
            this.authorize(newPermissionsRequest);
        }
    }

    private void validateLoginBehavior(AuthorizationRequest request) {
        if (request != null && !request.isLegacy) {
            Intent intent = new Intent();
            intent.setClass(Session.getStaticContext(), LoginActivity.class);
            if (!this.resolveIntent(intent)) {
                throw new FacebookException(String.format("Cannot use SessionLoginBehavior %s when %s is not declared as an activity in AndroidManifest.xml", new Object[]{request.getLoginBehavior(), LoginActivity.class.getName()}));
            }
        }
    }

    private void validatePermissions(AuthorizationRequest request, SessionAuthorizationType authType) {
        if (request == null || Utility.isNullOrEmpty(request.getPermissions())) {
            if (SessionAuthorizationType.PUBLISH.equals((Object)authType)) {
                throw new FacebookException("Cannot request publish or manage authorization with no permissions.");
            }
            return;
        }
        for (String permission : request.getPermissions()) {
            if (Session.isPublishPermission(permission)) {
                if (!SessionAuthorizationType.READ.equals((Object)authType)) continue;
                throw new FacebookException(String.format("Cannot pass a publish or manage permission (%s) to a request for read authorization", permission));
            }
            if (!SessionAuthorizationType.PUBLISH.equals((Object)authType)) continue;
            Log.w((String)TAG, (String)String.format("Should not pass a read permission (%s) to a request for publish or manage authorization", permission));
        }
    }

    public static boolean isPublishPermission(String permission) {
        return permission != null && (permission.startsWith(PUBLISH_PERMISSION_PREFIX) || permission.startsWith(MANAGE_PERMISSION_PREFIX) || OTHER_PUBLISH_PERMISSIONS.contains(permission));
    }

    private void handleAuthorizationResult(int resultCode, AuthorizationClient.Result result) {
        AccessToken newToken = null;
        FacebookException exception = null;
        if (resultCode == -1) {
            if (result.code == AuthorizationClient.Result.Code.SUCCESS) {
                newToken = result.token;
            } else {
                exception = new FacebookAuthorizationException(result.errorMessage);
            }
        } else if (resultCode == 0) {
            exception = new FacebookOperationCanceledException(result.errorMessage);
        }
        this.logAuthorizationComplete(result.code, result.loggingExtras, exception);
        this.authorizationClient = null;
        this.finishAuthOrReauth(newToken, exception);
    }

    private void logAuthorizationStart() {
        Bundle bundle = AuthorizationClient.newAuthorizationLoggingBundle(this.pendingAuthorizationRequest.getAuthId());
        bundle.putLong("1_timestamp_ms", System.currentTimeMillis());
        try {
            JSONObject extras = new JSONObject();
            extras.put("login_behavior", (Object)this.pendingAuthorizationRequest.loginBehavior.toString());
            extras.put("request_code", this.pendingAuthorizationRequest.requestCode);
            extras.put("is_legacy", this.pendingAuthorizationRequest.isLegacy);
            extras.put("permissions", (Object)TextUtils.join((CharSequence)",", (Iterable)this.pendingAuthorizationRequest.permissions));
            extras.put("default_audience", (Object)this.pendingAuthorizationRequest.defaultAudience.toString());
            bundle.putString("6_extras", extras.toString());
        }
        catch (JSONException e) {
            // empty catch block
        }
        AppEventsLogger logger = this.getAppEventsLogger();
        logger.logSdkEvent("fb_mobile_login_start", null, bundle);
    }

    private void logAuthorizationComplete(AuthorizationClient.Result.Code result, Map<String, String> resultExtras, Exception exception) {
        Bundle bundle = null;
        if (this.pendingAuthorizationRequest == null) {
            bundle = AuthorizationClient.newAuthorizationLoggingBundle("");
            bundle.putString("2_result", AuthorizationClient.Result.Code.ERROR.getLoggingValue());
            bundle.putString("5_error_message", "Unexpected call to logAuthorizationComplete with null pendingAuthorizationRequest.");
        } else {
            bundle = AuthorizationClient.newAuthorizationLoggingBundle(this.pendingAuthorizationRequest.getAuthId());
            if (result != null) {
                bundle.putString("2_result", result.getLoggingValue());
            }
            if (exception != null && exception.getMessage() != null) {
                bundle.putString("5_error_message", exception.getMessage());
            }
            JSONObject jsonObject = null;
            if (!this.pendingAuthorizationRequest.loggingExtras.isEmpty()) {
                jsonObject = new JSONObject(this.pendingAuthorizationRequest.loggingExtras);
            }
            if (resultExtras != null) {
                if (jsonObject == null) {
                    jsonObject = new JSONObject();
                }
                try {
                    for (Map.Entry<String, String> entry : resultExtras.entrySet()) {
                        jsonObject.put(entry.getKey(), (Object)entry.getValue());
                    }
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
            if (jsonObject != null) {
                bundle.putString("6_extras", jsonObject.toString());
            }
        }
        bundle.putLong("1_timestamp_ms", System.currentTimeMillis());
        AppEventsLogger logger = this.getAppEventsLogger();
        logger.logSdkEvent("fb_mobile_login_complete", null, bundle);
    }

    private boolean tryLoginActivity(AuthorizationRequest request) {
        Intent intent = this.getLoginActivityIntent(request);
        if (!this.resolveIntent(intent)) {
            return false;
        }
        try {
            request.getStartActivityDelegate().startActivityForResult(intent, request.getRequestCode());
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    private boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = Session.getStaticContext().getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    private Intent getLoginActivityIntent(AuthorizationRequest request) {
        Intent intent = new Intent();
        intent.setClass(Session.getStaticContext(), LoginActivity.class);
        intent.setAction(request.getLoginBehavior().toString());
        AuthorizationClient.AuthorizationRequest authClientRequest = request.getAuthorizationClientRequest();
        Bundle extras = LoginActivity.populateIntentExtras(authClientRequest);
        intent.putExtras(extras);
        return intent;
    }

    private void tryLegacyAuth(AuthorizationRequest request) {
        this.authorizationClient = new AuthorizationClient();
        this.authorizationClient.setOnCompletedListener(new AuthorizationClient.OnCompletedListener(){

            @Override
            public void onCompleted(AuthorizationClient.Result result) {
                int activityResult = result.code == AuthorizationClient.Result.Code.CANCEL ? 0 : -1;
                Session.this.handleAuthorizationResult(activityResult, result);
            }
        });
        this.authorizationClient.setContext(Session.getStaticContext());
        this.authorizationClient.startOrContinueAuth(request.getAuthorizationClientRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishAuthOrReauth(AccessToken newToken, Exception exception) {
        if (newToken != null && newToken.isInvalid()) {
            newToken = null;
            exception = new FacebookException("Invalid access token.");
        }
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case OPENING: {
                    this.finishAuthorization(newToken, exception);
                    break;
                }
                case OPENED: 
                case OPENED_TOKEN_UPDATED: {
                    this.finishReauthorization(newToken, exception);
                    break;
                }
                case CREATED: 
                case CREATED_TOKEN_LOADED: 
                case CLOSED: 
                case CLOSED_LOGIN_FAILED: {
                    Log.d((String)TAG, (String)("Unexpected call to finishAuthOrReauth in state " + (Object)((Object)this.state)));
                }
            }
        }
    }

    private void finishAuthorization(AccessToken newToken, Exception exception) {
        SessionState oldState = this.state;
        if (newToken != null) {
            this.tokenInfo = newToken;
            this.saveTokenToCache(newToken);
            this.state = SessionState.OPENED;
        } else if (exception != null) {
            this.state = SessionState.CLOSED_LOGIN_FAILED;
        }
        this.pendingAuthorizationRequest = null;
        this.postStateChange(oldState, this.state, exception);
    }

    private void finishReauthorization(AccessToken newToken, Exception exception) {
        SessionState oldState = this.state;
        if (newToken != null) {
            this.tokenInfo = newToken;
            this.saveTokenToCache(newToken);
            this.state = SessionState.OPENED_TOKEN_UPDATED;
        }
        this.pendingAuthorizationRequest = null;
        this.postStateChange(oldState, this.state, exception);
    }

    private void saveTokenToCache(AccessToken newToken) {
        if (newToken != null && this.tokenCachingStrategy != null) {
            this.tokenCachingStrategy.save(newToken.toCacheBundle());
        }
    }

    void postStateChange(SessionState oldState, final SessionState newState, final Exception exception) {
        if (oldState == newState && oldState != SessionState.OPENED_TOKEN_UPDATED && exception == null) {
            return;
        }
        if (newState.isClosed()) {
            this.tokenInfo = AccessToken.createEmptyToken();
        }
        Runnable runCallbacks = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = Session.this.callbacks;
                synchronized (list) {
                    for (final StatusCallback callback : Session.this.callbacks) {
                        Runnable closure = new Runnable(){

                            @Override
                            public void run() {
                                callback.call(Session.this, newState, exception);
                            }
                        };
                        Session.runWithHandlerOrExecutor(Session.this.handler, closure);
                    }
                }
            }
        };
        Session.runWithHandlerOrExecutor(this.handler, runCallbacks);
        if (this == activeSession && oldState.isOpened() != newState.isOpened()) {
            if (newState.isOpened()) {
                Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_OPENED);
            } else {
                Session.postActiveSessionAction(ACTION_ACTIVE_SESSION_CLOSED);
            }
        }
    }

    static void postActiveSessionAction(String action) {
        Intent intent = new Intent(action);
        LocalBroadcastManager.getInstance((Context)Session.getStaticContext()).sendBroadcast(intent);
    }

    private static void runWithHandlerOrExecutor(Handler handler, Runnable runnable) {
        if (handler != null) {
            handler.post(runnable);
        } else {
            Settings.getExecutor().execute(runnable);
        }
    }

    void extendAccessTokenIfNeeded() {
        if (this.shouldExtendAccessToken()) {
            this.extendAccessToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extendAccessToken() {
        TokenRefreshRequest newTokenRefreshRequest = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.currentTokenRefreshRequest == null) {
                this.currentTokenRefreshRequest = newTokenRefreshRequest = new TokenRefreshRequest();
            }
        }
        if (newTokenRefreshRequest != null) {
            newTokenRefreshRequest.bind();
        }
    }

    boolean shouldExtendAccessToken() {
        if (this.currentTokenRefreshRequest != null) {
            return false;
        }
        boolean result = false;
        Date now = new Date();
        if (this.state.isOpened() && this.tokenInfo.getSource().canExtendToken() && now.getTime() - this.lastAttemptedTokenExtendDate.getTime() > 3600000L && now.getTime() - this.tokenInfo.getLastRefresh().getTime() > 86400000L) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppEventsLogger getAppEventsLogger() {
        Object object = this.lock;
        synchronized (object) {
            if (this.appEventsLogger == null) {
                this.appEventsLogger = AppEventsLogger.newLogger(staticContext, this.applicationId);
            }
            return this.appEventsLogger;
        }
    }

    AccessToken getTokenInfo() {
        return this.tokenInfo;
    }

    void setTokenInfo(AccessToken tokenInfo) {
        this.tokenInfo = tokenInfo;
    }

    Date getLastAttemptedTokenExtendDate() {
        return this.lastAttemptedTokenExtendDate;
    }

    void setLastAttemptedTokenExtendDate(Date lastAttemptedTokenExtendDate) {
        this.lastAttemptedTokenExtendDate = lastAttemptedTokenExtendDate;
    }

    void setCurrentTokenRefreshRequest(TokenRefreshRequest request) {
        this.currentTokenRefreshRequest = request;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof Session)) {
            return false;
        }
        Session other = (Session)otherObj;
        return Session.areEqual(other.applicationId, this.applicationId) && Session.areEqual(other.authorizationBundle, this.authorizationBundle) && Session.areEqual((Object)other.state, (Object)this.state) && Session.areEqual(other.getExpirationDate(), this.getExpirationDate());
    }

    private static boolean areEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoPublishAsync() {
        AutoPublishAsyncTask asyncTask = null;
        Session session = this;
        synchronized (session) {
            String applicationId;
            if (this.autoPublishAsyncTask == null && Settings.getShouldAutoPublishInstall() && (applicationId = this.applicationId) != null) {
                asyncTask = this.autoPublishAsyncTask = new AutoPublishAsyncTask(applicationId, staticContext);
            }
        }
        if (asyncTask != null) {
            asyncTask.execute(new Void[0]);
        }
    }

    static {
        OTHER_PUBLISH_PERMISSIONS = new HashSet<String>(){
            {
                this.add("ads_management");
                this.add("create_event");
                this.add("rsvp_event");
            }
        };
    }

    public static final class NewPermissionsRequest
    extends AuthorizationRequest {
        private static final long serialVersionUID = 1L;

        public NewPermissionsRequest(Activity activity, List<String> permissions) {
            super(activity);
            this.setPermissions(permissions);
        }

        public NewPermissionsRequest(Fragment fragment, List<String> permissions) {
            super(fragment);
            this.setPermissions(permissions);
        }

        public NewPermissionsRequest(Activity activity, String ... permissions) {
            super(activity);
            this.setPermissions(permissions);
        }

        public NewPermissionsRequest(Fragment fragment, String ... permissions) {
            super(fragment);
            this.setPermissions(permissions);
        }

        @Override
        public final NewPermissionsRequest setCallback(StatusCallback statusCallback) {
            super.setCallback(statusCallback);
            return this;
        }

        @Override
        public final NewPermissionsRequest setLoginBehavior(SessionLoginBehavior loginBehavior) {
            super.setLoginBehavior(loginBehavior);
            return this;
        }

        @Override
        public final NewPermissionsRequest setRequestCode(int requestCode) {
            super.setRequestCode(requestCode);
            return this;
        }

        @Override
        public final NewPermissionsRequest setDefaultAudience(SessionDefaultAudience defaultAudience) {
            super.setDefaultAudience(defaultAudience);
            return this;
        }

        @Override
        AuthorizationClient.AuthorizationRequest getAuthorizationClientRequest() {
            AuthorizationClient.AuthorizationRequest request = super.getAuthorizationClientRequest();
            request.setRerequest(true);
            return request;
        }
    }

    public static final class OpenRequest
    extends AuthorizationRequest {
        private static final long serialVersionUID = 1L;

        public OpenRequest(Activity activity) {
            super(activity);
        }

        public OpenRequest(Fragment fragment) {
            super(fragment);
        }

        @Override
        public final OpenRequest setCallback(StatusCallback statusCallback) {
            super.setCallback(statusCallback);
            return this;
        }

        @Override
        public final OpenRequest setLoginBehavior(SessionLoginBehavior loginBehavior) {
            super.setLoginBehavior(loginBehavior);
            return this;
        }

        @Override
        public final OpenRequest setRequestCode(int requestCode) {
            super.setRequestCode(requestCode);
            return this;
        }

        @Override
        public final OpenRequest setPermissions(List<String> permissions) {
            super.setPermissions(permissions);
            return this;
        }

        @Override
        public final OpenRequest setPermissions(String ... permissions) {
            super.setPermissions(permissions);
            return this;
        }

        @Override
        public final OpenRequest setDefaultAudience(SessionDefaultAudience defaultAudience) {
            super.setDefaultAudience(defaultAudience);
            return this;
        }
    }

    public static class AuthorizationRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final StartActivityDelegate startActivityDelegate;
        private SessionLoginBehavior loginBehavior = SessionLoginBehavior.SSO_WITH_FALLBACK;
        private int requestCode = 64206;
        private StatusCallback statusCallback;
        private boolean isLegacy = false;
        private List<String> permissions = Collections.emptyList();
        private SessionDefaultAudience defaultAudience = SessionDefaultAudience.FRIENDS;
        private String applicationId;
        private String validateSameFbidAsToken;
        private final String authId = UUID.randomUUID().toString();
        private final Map<String, String> loggingExtras = new HashMap<String, String>();

        AuthorizationRequest(final Activity activity) {
            this.startActivityDelegate = new StartActivityDelegate(){

                @Override
                public void startActivityForResult(Intent intent, int requestCode) {
                    activity.startActivityForResult(intent, requestCode);
                }

                @Override
                public Activity getActivityContext() {
                    return activity;
                }
            };
        }

        AuthorizationRequest(final Fragment fragment) {
            this.startActivityDelegate = new StartActivityDelegate(){

                @Override
                public void startActivityForResult(Intent intent, int requestCode) {
                    fragment.startActivityForResult(intent, requestCode);
                }

                @Override
                public Activity getActivityContext() {
                    return fragment.getActivity();
                }
            };
        }

        private AuthorizationRequest(SessionLoginBehavior loginBehavior, int requestCode, List<String> permissions, String defaultAudience, boolean isLegacy, String applicationId, String validateSameFbidAsToken) {
            this.startActivityDelegate = new StartActivityDelegate(){

                @Override
                public void startActivityForResult(Intent intent, int requestCode) {
                    throw new UnsupportedOperationException("Cannot create an AuthorizationRequest without a valid Activity or Fragment");
                }

                @Override
                public Activity getActivityContext() {
                    throw new UnsupportedOperationException("Cannot create an AuthorizationRequest without a valid Activity or Fragment");
                }
            };
            this.loginBehavior = loginBehavior;
            this.requestCode = requestCode;
            this.permissions = permissions;
            this.defaultAudience = SessionDefaultAudience.valueOf(defaultAudience);
            this.isLegacy = isLegacy;
            this.applicationId = applicationId;
            this.validateSameFbidAsToken = validateSameFbidAsToken;
        }

        public void setIsLegacy(boolean isLegacy) {
            this.isLegacy = isLegacy;
        }

        boolean isLegacy() {
            return this.isLegacy;
        }

        AuthorizationRequest setCallback(StatusCallback statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        StatusCallback getCallback() {
            return this.statusCallback;
        }

        AuthorizationRequest setLoginBehavior(SessionLoginBehavior loginBehavior) {
            if (loginBehavior != null) {
                this.loginBehavior = loginBehavior;
            }
            return this;
        }

        SessionLoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        AuthorizationRequest setRequestCode(int requestCode) {
            if (requestCode >= 0) {
                this.requestCode = requestCode;
            }
            return this;
        }

        int getRequestCode() {
            return this.requestCode;
        }

        AuthorizationRequest setPermissions(List<String> permissions) {
            if (permissions != null) {
                this.permissions = permissions;
            }
            return this;
        }

        AuthorizationRequest setPermissions(String ... permissions) {
            return this.setPermissions(Arrays.asList(permissions));
        }

        List<String> getPermissions() {
            return this.permissions;
        }

        AuthorizationRequest setDefaultAudience(SessionDefaultAudience defaultAudience) {
            if (defaultAudience != null) {
                this.defaultAudience = defaultAudience;
            }
            return this;
        }

        SessionDefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        StartActivityDelegate getStartActivityDelegate() {
            return this.startActivityDelegate;
        }

        String getApplicationId() {
            return this.applicationId;
        }

        void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        String getValidateSameFbidAsToken() {
            return this.validateSameFbidAsToken;
        }

        void setValidateSameFbidAsToken(String validateSameFbidAsToken) {
            this.validateSameFbidAsToken = validateSameFbidAsToken;
        }

        String getAuthId() {
            return this.authId;
        }

        AuthorizationClient.AuthorizationRequest getAuthorizationClientRequest() {
            AuthorizationClient.StartActivityDelegate delegate = new AuthorizationClient.StartActivityDelegate(){

                @Override
                public void startActivityForResult(Intent intent, int requestCode) {
                    AuthorizationRequest.this.startActivityDelegate.startActivityForResult(intent, requestCode);
                }

                @Override
                public Activity getActivityContext() {
                    return AuthorizationRequest.this.startActivityDelegate.getActivityContext();
                }
            };
            return new AuthorizationClient.AuthorizationRequest(this.loginBehavior, this.requestCode, this.isLegacy, this.permissions, this.defaultAudience, this.applicationId, this.validateSameFbidAsToken, delegate, this.authId);
        }

        Object writeReplace() {
            return new AuthRequestSerializationProxyV1(this.loginBehavior, this.requestCode, this.permissions, this.defaultAudience.name(), this.isLegacy, this.applicationId, this.validateSameFbidAsToken);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Cannot readObject, serialization proxy required");
        }

        private static class AuthRequestSerializationProxyV1
        implements Serializable {
            private static final long serialVersionUID = -8748347685113614927L;
            private final SessionLoginBehavior loginBehavior;
            private final int requestCode;
            private boolean isLegacy;
            private final List<String> permissions;
            private final String defaultAudience;
            private final String applicationId;
            private final String validateSameFbidAsToken;

            private AuthRequestSerializationProxyV1(SessionLoginBehavior loginBehavior, int requestCode, List<String> permissions, String defaultAudience, boolean isLegacy, String applicationId, String validateSameFbidAsToken) {
                this.loginBehavior = loginBehavior;
                this.requestCode = requestCode;
                this.permissions = permissions;
                this.defaultAudience = defaultAudience;
                this.isLegacy = isLegacy;
                this.applicationId = applicationId;
                this.validateSameFbidAsToken = validateSameFbidAsToken;
            }

            private Object readResolve() {
                return new AuthorizationRequest(this.loginBehavior, this.requestCode, this.permissions, this.defaultAudience, this.isLegacy, this.applicationId, this.validateSameFbidAsToken);
            }
        }
    }

    private class AutoPublishAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private final String mApplicationId;
        private final Context mApplicationContext;

        public AutoPublishAsyncTask(String applicationId, Context context) {
            this.mApplicationId = applicationId;
            this.mApplicationContext = context.getApplicationContext();
        }

        protected Void doInBackground(Void ... voids) {
            try {
                Settings.publishInstallAndWaitForResponse(this.mApplicationContext, this.mApplicationId, true);
            }
            catch (Exception e) {
                Utility.logd("Facebook-publish", e);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPostExecute(Void result) {
            Session session = Session.this;
            synchronized (session) {
                Session.this.autoPublishAsyncTask = null;
            }
        }
    }

    static interface StartActivityDelegate {
        public void startActivityForResult(Intent var1, int var2);

        public Activity getActivityContext();
    }

    public static final class Builder {
        private final Context context;
        private String applicationId;
        private TokenCachingStrategy tokenCachingStrategy;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder setTokenCachingStrategy(TokenCachingStrategy tokenCachingStrategy) {
            this.tokenCachingStrategy = tokenCachingStrategy;
            return this;
        }

        public Session build() {
            return new Session(this.context, this.applicationId, this.tokenCachingStrategy);
        }
    }

    public static interface StatusCallback {
        public void call(Session var1, SessionState var2, Exception var3);
    }

    static class TokenRefreshRequestHandler
    extends Handler {
        private WeakReference<Session> sessionWeakReference;
        private WeakReference<TokenRefreshRequest> refreshRequestWeakReference;

        TokenRefreshRequestHandler(Session session, TokenRefreshRequest refreshRequest) {
            super(Looper.getMainLooper());
            this.sessionWeakReference = new WeakReference<Session>(session);
            this.refreshRequestWeakReference = new WeakReference<TokenRefreshRequest>(refreshRequest);
        }

        public void handleMessage(Message msg) {
            TokenRefreshRequest request;
            String token = msg.getData().getString("access_token");
            Session session = (Session)this.sessionWeakReference.get();
            if (session != null && token != null) {
                session.extendTokenCompleted(msg.getData());
            }
            if ((request = (TokenRefreshRequest)this.refreshRequestWeakReference.get()) != null) {
                staticContext.unbindService((ServiceConnection)request);
                request.cleanup();
            }
        }
    }

    class TokenRefreshRequest
    implements ServiceConnection {
        final Messenger messageReceiver;
        Messenger messageSender;

        TokenRefreshRequest() {
            this.messageReceiver = new Messenger((Handler)new TokenRefreshRequestHandler(Session.this, this));
            this.messageSender = null;
        }

        public void bind() {
            Intent intent = NativeProtocol.createTokenRefreshIntent(Session.getStaticContext());
            if (intent != null && staticContext.bindService(intent, (ServiceConnection)this, 1)) {
                Session.this.setLastAttemptedTokenExtendDate(new Date());
            } else {
                this.cleanup();
            }
        }

        public void onServiceConnected(ComponentName className, IBinder service) {
            this.messageSender = new Messenger(service);
            this.refreshToken();
        }

        public void onServiceDisconnected(ComponentName arg) {
            this.cleanup();
            staticContext.unbindService((ServiceConnection)this);
        }

        private void cleanup() {
            if (Session.this.currentTokenRefreshRequest == this) {
                Session.this.currentTokenRefreshRequest = null;
            }
        }

        private void refreshToken() {
            Bundle requestData = new Bundle();
            requestData.putString("access_token", Session.this.getTokenInfo().getToken());
            Message request = Message.obtain();
            request.setData(requestData);
            request.replyTo = this.messageReceiver;
            try {
                this.messageSender.send(request);
            }
            catch (RemoteException e) {
                this.cleanup();
            }
        }
    }

    static class PermissionsPair {
        List<String> grantedPermissions;
        List<String> declinedPermissions;

        public PermissionsPair(List<String> grantedPermissions, List<String> declinedPermissions) {
            this.grantedPermissions = grantedPermissions;
            this.declinedPermissions = declinedPermissions;
        }

        public List<String> getGrantedPermissions() {
            return this.grantedPermissions;
        }

        public List<String> getDeclinedPermissions() {
            return this.declinedPermissions;
        }
    }

    private static class SerializationProxyV2
    implements Serializable {
        private static final long serialVersionUID = 7663436173185080064L;
        private final String applicationId;
        private final SessionState state;
        private final AccessToken tokenInfo;
        private final Date lastAttemptedTokenExtendDate;
        private final boolean shouldAutoPublish;
        private final AuthorizationRequest pendingAuthorizationRequest;
        private final Set<String> requestedPermissions;

        SerializationProxyV2(String applicationId, SessionState state, AccessToken tokenInfo, Date lastAttemptedTokenExtendDate, boolean shouldAutoPublish, AuthorizationRequest pendingAuthorizationRequest, Set<String> requestedPermissions) {
            this.applicationId = applicationId;
            this.state = state;
            this.tokenInfo = tokenInfo;
            this.lastAttemptedTokenExtendDate = lastAttemptedTokenExtendDate;
            this.shouldAutoPublish = shouldAutoPublish;
            this.pendingAuthorizationRequest = pendingAuthorizationRequest;
            this.requestedPermissions = requestedPermissions;
        }

        private Object readResolve() {
            return new Session(this.applicationId, this.state, this.tokenInfo, this.lastAttemptedTokenExtendDate, this.shouldAutoPublish, this.pendingAuthorizationRequest, this.requestedPermissions);
        }
    }

    private static class SerializationProxyV1
    implements Serializable {
        private static final long serialVersionUID = 7663436173185080063L;
        private final String applicationId;
        private final SessionState state;
        private final AccessToken tokenInfo;
        private final Date lastAttemptedTokenExtendDate;
        private final boolean shouldAutoPublish;
        private final AuthorizationRequest pendingAuthorizationRequest;

        SerializationProxyV1(String applicationId, SessionState state, AccessToken tokenInfo, Date lastAttemptedTokenExtendDate, boolean shouldAutoPublish, AuthorizationRequest pendingAuthorizationRequest) {
            this.applicationId = applicationId;
            this.state = state;
            this.tokenInfo = tokenInfo;
            this.lastAttemptedTokenExtendDate = lastAttemptedTokenExtendDate;
            this.shouldAutoPublish = shouldAutoPublish;
            this.pendingAuthorizationRequest = pendingAuthorizationRequest;
        }

        private Object readResolve() {
            return new Session(this.applicationId, this.state, this.tokenInfo, this.lastAttemptedTokenExtendDate, this.shouldAutoPublish, this.pendingAuthorizationRequest);
        }
    }
}

