/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.facebook.AppEventsLogger;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.Session;
import com.facebook.android.R;
import com.facebook.model.GraphUser;
import com.facebook.widget.GraphObjectPagingLoader;
import com.facebook.widget.PickerFragment;
import com.facebook.widget.SimpleGraphObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FriendPickerFragment
extends PickerFragment<GraphUser> {
    public static final String USER_ID_BUNDLE_KEY = "com.facebook.widget.FriendPickerFragment.UserId";
    public static final String MULTI_SELECT_BUNDLE_KEY = "com.facebook.widget.FriendPickerFragment.MultiSelect";
    public static final String FRIEND_PICKER_TYPE_KEY = "com.facebook.widget.FriendPickerFragment.FriendPickerType";
    private static final String ID = "id";
    private static final String NAME = "name";
    private String userId;
    private boolean multiSelect = true;
    private FriendPickerType friendPickerType = FriendPickerType.FRIENDS;
    private List<String> preSelectedFriendIds = new ArrayList<String>();

    public FriendPickerFragment() {
        this(null);
    }

    @SuppressLint(value={"ValidFragment"})
    public FriendPickerFragment(Bundle args) {
        super(GraphUser.class, R.layout.com_facebook_friendpickerfragment, args);
        this.setFriendPickerSettingsFromBundle(args);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean getMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        if (this.multiSelect != multiSelect) {
            this.multiSelect = multiSelect;
            this.setSelectionStrategy(this.createSelectionStrategy());
        }
    }

    public void setFriendPickerType(FriendPickerType type) {
        this.friendPickerType = type;
    }

    public void setSelectionByIds(List<String> userIds) {
        this.preSelectedFriendIds.addAll(userIds);
    }

    public void setSelectionByIds(String ... userIds) {
        this.setSelectionByIds(Arrays.asList(userIds));
    }

    public void setSelection(GraphUser ... graphUsers) {
        this.setSelection(Arrays.asList(graphUsers));
    }

    public void setSelection(List<GraphUser> graphUsers) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (GraphUser graphUser : graphUsers) {
            userIds.add(graphUser.getId());
        }
        this.setSelectionByIds(userIds);
    }

    public List<GraphUser> getSelection() {
        return this.getSelectedGraphObjects();
    }

    @Override
    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        TypedArray a = activity.obtainStyledAttributes(attrs, R.styleable.com_facebook_friend_picker_fragment);
        this.setMultiSelect(a.getBoolean(0, this.multiSelect));
        a.recycle();
    }

    @Override
    public void setSettingsFromBundle(Bundle inState) {
        super.setSettingsFromBundle(inState);
        this.setFriendPickerSettingsFromBundle(inState);
    }

    @Override
    void saveSettingsToBundle(Bundle outState) {
        super.saveSettingsToBundle(outState);
        outState.putString(USER_ID_BUNDLE_KEY, this.userId);
        outState.putBoolean(MULTI_SELECT_BUNDLE_KEY, this.multiSelect);
    }

    @Override
    PickerFragment.PickerFragmentAdapter<GraphUser> createAdapter() {
        PickerFragment.PickerFragmentAdapter<GraphUser> adapter = new PickerFragment.PickerFragmentAdapter<GraphUser>((Context)this.getActivity()){

            @Override
            protected int getGraphObjectRowLayoutId(GraphUser graphObject) {
                return R.layout.com_facebook_picker_list_row;
            }

            @Override
            protected int getDefaultPicture() {
                return R.drawable.com_facebook_profile_default_icon;
            }
        };
        adapter.setShowCheckbox(true);
        adapter.setShowPicture(this.getShowPictures());
        adapter.setSortFields(Arrays.asList(NAME));
        adapter.setGroupByField(NAME);
        return adapter;
    }

    @Override
    PickerFragment.LoadingStrategy createLoadingStrategy() {
        return new ImmediateLoadingStrategy();
    }

    @Override
    PickerFragment.SelectionStrategy createSelectionStrategy() {
        return this.multiSelect ? new PickerFragment.MultiSelectionStrategy(this) : new PickerFragment.SingleSelectionStrategy(this);
    }

    @Override
    Request getRequestForLoadData(Session session) {
        if (this.adapter == null) {
            throw new FacebookException("Can't issue requests until Fragment has been created.");
        }
        String userToFetch = this.userId != null ? this.userId : "me";
        return this.createRequest(userToFetch, this.extraFields, session);
    }

    @Override
    String getDefaultTitleText() {
        return this.getString(R.string.com_facebook_choose_friends);
    }

    @Override
    void logAppEvents(boolean doneButtonClicked) {
        AppEventsLogger logger = AppEventsLogger.newLogger((Context)this.getActivity(), this.getSession());
        Bundle parameters = new Bundle();
        String outcome = doneButtonClicked ? "Completed" : "Unknown";
        parameters.putString("fb_dialog_outcome", outcome);
        parameters.putInt("num_friends_picked", this.getSelection().size());
        logger.logSdkEvent("fb_friend_picker_usage", null, parameters);
    }

    @Override
    public void loadData(boolean forceReload) {
        super.loadData(forceReload);
        this.setSelectedGraphObjects(this.preSelectedFriendIds);
    }

    private Request createRequest(String userID, Set<String> extraFields, Session session) {
        Request request = Request.newGraphPathRequest(session, userID + this.friendPickerType.getRequestPath(), null);
        HashSet<String> fields = new HashSet<String>(extraFields);
        String[] requiredFields = new String[]{ID, NAME};
        fields.addAll(Arrays.asList(requiredFields));
        String pictureField = this.adapter.getPictureFieldSpecifier();
        if (pictureField != null) {
            fields.add(pictureField);
        }
        Bundle parameters = request.getParameters();
        parameters.putString("fields", TextUtils.join((CharSequence)",", fields));
        request.setParameters(parameters);
        return request;
    }

    private void setFriendPickerSettingsFromBundle(Bundle inState) {
        if (inState != null) {
            if (inState.containsKey(USER_ID_BUNDLE_KEY)) {
                this.setUserId(inState.getString(USER_ID_BUNDLE_KEY));
            }
            this.setMultiSelect(inState.getBoolean(MULTI_SELECT_BUNDLE_KEY, this.multiSelect));
            if (inState.containsKey(FRIEND_PICKER_TYPE_KEY)) {
                try {
                    this.friendPickerType = FriendPickerType.valueOf(inState.getString(FRIEND_PICKER_TYPE_KEY));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class ImmediateLoadingStrategy
    extends PickerFragment.LoadingStrategy {
        private ImmediateLoadingStrategy() {
            super(FriendPickerFragment.this);
        }

        protected void onLoadFinished(GraphObjectPagingLoader<GraphUser> loader, SimpleGraphObjectCursor<GraphUser> data) {
            super.onLoadFinished(loader, data);
            if (data == null || loader.isLoading()) {
                return;
            }
            if (data.areMoreObjectsAvailable()) {
                this.followNextLink();
            } else {
                FriendPickerFragment.this.hideActivityCircle();
                if (data.isFromCache()) {
                    loader.refreshOriginalRequest(data.getCount() == 0 ? 2000L : 0L);
                }
            }
        }

        @Override
        protected boolean canSkipRoundTripIfCached() {
            return FriendPickerFragment.this.friendPickerType.isCacheable();
        }

        private void followNextLink() {
            FriendPickerFragment.this.displayActivityCircle();
            this.loader.followNextLink();
        }
    }

    public static enum FriendPickerType {
        FRIENDS("/friends", true),
        TAGGABLE_FRIENDS("/taggable_friends", false),
        INVITABLE_FRIENDS("/invitable_friends", false);

        private final String requestPath;
        private final boolean requestIsCacheable;

        private FriendPickerType(String path, boolean cacheable) {
            this.requestPath = path;
            this.requestIsCacheable = cacheable;
        }

        String getRequestPath() {
            return this.requestPath;
        }

        boolean isCacheable() {
            return this.requestIsCacheable;
        }
    }
}

