/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.facebook.AppEventsLogger;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.Settings;
import com.facebook.internal.LikeActionController;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.PendingCallStore;
import com.facebook.widget.FacebookDialog;
import java.util.UUID;

public class UiLifecycleHelper {
    private static final String DIALOG_CALL_ID_SAVE_KEY = "com.facebook.UiLifecycleHelper.pendingFacebookDialogCallKey";
    private static final String ACTIVITY_NULL_MESSAGE = "activity cannot be null";
    private final Activity activity;
    private final Session.StatusCallback callback;
    private final BroadcastReceiver receiver;
    private final LocalBroadcastManager broadcastManager;
    private UUID pendingFacebookDialogCallId;
    private PendingCallStore pendingFacebookDialogCallStore;
    private AppEventsLogger appEventsLogger;

    public UiLifecycleHelper(Activity activity, Session.StatusCallback callback) {
        if (activity == null) {
            throw new IllegalArgumentException(ACTIVITY_NULL_MESSAGE);
        }
        this.activity = activity;
        this.callback = callback;
        this.receiver = new ActiveSessionBroadcastReceiver();
        this.broadcastManager = LocalBroadcastManager.getInstance((Context)activity);
        this.pendingFacebookDialogCallStore = PendingCallStore.getInstance();
        Settings.sdkInitialize((Context)activity);
    }

    public void onCreate(Bundle savedInstanceState) {
        Session session = Session.getActiveSession();
        if (session == null) {
            if (savedInstanceState != null) {
                session = Session.restoreSession((Context)this.activity, null, this.callback, savedInstanceState);
            }
            if (session == null) {
                session = new Session((Context)this.activity);
            }
            Session.setActiveSession(session);
        }
        if (savedInstanceState != null) {
            String callIdString = savedInstanceState.getString(DIALOG_CALL_ID_SAVE_KEY);
            if (callIdString != null) {
                this.pendingFacebookDialogCallId = UUID.fromString(callIdString);
            }
            this.pendingFacebookDialogCallStore.restoreFromSavedInstanceState(savedInstanceState);
        }
    }

    public void onResume() {
        Session session = Session.getActiveSession();
        if (session != null) {
            if (this.callback != null) {
                session.addCallback(this.callback);
            }
            if (SessionState.CREATED_TOKEN_LOADED.equals((Object)session.getState())) {
                session.openForRead(null);
            }
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.facebook.sdk.ACTIVE_SESSION_SET");
        filter.addAction("com.facebook.sdk.ACTIVE_SESSION_UNSET");
        this.broadcastManager.registerReceiver(this.receiver, filter);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.onActivityResult(requestCode, resultCode, data, null);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data, FacebookDialog.Callback facebookDialogCallback) {
        Session session = Session.getActiveSession();
        if (session != null) {
            session.onActivityResult(this.activity, requestCode, resultCode, data);
        }
        if (LikeActionController.handleOnActivityResult((Context)this.activity, requestCode, resultCode, data)) {
            return;
        }
        this.handleFacebookDialogActivityResult(requestCode, resultCode, data, facebookDialogCallback);
    }

    public void onSaveInstanceState(Bundle outState) {
        Session.saveSession(Session.getActiveSession(), outState);
        if (this.pendingFacebookDialogCallId != null) {
            outState.putString(DIALOG_CALL_ID_SAVE_KEY, this.pendingFacebookDialogCallId.toString());
        }
        this.pendingFacebookDialogCallStore.saveInstanceState(outState);
    }

    public void onPause() {
        Session session;
        this.broadcastManager.unregisterReceiver(this.receiver);
        if (this.callback != null && (session = Session.getActiveSession()) != null) {
            session.removeCallback(this.callback);
        }
    }

    public void onStop() {
        AppEventsLogger.onContextStop();
    }

    public void onDestroy() {
    }

    public void trackPendingDialogCall(FacebookDialog.PendingCall pendingCall) {
        if (this.pendingFacebookDialogCallId != null) {
            Log.i((String)"Facebook", (String)"Tracking new app call while one is still pending; canceling pending call.");
            this.cancelPendingAppCall(null);
        }
        if (pendingCall != null) {
            this.pendingFacebookDialogCallId = pendingCall.getCallId();
            this.pendingFacebookDialogCallStore.trackPendingCall(pendingCall);
        }
    }

    public AppEventsLogger getAppEventsLogger() {
        Session session = Session.getActiveSession();
        if (session == null) {
            return null;
        }
        if (this.appEventsLogger == null || !this.appEventsLogger.isValidForSession(session)) {
            if (this.appEventsLogger != null) {
                AppEventsLogger.onContextStop();
            }
            this.appEventsLogger = AppEventsLogger.newLogger((Context)this.activity, session);
        }
        return this.appEventsLogger;
    }

    private boolean handleFacebookDialogActivityResult(int requestCode, int resultCode, Intent data, FacebookDialog.Callback facebookDialogCallback) {
        if (this.pendingFacebookDialogCallId == null) {
            return false;
        }
        FacebookDialog.PendingCall pendingCall = this.pendingFacebookDialogCallStore.getPendingCallById(this.pendingFacebookDialogCallId);
        if (pendingCall == null || pendingCall.getRequestCode() != requestCode) {
            return false;
        }
        if (data == null) {
            this.cancelPendingAppCall(facebookDialogCallback);
            return true;
        }
        UUID callId = NativeProtocol.getCallIdFromIntent(data);
        if (callId != null && this.pendingFacebookDialogCallId.equals(callId)) {
            FacebookDialog.handleActivityResult((Context)this.activity, pendingCall, requestCode, data, facebookDialogCallback);
        } else {
            this.cancelPendingAppCall(facebookDialogCallback);
        }
        this.stopTrackingPendingAppCall();
        return true;
    }

    private void cancelPendingAppCall(FacebookDialog.Callback facebookDialogCallback) {
        if (this.pendingFacebookDialogCallId == null) {
            return;
        }
        FacebookDialog.PendingCall pendingCall = this.pendingFacebookDialogCallStore.getPendingCallById(this.pendingFacebookDialogCallId);
        if (pendingCall == null) {
            return;
        }
        if (facebookDialogCallback != null) {
            Intent pendingIntent = pendingCall.getRequestIntent();
            Intent cancelIntent = new Intent();
            cancelIntent.putExtra("com.facebook.platform.protocol.CALL_ID", pendingIntent.getStringExtra("com.facebook.platform.protocol.CALL_ID"));
            cancelIntent.putExtra("com.facebook.platform.protocol.PROTOCOL_ACTION", pendingIntent.getStringExtra("com.facebook.platform.protocol.PROTOCOL_ACTION"));
            cancelIntent.putExtra("com.facebook.platform.protocol.PROTOCOL_VERSION", pendingIntent.getIntExtra("com.facebook.platform.protocol.PROTOCOL_VERSION", 0));
            cancelIntent.putExtra("com.facebook.platform.status.ERROR_TYPE", "UnknownError");
            FacebookDialog.handleActivityResult((Context)this.activity, pendingCall, pendingCall.getRequestCode(), cancelIntent, facebookDialogCallback);
        }
        this.stopTrackingPendingAppCall();
    }

    private void stopTrackingPendingAppCall() {
        this.pendingFacebookDialogCallStore.stopTrackingPendingCall(this.pendingFacebookDialogCallId);
        this.pendingFacebookDialogCallId = null;
    }

    private class ActiveSessionBroadcastReceiver
    extends BroadcastReceiver {
        private ActiveSessionBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Session session;
            if ("com.facebook.sdk.ACTIVE_SESSION_SET".equals(intent.getAction())) {
                Session session2 = Session.getActiveSession();
                if (session2 != null && UiLifecycleHelper.this.callback != null) {
                    session2.addCallback(UiLifecycleHelper.this.callback);
                }
            } else if ("com.facebook.sdk.ACTIVE_SESSION_UNSET".equals(intent.getAction()) && (session = Session.getActiveSession()) != null && UiLifecycleHelper.this.callback != null) {
                session.removeCallback(UiLifecycleHelper.this.callback);
            }
        }
    }
}

