/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.GraphUtil;
import com.facebook.internal.NativeAppCallAttachmentStore;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.share.Sharer;
import com.facebook.share.internal.OpenGraphJSONUtility;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.widget.LikeView;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ShareInternalUtility {
    private static final String OBJECT_PARAM = "object";
    private static final String MY_PHOTOS = "me/photos";
    private static final String MY_VIDEOS = "me/videos";
    private static final String MY_FEED = "me/feed";
    private static final String MY_STAGING_RESOURCES = "me/staging_resources";
    private static final String MY_OBJECTS_FORMAT = "me/objects/%s";
    private static final String MY_ACTION_FORMAT = "me/%s";
    private static final String PICTURE_PARAM = "picture";
    private static final String STAGING_PARAM = "file";

    public static void invokeCallbackWithException(FacebookCallback<Sharer.Result> callback, Exception exception) {
        if (exception instanceof FacebookException) {
            ShareInternalUtility.invokeOnErrorCallback(callback, (FacebookException)exception);
            return;
        }
        ShareInternalUtility.invokeCallbackWithError(callback, "Error preparing share content: " + exception.getLocalizedMessage());
    }

    public static void invokeCallbackWithError(FacebookCallback<Sharer.Result> callback, String error) {
        ShareInternalUtility.invokeOnErrorCallback(callback, error);
    }

    public static void invokeCallbackWithResults(FacebookCallback<Sharer.Result> callback, String postId, GraphResponse graphResponse) {
        FacebookRequestError requestError = graphResponse.getError();
        if (requestError != null) {
            String errorMessage = requestError.getErrorMessage();
            if (Utility.isNullOrEmpty(errorMessage)) {
                errorMessage = "Unexpected error sharing.";
            }
            ShareInternalUtility.invokeOnErrorCallback(callback, graphResponse, errorMessage);
        } else {
            ShareInternalUtility.invokeOnSuccessCallback(callback, postId);
        }
    }

    public static boolean getNativeDialogDidComplete(Bundle result) {
        if (result.containsKey("didComplete")) {
            return result.getBoolean("didComplete");
        }
        return result.getBoolean("com.facebook.platform.extra.DID_COMPLETE", false);
    }

    public static String getNativeDialogCompletionGesture(Bundle result) {
        if (result.containsKey("completionGesture")) {
            return result.getString("completionGesture");
        }
        return result.getString("com.facebook.platform.extra.COMPLETION_GESTURE");
    }

    public static String getShareDialogPostId(Bundle result) {
        if (result.containsKey("postId")) {
            return result.getString("postId");
        }
        if (result.containsKey("com.facebook.platform.extra.POST_ID")) {
            return result.getString("com.facebook.platform.extra.POST_ID");
        }
        return result.getString("post_id");
    }

    public static boolean handleActivityResult(int requestCode, int resultCode, Intent data, ResultProcessor resultProcessor) {
        AppCall appCall = ShareInternalUtility.getAppCallFromActivityResult(requestCode, resultCode, data);
        if (appCall == null) {
            return false;
        }
        NativeAppCallAttachmentStore.cleanupAttachmentsForCall(appCall.getCallId());
        if (resultProcessor == null) {
            return true;
        }
        FacebookException exception = NativeProtocol.getExceptionFromErrorData(NativeProtocol.getErrorDataFromResultIntent(data));
        if (exception != null) {
            if (exception instanceof FacebookOperationCanceledException) {
                resultProcessor.onCancel(appCall);
            } else {
                resultProcessor.onError(appCall, exception);
            }
        } else {
            Bundle results = NativeProtocol.getSuccessResultsFromIntent(data);
            resultProcessor.onSuccess(appCall, results);
        }
        return true;
    }

    public static ResultProcessor getShareResultProcessor(final FacebookCallback<Sharer.Result> callback) {
        return new ResultProcessor(callback){

            @Override
            public void onSuccess(AppCall appCall, Bundle results) {
                if (results != null) {
                    String gesture = ShareInternalUtility.getNativeDialogCompletionGesture(results);
                    if (gesture == null || "post".equalsIgnoreCase(gesture)) {
                        String postId = ShareInternalUtility.getShareDialogPostId(results);
                        ShareInternalUtility.invokeOnSuccessCallback(callback, postId);
                    } else if ("cancel".equalsIgnoreCase(gesture)) {
                        ShareInternalUtility.invokeOnCancelCallback(callback);
                    } else {
                        ShareInternalUtility.invokeOnErrorCallback((FacebookCallback<Sharer.Result>)callback, new FacebookException("UnknownError"));
                    }
                }
            }

            @Override
            public void onCancel(AppCall appCall) {
                ShareInternalUtility.invokeOnCancelCallback(callback);
            }

            @Override
            public void onError(AppCall appCall, FacebookException error) {
                ShareInternalUtility.invokeOnErrorCallback((FacebookCallback<Sharer.Result>)callback, error);
            }
        };
    }

    private static AppCall getAppCallFromActivityResult(int requestCode, int resultCode, Intent data) {
        UUID callId = NativeProtocol.getCallIdFromIntent(data);
        if (callId == null) {
            return null;
        }
        return AppCall.finishPendingCall(callId, requestCode);
    }

    public static void registerStaticShareCallback(final int requestCode) {
        CallbackManagerImpl.registerStaticCallback(requestCode, new CallbackManagerImpl.Callback(){

            @Override
            public boolean onActivityResult(int resultCode, Intent data) {
                return ShareInternalUtility.handleActivityResult(requestCode, resultCode, data, ShareInternalUtility.getShareResultProcessor(null));
            }
        });
    }

    public static void registerSharerCallback(final int requestCode, CallbackManager callbackManager, final FacebookCallback<Sharer.Result> callback) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        ((CallbackManagerImpl)callbackManager).registerCallback(requestCode, new CallbackManagerImpl.Callback(){

            @Override
            public boolean onActivityResult(int resultCode, Intent data) {
                return ShareInternalUtility.handleActivityResult(requestCode, resultCode, data, ShareInternalUtility.getShareResultProcessor(callback));
            }
        });
    }

    public static List<String> getPhotoUrls(SharePhotoContent photoContent, final UUID appCallId) {
        List<SharePhoto> photos;
        if (photoContent == null || (photos = photoContent.getPhotos()) == null) {
            return null;
        }
        List<NativeAppCallAttachmentStore.Attachment> attachments = Utility.map(photos, new Utility.Mapper<SharePhoto, NativeAppCallAttachmentStore.Attachment>(){

            @Override
            public NativeAppCallAttachmentStore.Attachment apply(SharePhoto item) {
                return ShareInternalUtility.getAttachment(appCallId, item);
            }
        });
        List<String> attachmentUrls = Utility.map(attachments, new Utility.Mapper<NativeAppCallAttachmentStore.Attachment, String>(){

            @Override
            public String apply(NativeAppCallAttachmentStore.Attachment item) {
                return item.getAttachmentUrl();
            }
        });
        NativeAppCallAttachmentStore.addAttachments(attachments);
        return attachmentUrls;
    }

    public static JSONObject toJSONObjectForCall(final UUID callId, ShareOpenGraphAction action) throws JSONException {
        final ArrayList<NativeAppCallAttachmentStore.Attachment> attachments = new ArrayList<NativeAppCallAttachmentStore.Attachment>();
        JSONObject actionJSON = OpenGraphJSONUtility.toJSONObject(action, new OpenGraphJSONUtility.PhotoJSONProcessor(){

            @Override
            public JSONObject toJSONObject(SharePhoto photo) {
                NativeAppCallAttachmentStore.Attachment attachment = ShareInternalUtility.getAttachment(callId, photo);
                if (attachment == null) {
                    return null;
                }
                attachments.add(attachment);
                JSONObject photoJSONObject = new JSONObject();
                try {
                    photoJSONObject.put("url", (Object)attachment.getAttachmentUrl());
                    if (photo.getUserGenerated()) {
                        photoJSONObject.put("user_generated", true);
                    }
                }
                catch (JSONException e) {
                    throw new FacebookException("Unable to attach images", e);
                }
                return photoJSONObject;
            }
        });
        NativeAppCallAttachmentStore.addAttachments(attachments);
        return actionJSON;
    }

    public static JSONObject toJSONObjectForWeb(ShareOpenGraphContent shareOpenGraphContent) throws JSONException {
        ShareOpenGraphAction action = shareOpenGraphContent.getAction();
        return OpenGraphJSONUtility.toJSONObject(action, new OpenGraphJSONUtility.PhotoJSONProcessor(){

            @Override
            public JSONObject toJSONObject(SharePhoto photo) {
                Uri photoUri = photo.getImageUrl();
                JSONObject photoJSONObject = new JSONObject();
                try {
                    photoJSONObject.put("url", (Object)photoUri.toString());
                }
                catch (JSONException e) {
                    throw new FacebookException("Unable to attach images", e);
                }
                return photoJSONObject;
            }
        });
    }

    public static JSONArray removeNamespacesFromOGJsonArray(JSONArray jsonArray, boolean requireNamespace) throws JSONException {
        JSONArray newArray = new JSONArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.get(i);
            if (value instanceof JSONArray) {
                value = ShareInternalUtility.removeNamespacesFromOGJsonArray((JSONArray)value, requireNamespace);
            } else if (value instanceof JSONObject) {
                value = ShareInternalUtility.removeNamespacesFromOGJsonObject((JSONObject)value, requireNamespace);
            }
            newArray.put(value);
        }
        return newArray;
    }

    public static JSONObject removeNamespacesFromOGJsonObject(JSONObject jsonObject, boolean requireNamespace) {
        if (jsonObject == null) {
            return null;
        }
        try {
            JSONObject newJsonObject = new JSONObject();
            JSONObject data = new JSONObject();
            JSONArray names = jsonObject.names();
            for (int i = 0; i < names.length(); ++i) {
                String key = names.getString(i);
                Object value = null;
                value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    value = ShareInternalUtility.removeNamespacesFromOGJsonObject((JSONObject)value, true);
                } else if (value instanceof JSONArray) {
                    value = ShareInternalUtility.removeNamespacesFromOGJsonArray((JSONArray)value, true);
                }
                Pair<String, String> fieldNameAndNamespace = ShareInternalUtility.getFieldNameAndNamespaceFromFullName(key);
                String namespace = (String)fieldNameAndNamespace.first;
                String fieldName = (String)fieldNameAndNamespace.second;
                if (requireNamespace) {
                    if (namespace != null && namespace.equals("fbsdk")) {
                        newJsonObject.put(key, value);
                        continue;
                    }
                    if (namespace == null || namespace.equals("og")) {
                        newJsonObject.put(fieldName, value);
                        continue;
                    }
                    data.put(fieldName, value);
                    continue;
                }
                newJsonObject.put(fieldName, value);
            }
            if (data.length() > 0) {
                newJsonObject.put("data", (Object)data);
            }
            return newJsonObject;
        }
        catch (JSONException e) {
            throw new FacebookException("Failed to create json object from share content");
        }
    }

    public static Pair<String, String> getFieldNameAndNamespaceFromFullName(String fullName) {
        String fieldName;
        String namespace = null;
        int index = fullName.indexOf(58);
        if (index != -1 && fullName.length() > index + 1) {
            namespace = fullName.substring(0, index);
            fieldName = fullName.substring(index + 1);
        } else {
            fieldName = fullName;
        }
        return new Pair(namespace, (Object)fieldName);
    }

    private ShareInternalUtility() {
    }

    private static NativeAppCallAttachmentStore.Attachment getAttachment(UUID callId, SharePhoto photo) {
        Bitmap bitmap = photo.getBitmap();
        Uri photoUri = photo.getImageUrl();
        NativeAppCallAttachmentStore.Attachment attachment = null;
        if (bitmap != null) {
            attachment = NativeAppCallAttachmentStore.createAttachment(callId, bitmap);
        } else if (photoUri != null) {
            attachment = NativeAppCallAttachmentStore.createAttachment(callId, photoUri);
        }
        return attachment;
    }

    private static void invokeOnCancelCallback(FacebookCallback<Sharer.Result> callback) {
        ShareInternalUtility.logShareResult("cancelled", null);
        if (callback != null) {
            callback.onCancel();
        }
    }

    private static void invokeOnSuccessCallback(FacebookCallback<Sharer.Result> callback, String postId) {
        ShareInternalUtility.logShareResult("succeeded", null);
        if (callback != null) {
            callback.onSuccess(new Sharer.Result(postId));
        }
    }

    private static void invokeOnErrorCallback(FacebookCallback<Sharer.Result> callback, GraphResponse response, String message) {
        ShareInternalUtility.logShareResult("error", message);
        if (callback != null) {
            callback.onError(new FacebookGraphResponseException(response, message));
        }
    }

    private static void invokeOnErrorCallback(FacebookCallback<Sharer.Result> callback, String message) {
        ShareInternalUtility.logShareResult("error", message);
        if (callback != null) {
            callback.onError(new FacebookException(message));
        }
    }

    private static void invokeOnErrorCallback(FacebookCallback<Sharer.Result> callback, FacebookException ex) {
        ShareInternalUtility.logShareResult("error", ex.getMessage());
        if (callback != null) {
            callback.onError(ex);
        }
    }

    private static void logShareResult(String shareOutcome, String errorMessage) {
        Context context = FacebookSdk.getApplicationContext();
        AppEventsLogger logger = AppEventsLogger.newLogger(context);
        Bundle parameters = new Bundle();
        parameters.putString("fb_share_dialog_outcome", shareOutcome);
        if (errorMessage != null) {
            parameters.putString("error_message", errorMessage);
        }
        logger.logSdkEvent("fb_share_dialog_result", null, parameters);
    }

    public static GraphRequest newPostOpenGraphObjectRequest(AccessToken accessToken, JSONObject openGraphObject, GraphRequest.Callback callback) {
        if (openGraphObject == null) {
            throw new FacebookException("openGraphObject cannot be null");
        }
        if (Utility.isNullOrEmpty(openGraphObject.optString("type"))) {
            throw new FacebookException("openGraphObject must have non-null 'type' property");
        }
        if (Utility.isNullOrEmpty(openGraphObject.optString("title"))) {
            throw new FacebookException("openGraphObject must have non-null 'title' property");
        }
        String path = String.format(MY_OBJECTS_FORMAT, openGraphObject.optString("type"));
        Bundle bundle = new Bundle();
        bundle.putString(OBJECT_PARAM, openGraphObject.toString());
        return new GraphRequest(accessToken, path, bundle, HttpMethod.POST, callback);
    }

    public static GraphRequest newPostOpenGraphObjectRequest(AccessToken accessToken, String type, String title, String imageUrl, String url, String description, JSONObject objectProperties, GraphRequest.Callback callback) {
        JSONObject openGraphObject = GraphUtil.createOpenGraphObjectForPost(type, title, imageUrl, url, description, objectProperties, null);
        return ShareInternalUtility.newPostOpenGraphObjectRequest(accessToken, openGraphObject, callback);
    }

    public static GraphRequest newPostOpenGraphActionRequest(AccessToken accessToken, JSONObject openGraphAction, GraphRequest.Callback callback) {
        if (openGraphAction == null) {
            throw new FacebookException("openGraphAction cannot be null");
        }
        String type = openGraphAction.optString("type");
        if (Utility.isNullOrEmpty(type)) {
            throw new FacebookException("openGraphAction must have non-null 'type' property");
        }
        String path = String.format(MY_ACTION_FORMAT, type);
        return GraphRequest.newPostRequest(accessToken, path, openGraphAction, callback);
    }

    public static GraphRequest newUpdateOpenGraphObjectRequest(AccessToken accessToken, JSONObject openGraphObject, GraphRequest.Callback callback) {
        if (openGraphObject == null) {
            throw new FacebookException("openGraphObject cannot be null");
        }
        String path = openGraphObject.optString("id");
        if (path == null) {
            throw new FacebookException("openGraphObject must have an id");
        }
        Bundle bundle = new Bundle();
        bundle.putString(OBJECT_PARAM, openGraphObject.toString());
        return new GraphRequest(accessToken, path, bundle, HttpMethod.POST, callback);
    }

    public static GraphRequest newUpdateOpenGraphObjectRequest(AccessToken accessToken, String id2, String title, String imageUrl, String url, String description, JSONObject objectProperties, GraphRequest.Callback callback) {
        JSONObject openGraphObject = GraphUtil.createOpenGraphObjectForPost(null, title, imageUrl, url, description, objectProperties, id2);
        return ShareInternalUtility.newUpdateOpenGraphObjectRequest(accessToken, openGraphObject, callback);
    }

    public static GraphRequest newUploadPhotoRequest(AccessToken accessToken, Bitmap image, GraphRequest.Callback callback) {
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)image);
        return new GraphRequest(accessToken, MY_PHOTOS, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newUploadPhotoRequest(AccessToken accessToken, File file, GraphRequest.Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)descriptor);
        return new GraphRequest(accessToken, MY_PHOTOS, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newUploadPhotoRequest(AccessToken accessToken, Uri photoUri, GraphRequest.Callback callback) throws FileNotFoundException {
        if (Utility.isFileUri(photoUri)) {
            return ShareInternalUtility.newUploadPhotoRequest(accessToken, new File(photoUri.getPath()), callback);
        }
        if (!Utility.isContentUri(photoUri)) {
            throw new FacebookException("The photo Uri must be either a file:// or content:// Uri");
        }
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)photoUri);
        return new GraphRequest(accessToken, MY_PHOTOS, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newUploadVideoRequest(AccessToken accessToken, File file, GraphRequest.Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(file.getName(), (Parcelable)descriptor);
        return new GraphRequest(accessToken, MY_VIDEOS, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newUploadVideoRequest(AccessToken accessToken, Uri videoUri, GraphRequest.Callback callback) throws FileNotFoundException {
        if (Utility.isFileUri(videoUri)) {
            return ShareInternalUtility.newUploadVideoRequest(accessToken, new File(videoUri.getPath()), callback);
        }
        if (!Utility.isContentUri(videoUri)) {
            throw new FacebookException("The video Uri must be either a file:// or content:// Uri");
        }
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)videoUri);
        return new GraphRequest(accessToken, MY_PHOTOS, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newStatusUpdateRequest(AccessToken accessToken, String message, GraphRequest.Callback callback) {
        return ShareInternalUtility.newStatusUpdateRequest(accessToken, message, (String)null, null, callback);
    }

    private static GraphRequest newStatusUpdateRequest(AccessToken accessToken, String message, String placeId, List<String> tagIds, GraphRequest.Callback callback) {
        Bundle parameters = new Bundle();
        parameters.putString("message", message);
        if (placeId != null) {
            parameters.putString("place", placeId);
        }
        if (tagIds != null && tagIds.size() > 0) {
            String tags = TextUtils.join((CharSequence)",", tagIds);
            parameters.putString("tags", tags);
        }
        return new GraphRequest(accessToken, MY_FEED, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newStatusUpdateRequest(AccessToken accessToken, String message, JSONObject place, List<JSONObject> tags, GraphRequest.Callback callback) {
        ArrayList<String> tagIds = null;
        if (tags != null) {
            tagIds = new ArrayList<String>(tags.size());
            for (JSONObject tag : tags) {
                tagIds.add(tag.optString("id"));
            }
        }
        String placeId = place == null ? null : place.optString("id");
        return ShareInternalUtility.newStatusUpdateRequest(accessToken, message, placeId, tagIds, callback);
    }

    public static GraphRequest newUploadStagingResourceWithImageRequest(AccessToken accessToken, Bitmap image, GraphRequest.Callback callback) {
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(STAGING_PARAM, (Parcelable)image);
        return new GraphRequest(accessToken, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newUploadStagingResourceWithImageRequest(AccessToken accessToken, File file, GraphRequest.Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        GraphRequest.ParcelableResourceWithMimeType<ParcelFileDescriptor> resourceWithMimeType = new GraphRequest.ParcelableResourceWithMimeType<ParcelFileDescriptor>(descriptor, "image/png");
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(STAGING_PARAM, resourceWithMimeType);
        return new GraphRequest(accessToken, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newUploadStagingResourceWithImageRequest(AccessToken accessToken, Uri imageUri, GraphRequest.Callback callback) throws FileNotFoundException {
        if (Utility.isFileUri(imageUri)) {
            return ShareInternalUtility.newUploadStagingResourceWithImageRequest(accessToken, new File(imageUri.getPath()), callback);
        }
        if (!Utility.isContentUri(imageUri)) {
            throw new FacebookException("The image Uri must be either a file:// or content:// Uri");
        }
        GraphRequest.ParcelableResourceWithMimeType<Uri> resourceWithMimeType = new GraphRequest.ParcelableResourceWithMimeType<Uri>(imageUri, "image/png");
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(STAGING_PARAM, resourceWithMimeType);
        return new GraphRequest(accessToken, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, callback);
    }

    @Nullable
    public static LikeView.ObjectType getMostSpecificObjectType(LikeView.ObjectType objectType1, LikeView.ObjectType objectType2) {
        if (objectType1 == objectType2) {
            return objectType1;
        }
        if (objectType1 == LikeView.ObjectType.UNKNOWN) {
            return objectType2;
        }
        if (objectType2 == LikeView.ObjectType.UNKNOWN) {
            return objectType1;
        }
        return null;
    }
}

