/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.facebook.FacebookException;
import com.facebook.LoggingBehavior;
import com.facebook.internal.Logger;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class AppEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private JSONObject jsonObject;
    private boolean isImplicit;
    private static final HashSet<String> validatedIdentifiers = new HashSet();
    private String name;

    public AppEvent(String contextName, String eventName, Double valueToSum, Bundle parameters, boolean isImplicitlyLogged, @Nullable UUID currentSessionId) {
        try {
            this.validateIdentifier(eventName);
            this.name = eventName;
            this.isImplicit = isImplicitlyLogged;
            this.jsonObject = new JSONObject();
            this.jsonObject.put("_eventName", (Object)eventName);
            this.jsonObject.put("_logTime", System.currentTimeMillis() / 1000L);
            this.jsonObject.put("_ui", (Object)contextName);
            if (currentSessionId != null) {
                this.jsonObject.put("_session_id", (Object)currentSessionId);
            }
            if (valueToSum != null) {
                this.jsonObject.put("_valueToSum", valueToSum.doubleValue());
            }
            if (this.isImplicit) {
                this.jsonObject.put("_implicitlyLogged", (Object)"1");
            }
            if (parameters != null) {
                for (String key : parameters.keySet()) {
                    this.validateIdentifier(key);
                    Object value = parameters.get(key);
                    if (!(value instanceof String) && !(value instanceof Number)) {
                        throw new FacebookException(String.format("Parameter value '%s' for key '%s' should be a string or a numeric type.", value, key));
                    }
                    this.jsonObject.put(key, (Object)value.toString());
                }
            }
            if (!this.isImplicit) {
                Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Created app event '%s'", this.jsonObject.toString());
            }
        }
        catch (JSONException jsonException) {
            Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "JSON encoding for app event failed: '%s'", jsonException.toString());
            this.jsonObject = null;
        }
        catch (FacebookException e) {
            Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Invalid app event name or parameter:", e.toString());
            this.jsonObject = null;
        }
    }

    public String getName() {
        return this.name;
    }

    private AppEvent(String jsonString, boolean isImplicit) throws JSONException {
        this.jsonObject = new JSONObject(jsonString);
        this.isImplicit = isImplicit;
    }

    public boolean getIsImplicit() {
        return this.isImplicit;
    }

    public JSONObject getJSONObject() {
        return this.jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateIdentifier(String identifier) throws FacebookException {
        String regex = "^[0-9a-zA-Z_]+[0-9a-zA-Z _-]*$";
        int MAX_IDENTIFIER_LENGTH = 40;
        if (identifier == null || identifier.length() == 0 || identifier.length() > 40) {
            if (identifier == null) {
                identifier = "<None Provided>";
            }
            throw new FacebookException(String.format(Locale.ROOT, "Identifier '%s' must be less than %d characters", identifier, 40));
        }
        boolean alreadyValidated = false;
        HashSet<String> hashSet = validatedIdentifiers;
        synchronized (hashSet) {
            alreadyValidated = validatedIdentifiers.contains(identifier);
        }
        if (!alreadyValidated) {
            if (identifier.matches("^[0-9a-zA-Z_]+[0-9a-zA-Z _-]*$")) {
                hashSet = validatedIdentifiers;
                synchronized (hashSet) {
                    validatedIdentifiers.add(identifier);
                }
            } else {
                throw new FacebookException(String.format("Skipping event named '%s' due to illegal name - must be under 40 chars and alphanumeric, _, - or space, and not start with a space or hyphen.", identifier));
            }
        }
    }

    private Object writeReplace() {
        return new SerializationProxyV1(this.jsonObject.toString(), this.isImplicit);
    }

    public String toString() {
        return String.format("\"%s\", implicit: %b, json: %s", this.jsonObject.optString("_eventName"), this.isImplicit, this.jsonObject.toString());
    }

    static class SerializationProxyV1
    implements Serializable {
        private static final long serialVersionUID = -2488473066578201069L;
        private final String jsonString;
        private final boolean isImplicit;

        private SerializationProxyV1(String jsonString, boolean isImplicit) {
            this.jsonString = jsonString;
            this.isImplicit = isImplicit;
        }

        private Object readResolve() throws JSONException {
            return new AppEvent(this.jsonString, this.isImplicit);
        }
    }
}

