/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.os.Bundle;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.share.internal.ShareFeedContent;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.AppGroupCreationContent;
import com.facebook.share.model.GameRequestContent;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareHashtag;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphContent;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class WebDialogParameters {
    public static Bundle create(AppGroupCreationContent appGroupCreationContent) {
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString(webParams, "name", appGroupCreationContent.getName());
        Utility.putNonEmptyString(webParams, "description", appGroupCreationContent.getDescription());
        AppGroupCreationContent.AppGroupPrivacy privacy = appGroupCreationContent.getAppGroupPrivacy();
        if (privacy != null) {
            Utility.putNonEmptyString(webParams, "privacy", privacy.toString().toLowerCase(Locale.ENGLISH));
        }
        return webParams;
    }

    public static Bundle create(GameRequestContent gameRequestContent) {
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString(webParams, "message", gameRequestContent.getMessage());
        Utility.putCommaSeparatedStringList(webParams, "to", gameRequestContent.getRecipients());
        Utility.putNonEmptyString(webParams, "title", gameRequestContent.getTitle());
        Utility.putNonEmptyString(webParams, "data", gameRequestContent.getData());
        if (gameRequestContent.getActionType() != null) {
            Utility.putNonEmptyString(webParams, "action_type", gameRequestContent.getActionType().toString().toLowerCase(Locale.ENGLISH));
        }
        Utility.putNonEmptyString(webParams, "object_id", gameRequestContent.getObjectId());
        if (gameRequestContent.getFilters() != null) {
            Utility.putNonEmptyString(webParams, "filters", gameRequestContent.getFilters().toString().toLowerCase(Locale.ENGLISH));
        }
        Utility.putCommaSeparatedStringList(webParams, "suggestions", gameRequestContent.getSuggestions());
        return webParams;
    }

    public static Bundle create(ShareLinkContent shareLinkContent) {
        Bundle params = WebDialogParameters.createBaseParameters(shareLinkContent);
        Utility.putUri(params, "href", shareLinkContent.getContentUrl());
        Utility.putNonEmptyString(params, "quote", shareLinkContent.getQuote());
        return params;
    }

    public static Bundle create(ShareOpenGraphContent shareOpenGraphContent) {
        Bundle params = WebDialogParameters.createBaseParameters(shareOpenGraphContent);
        Utility.putNonEmptyString(params, "action_type", shareOpenGraphContent.getAction().getActionType());
        try {
            JSONObject ogJSON = ShareInternalUtility.toJSONObjectForWeb(shareOpenGraphContent);
            ogJSON = ShareInternalUtility.removeNamespacesFromOGJsonObject(ogJSON, false);
            if (ogJSON != null) {
                Utility.putNonEmptyString(params, "action_properties", ogJSON.toString());
            }
        }
        catch (JSONException e) {
            throw new FacebookException("Unable to serialize the ShareOpenGraphContent to JSON", e);
        }
        return params;
    }

    public static Bundle createBaseParameters(ShareContent shareContent) {
        Bundle params = new Bundle();
        ShareHashtag shareHashtag = shareContent.getShareHashtag();
        if (shareHashtag != null) {
            Utility.putNonEmptyString(params, "hashtag", shareHashtag.getHashtag());
        }
        return params;
    }

    public static Bundle createForFeed(ShareLinkContent shareLinkContent) {
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString(webParams, "name", shareLinkContent.getContentTitle());
        Utility.putNonEmptyString(webParams, "description", shareLinkContent.getContentDescription());
        Utility.putNonEmptyString(webParams, "link", Utility.getUriString(shareLinkContent.getContentUrl()));
        Utility.putNonEmptyString(webParams, "picture", Utility.getUriString(shareLinkContent.getImageUrl()));
        Utility.putNonEmptyString(webParams, "quote", shareLinkContent.getQuote());
        ShareHashtag shareHashtag = shareLinkContent.getShareHashtag();
        if (shareHashtag != null) {
            Utility.putNonEmptyString(webParams, "hashtag", shareLinkContent.getShareHashtag().getHashtag());
        }
        return webParams;
    }

    public static Bundle createForFeed(ShareFeedContent shareFeedContent) {
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString(webParams, "to", shareFeedContent.getToId());
        Utility.putNonEmptyString(webParams, "link", shareFeedContent.getLink());
        Utility.putNonEmptyString(webParams, "picture", shareFeedContent.getPicture());
        Utility.putNonEmptyString(webParams, "source", shareFeedContent.getMediaSource());
        Utility.putNonEmptyString(webParams, "name", shareFeedContent.getLinkName());
        Utility.putNonEmptyString(webParams, "caption", shareFeedContent.getLinkCaption());
        Utility.putNonEmptyString(webParams, "description", shareFeedContent.getLinkDescription());
        return webParams;
    }
}

