/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.os.Bundle;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareVideoContent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeDialogParameters {
    public static Bundle create(UUID callId, ShareContent shareContent, boolean shouldFailOnDataError) {
        Validate.notNull(shareContent, "shareContent");
        Validate.notNull(callId, "callId");
        Bundle nativeParams = null;
        if (shareContent instanceof ShareLinkContent) {
            ShareLinkContent linkContent = (ShareLinkContent)shareContent;
            nativeParams = NativeDialogParameters.create(linkContent, shouldFailOnDataError);
        } else if (shareContent instanceof SharePhotoContent) {
            SharePhotoContent photoContent = (SharePhotoContent)shareContent;
            List<String> photoUrls = ShareInternalUtility.getPhotoUrls(photoContent, callId);
            nativeParams = NativeDialogParameters.create(photoContent, photoUrls, shouldFailOnDataError);
        } else if (shareContent instanceof ShareVideoContent) {
            ShareVideoContent videoContent = (ShareVideoContent)shareContent;
            String videoUrl = ShareInternalUtility.getVideoUrl(videoContent, callId);
            nativeParams = NativeDialogParameters.create(videoContent, videoUrl, shouldFailOnDataError);
        } else if (shareContent instanceof ShareOpenGraphContent) {
            ShareOpenGraphContent openGraphContent = (ShareOpenGraphContent)shareContent;
            try {
                JSONObject openGraphActionJSON = ShareInternalUtility.toJSONObjectForCall(callId, openGraphContent);
                openGraphActionJSON = ShareInternalUtility.removeNamespacesFromOGJsonObject(openGraphActionJSON, false);
                nativeParams = NativeDialogParameters.create(openGraphContent, openGraphActionJSON, shouldFailOnDataError);
            }
            catch (JSONException e) {
                throw new FacebookException("Unable to create a JSON Object from the provided ShareOpenGraphContent: " + e.getMessage());
            }
        }
        return nativeParams;
    }

    private static Bundle create(ShareLinkContent linkContent, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(linkContent, dataErrorsFatal);
        Utility.putNonEmptyString(params, "TITLE", linkContent.getContentTitle());
        Utility.putNonEmptyString(params, "DESCRIPTION", linkContent.getContentDescription());
        Utility.putUri(params, "IMAGE", linkContent.getImageUrl());
        return params;
    }

    private static Bundle create(SharePhotoContent photoContent, List<String> imageUrls, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(photoContent, dataErrorsFatal);
        params.putStringArrayList("PHOTOS", new ArrayList<String>(imageUrls));
        return params;
    }

    private static Bundle create(ShareVideoContent videoContent, String videoUrl, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(videoContent, dataErrorsFatal);
        Utility.putNonEmptyString(params, "TITLE", videoContent.getContentTitle());
        Utility.putNonEmptyString(params, "DESCRIPTION", videoContent.getContentDescription());
        Utility.putNonEmptyString(params, "VIDEO", videoUrl);
        return params;
    }

    private static Bundle create(ShareOpenGraphContent openGraphContent, JSONObject openGraphActionJSON, boolean dataErrorsFatal) {
        Bundle params = NativeDialogParameters.createBaseParameters(openGraphContent, dataErrorsFatal);
        String previewProperty = (String)ShareInternalUtility.getFieldNameAndNamespaceFromFullName((String)openGraphContent.getPreviewPropertyName()).second;
        Utility.putNonEmptyString(params, "PREVIEW_PROPERTY_NAME", previewProperty);
        Utility.putNonEmptyString(params, "ACTION_TYPE", openGraphContent.getAction().getActionType());
        Utility.putNonEmptyString(params, "ACTION", openGraphActionJSON.toString());
        return params;
    }

    private static Bundle createBaseParameters(ShareContent content, boolean dataErrorsFatal) {
        Bundle params = new Bundle();
        Utility.putUri(params, "LINK", content.getContentUrl());
        Utility.putNonEmptyString(params, "PLACE", content.getPlaceId());
        Utility.putNonEmptyString(params, "REF", content.getRef());
        params.putBoolean("DATA_FAILURES_FATAL", dataErrorsFatal);
        List<String> peopleIds = content.getPeopleIds();
        if (!Utility.isNullOrEmpty(peopleIds)) {
            params.putStringArrayList("FRIENDS", new ArrayList<String>(peopleIds));
        }
        return params;
    }
}

