/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.R;
import com.facebook.login.LoginClient;

public class LoginFragment
extends Fragment {
    static final String RESULT_KEY = "com.facebook.LoginFragment:Result";
    static final String EXTRA_REQUEST = "request";
    private static final String TAG = "LoginFragment";
    private static final String NULL_CALLING_PKG_ERROR_MSG = "Cannot call LoginFragment with a null calling package. This can occur if the launchMode of the caller is singleInstance.";
    private static final String SAVED_LOGIN_CLIENT = "loginClient";
    private String callingPackage;
    private LoginClient loginClient;
    private LoginClient.Request request;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.loginClient = (LoginClient)savedInstanceState.getParcelable(SAVED_LOGIN_CLIENT);
            this.loginClient.setFragment(this);
        } else {
            this.loginClient = new LoginClient(this);
        }
        this.loginClient.setOnCompletedListener(new LoginClient.OnCompletedListener(){

            @Override
            public void onCompleted(LoginClient.Result outcome) {
                LoginFragment.this.onLoginClientCompleted(outcome);
            }
        });
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.initializeCallingPackage((Activity)activity);
        if (activity.getIntent() != null) {
            Intent intent = activity.getIntent();
            intent.setExtrasClassLoader(LoginClient.Request.class.getClassLoader());
            this.request = (LoginClient.Request)intent.getParcelableExtra(EXTRA_REQUEST);
        }
    }

    public void onDestroy() {
        this.loginClient.cancelCurrentHandler();
        super.onDestroy();
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        final View view = inflater.inflate(R.layout.com_facebook_login_fragment, container, false);
        this.loginClient.setBackgroundProcessingListener(new LoginClient.BackgroundProcessingListener(){

            @Override
            public void onBackgroundProcessingStarted() {
                view.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(0);
            }

            @Override
            public void onBackgroundProcessingStopped() {
                view.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(8);
            }
        });
        return view;
    }

    private void onLoginClientCompleted(LoginClient.Result outcome) {
        this.request = null;
        int resultCode = outcome.code == LoginClient.Result.Code.CANCEL ? 0 : -1;
        Bundle bundle = new Bundle();
        bundle.putParcelable(RESULT_KEY, (Parcelable)outcome);
        Intent resultIntent = new Intent();
        resultIntent.putExtras(bundle);
        if (this.isAdded()) {
            this.getActivity().setResult(resultCode, resultIntent);
            this.getActivity().finish();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.callingPackage == null) {
            Log.e((String)TAG, (String)NULL_CALLING_PKG_ERROR_MSG);
            this.getActivity().finish();
            return;
        }
        this.loginClient.startOrContinueAuth(this.request);
    }

    public void onPause() {
        super.onPause();
        this.getActivity().findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(8);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.loginClient.onActivityResult(requestCode, resultCode, data);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(SAVED_LOGIN_CLIENT, (Parcelable)this.loginClient);
    }

    private void initializeCallingPackage(Activity activity) {
        ComponentName componentName = activity.getCallingActivity();
        if (componentName == null) {
            return;
        }
        this.callingPackage = componentName.getPackageName();
    }

    LoginClient getLoginClient() {
        return this.loginClient;
    }
}

