/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.Utility;
import com.facebook.login.GetTokenClient;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

class GetTokenLoginMethodHandler
extends LoginMethodHandler {
    private GetTokenClient getTokenClient;
    public static final Parcelable.Creator<GetTokenLoginMethodHandler> CREATOR = new Parcelable.Creator(){

        public GetTokenLoginMethodHandler createFromParcel(Parcel source) {
            return new GetTokenLoginMethodHandler(source);
        }

        public GetTokenLoginMethodHandler[] newArray(int size) {
            return new GetTokenLoginMethodHandler[size];
        }
    };

    GetTokenLoginMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    @Override
    String getNameForLogging() {
        return "get_token";
    }

    @Override
    void cancel() {
        if (this.getTokenClient != null) {
            this.getTokenClient.cancel();
            this.getTokenClient.setCompletedListener(null);
            this.getTokenClient = null;
        }
    }

    @Override
    int tryAuthorize(final LoginClient.Request request) {
        this.getTokenClient = new GetTokenClient((Context)this.loginClient.getActivity(), request);
        if (!this.getTokenClient.start()) {
            return 0;
        }
        this.loginClient.notifyBackgroundProcessingStart();
        PlatformServiceClient.CompletedListener callback = new PlatformServiceClient.CompletedListener(){

            @Override
            public void completed(Bundle result) {
                GetTokenLoginMethodHandler.this.getTokenCompleted(request, result);
            }
        };
        this.getTokenClient.setCompletedListener(callback);
        return 1;
    }

    void getTokenCompleted(LoginClient.Request request, Bundle result) {
        if (this.getTokenClient != null) {
            this.getTokenClient.setCompletedListener(null);
        }
        this.getTokenClient = null;
        this.loginClient.notifyBackgroundProcessingStop();
        if (result != null) {
            ArrayList currentPermissions = result.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
            Set<String> permissions = request.getPermissions();
            if (currentPermissions != null && (permissions == null || currentPermissions.containsAll(permissions))) {
                this.complete(request, result);
                return;
            }
            HashSet<String> newPermissions = new HashSet<String>();
            for (String permission2 : permissions) {
                if (currentPermissions.contains(permission2)) continue;
                newPermissions.add(permission2);
            }
            if (!newPermissions.isEmpty()) {
                this.addLoggingExtra("new_permissions", TextUtils.join((CharSequence)",", newPermissions));
            }
            request.setPermissions(newPermissions);
        }
        this.loginClient.tryNextHandler();
    }

    void onComplete(LoginClient.Request request, Bundle result) {
        AccessToken token = GetTokenLoginMethodHandler.createAccessTokenFromNativeLogin(result, AccessTokenSource.FACEBOOK_APPLICATION_SERVICE, request.getApplicationId());
        LoginClient.Result outcome = LoginClient.Result.createTokenResult(this.loginClient.getPendingRequest(), token);
        this.loginClient.completeAndValidate(outcome);
    }

    void complete(final LoginClient.Request request, final Bundle result) {
        String userId = result.getString("com.facebook.platform.extra.USER_ID");
        if (userId == null || userId.isEmpty()) {
            this.loginClient.notifyBackgroundProcessingStart();
            String accessToken = result.getString("com.facebook.platform.extra.ACCESS_TOKEN");
            Utility.getGraphMeRequestWithCacheAsync((String)accessToken, (Utility.GraphMeRequestWithCacheCallback)new Utility.GraphMeRequestWithCacheCallback(){

                public void onSuccess(JSONObject userInfo) {
                    try {
                        String userId = userInfo.getString("id");
                        result.putString("com.facebook.platform.extra.USER_ID", userId);
                        GetTokenLoginMethodHandler.this.onComplete(request, result);
                    }
                    catch (JSONException ex) {
                        GetTokenLoginMethodHandler.this.loginClient.complete(LoginClient.Result.createErrorResult(GetTokenLoginMethodHandler.this.loginClient.getPendingRequest(), "Caught exception", ex.getMessage()));
                    }
                }

                public void onFailure(FacebookException error) {
                    GetTokenLoginMethodHandler.this.loginClient.complete(LoginClient.Result.createErrorResult(GetTokenLoginMethodHandler.this.loginClient.getPendingRequest(), "Caught exception", error.getMessage()));
                }
            });
        } else {
            this.onComplete(request, result);
        }
    }

    GetTokenLoginMethodHandler(Parcel source) {
        super(source);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }
}

